.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86$
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XSetErrorHandler 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetErrorHandler, XGetErrorText, XDisplayName, XSetIOErrorHandler, XGetErrorDatabaseText \- default error handlers
.SH SYNTAX
int (*XSetErrorHandler\^(\^\fIhandler\fP\^)\^)\^(\^)
.br
      int (\^*\^\fIhandler\fP\^)\^(Display *, XErrorEvent *)
.LP
XGetErrorText\^(\^\fIdisplay\fP, \fIcode\fP, \fIbuffer_return\fP, \fIlength\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int \fIcode\fP\^;
.br
      char *\fIbuffer_return\fP\^;
.br
      int \fIlength\fP\^;
.LP
char *XDisplayName\^(\^\fIstring\fP\^)
.br
      char *\fIstring\fP\^;
.LP
int (*XSetIOErrorHandler\^(\^\fIhandler\fP\^)\^)\^(\^)
.br
      int (\^*\^\fIhandler\fP\^)(Display *);
.LP
XGetErrorDatabaseText\^(\^\fIdisplay\fP, \fIname\fP, \fImessage\fP, \fIdefault_string\fP, \fIbuffer_return\fP, \fIlength\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      char *\fIname\fP, *\fImessage\fP\^;
.br
      char *\fIdefault_string\fP\^;
.br
      char *\fIbuffer_return\fP\^;
.br
      int \fIlength\fP\^;
.SH ARGUMENTS
.IP \fIbuffer_return\fP 1i
Returns the error description.
.IP \fIcode\fP 1i
Specifies the error code for which you want to obtain a description.
.IP \fIdefault_string\fP 1i
Specifies the default error message if none is found in the database.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIhandler\fP 1i
Specifies the program's supplied error handler.
.IP \fIlength\fP 1i
Specifies the size of the buffer.
.IP \fImessage\fP 1i
Specifies the type of the error message.
.IP \fIname\fP 1i
Specifies the name of the application.
.IP \fIstring\fP 1i
Specifies the character string.
.SH DESCRIPTION
Xlib generally calls the program's
supplied error handler whenever an error is received.
It is not called on
.ZN BadName
errors from
.ZN OpenFont ,
.ZN LookupColor ,
or
.ZN AllocNamedColor
protocol requests or on
.ZN BadFont
errors from a
.ZN QueryFont
protocol request.
These errors generally are reflected back to the program through the
procedural interface.
Because this condition is not assumed to be fatal, 
it is acceptable for your error handler to return;
the returned value is ignored.
However, the error handler should not
call any functions (directly or indirectly) on the display
that will generate protocol requests or that will look for input events.
The previous error handler is returned.
.LP
The
.ZN XGetErrorText
function copies a null-terminated string describing the specified error code
into the specified buffer.
The returned text is in the encoding of the current locale.
It is recommended that you use this function to obtain an error description
because extensions to Xlib may define their own error codes
and error strings.
.LP
The
.ZN XDisplayName
function returns the name of the display that 
.ZN XOpenDisplay
would attempt to use.
If a NULL string is specified,
.ZN XDisplayName
looks in the environment for the display and returns the display name that
.ZN XOpenDisplay
would attempt to use.
This makes it easier to report to the user precisely which display the
program attempted to open when the initial connection attempt failed.
.LP
The
.ZN XSetIOErrorHandler
sets the fatal I/O error handler.
Xlib calls the program's supplied error handler if any sort of system call
error occurs (for example, the connection to the server was lost).
This is assumed to be a fatal condition,
and the called routine should not return.
If the I/O error handler does return,
the client process exits.
.LP
Note that the previous error handler is returned.
.LP
The
.ZN XGetErrorDatabaseText
function returns a null-terminated message
(or the default message) from the error message
database.
Xlib uses this function internally to look up its error messages.
The text in the default_string argument is assumed
to be in the encoding of the current locale,
and the text stored in the buffer_return argument
is in the encoding of the current locale.
.LP
The name argument should generally be the name of your application.
The message argument should indicate which type of error message you want.
If the name and message are not in the Host Portable Character Encoding,
the result is implementation-dependent.
Xlib uses three predefined ``application names'' to report errors.
In these names,
uppercase and lowercase matter.
.IP XProtoError 1i
The protocol error number is used as a string for the message argument.
.IP XlibMessage 1i
These are the message strings that are used internally by the library.
.IP XRequest 1i
For a core protocol request,
the major request protocol number is used for the message argument.
For an extension request,
the extension name (as given by
.ZN InitExtension )
followed by a period (\.) and the minor request protocol number 
is used for the message argument.
If no string is found in the error database,
the default_string is returned to the buffer argument.
.SH "SEE ALSO"
XOpenDisplay(3X11),
XSynchronize(3X11)
.br
\fI\*(xL\fP
