#############################################################
#
# util-linux
#
#############################################################
ifneq ($(USE_CVS),true)
#UTIL-LINUX_SOURCE:=util-linux-2.11z.tar.gz
UTIL-LINUX_SOURCE:=util-linux.tar.gz
UTIL-LINUX_SITE:=http://www.kernel.org/pub/linux/utils/util-linux
UTIL-LINUX_CAT:=zcat
endif

UTIL-LINUX_DIR:=$(BUILD_DIR)/util-linux
UTIL-LINUX_BINARY:=$(UTIL-LINUX_DIR)/misc-utils/mcookie
UTIL-LINUX_TARGET_BINARY:=$(TARGET_DIR)/usr/bin/mcookie

ifneq ($(USE_CVS),true)
util-linux-fetch:
	  $(WGET) -P $(DL_DIR) $(UTIL-LINUX_SITE)/$(UTIL-LINUX_SOURCE)
endif

UTIL-LINUX_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d util-linux $(CVS_TAG) $(CVS_PREFIX)util-linux

util-linux-checkout:
	@$(UTIL-LINUX_CVSCO)

$(UTIL-LINUX_DIR)/.unpacked: $(DL_DIR)/$(UTIL-LINUX_SOURCE)
ifneq ($(USE_CVS),true)
	$(UTIL-LINUX_CAT) $(DL_DIR)/$(UTIL-LINUX_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(UTIL-LINUX_CVSCO)
endif
	#cat $(SOURCE_DIR)/util-linux-fdisk-frv.patch | patch -d $(UTIL-LINUX_DIR) -p0
	touch $(UTIL-LINUX_DIR)/.unpacked

$(UTIL-LINUX_DIR)/.configured: $(UTIL-LINUX_DIR)/.unpacked
	(cd $(UTIL-LINUX_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	sed -i -e "s,^\(INSTALLSUID\)=.*,\1=\\$$\(INSTALL\) -m \\$$\(BINMODE\)," \
		-e "s,^\(USE_TTY_GROUP\)=.*,\1=no," \
		-e "s,^\(HAVE_PAM\)=.*,\1=yes," \
		-e "s,^\(HAVE_PASSWD\)=.*,\1=yes," \
		-e "s,^\(HAVE_SHADOW\)=.*,\1=no," \
		$(UTIL-LINUX_DIR)/MCONFIG
	touch $(UTIL-LINUX_DIR)/.configured

$(UTIL-LINUX_BINARY): $(UTIL-LINUX_DIR)/.configured
	$(MAKE) CPU=$(ARCH) CC=$(TARGET_CC) -C $(UTIL-LINUX_DIR)

$(UTIL-LINUX_TARGET_BINARY): $(UTIL-LINUX_BINARY)
	$(MAKE) CPU=$(ARCH) DESTDIR=$(TARGET_DIR) USE_TTY_GROUP=no -C $(UTIL-LINUX_DIR) install
	-rm -f $(TARGET_DIR)/usr/share/locale/*/LC_MESSAGES/util-linux.mo
	for prog in chfn chsh login ; do \
		install -m0644 $(UTIL-LINUX_DIR)/example.files/$${prog}.pam \
			$(TARGET_DIR)/etc/pam.d/$$prog ; \
	done
	install -d $(DOC_DIR)/doc/util-linux
	for f in MAINTAINER `find $(UTIL-LINUX_DIR) -name README.\* -o -name COPYING.\*` ; do \
		SRC=$(UTIL-LINUX_DIR)/`echo $$f | sed "s,^$(UTIL-LINUX_DIR),,"` ;\
		install -m0644 $$SRC $(DOC_DIR)/doc/util-linux/`basename $$f` ;\
	done

util-linux: uclibc pam zlib $(UTIL-LINUX_TARGET_BINARY)

util-linux-source: $(DL_DIR)/$(UTIL-LINUX_SOURCE)

util-linux-clean:
	#There is no working 'uninstall' target.  Just skip it... 
	#$(MAKE) DESTDIR=$(TARGET_DIR) -C $(UTIL-LINUX_DIR) uninstall
	@echo
	@echo "FIXME: util-linux doesn't know how to uninstall itself"
	@echo
	-rm -f $(UTIL-LINUX_TARGET_BINARY)
	-rm -rf $(DOC_DIR)/doc/util-linux
	-$(MAKE) -C $(UTIL-LINUX_DIR) clean

util-linux-dirclean:
	rm -rf $(UTIL-LINUX_DIR)


