#############################################################
#
# time
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
TIME_SOURCE:=time.tar.gz
TIME_CAT:=zcat
endif

TIME_DIR:=$(BUILD_DIR)/time
TIME_BINARY:=time
TIME_TARGET_BINARY:=usr/bin/time

ifneq ($(USE_CVS),true)
time-fetch:
	 $(WGET) -P $(DL_DIR) $(TIME_SITE)/$(TIME_SOURCE)

time-source: $(DL_DIR)/$(TIME_SOURCE)
else
time-source:
endif

TIME_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d time $(CVS_TAG) $(CVS_PREFIX)time

time-checkout:
	@$(TIME_CVSCO)

$(TIME_DIR)/.unpacked: $(DL_DIR)/$(TIME_SOURCE)
ifneq ($(USE_CVS),true)
	$(TIME_CAT) $(DL_DIR)/$(TIME_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(TIME_CVSCO)
endif
	sed -i -e 's,../mkinstalldirs,mkinstalldirs,' $(TIME_DIR)/Makefile.in
	touch $(TIME_DIR)/.unpacked

$(TIME_DIR)/.configured: $(TIME_DIR)/.unpacked
	(cd $(TIME_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS) -DHAVE_WAIT3" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(TIME_DIR)/.configured

$(TIME_DIR)/$(TIME_BINARY): $(TIME_DIR)/.configured
	$(MAKE) -C $(TIME_DIR)

$(TARGET_DIR)/$(TIME_TARGET_BINARY): $(TIME_DIR)/$(TIME_BINARY)
	$(MAKE) bindir=$(TARGET_DIR)/usr/bin infodir=$(TARGET_DIR)/usr/info -C $(TIME_DIR) install install-info
	$(STRIP) $(TARGET_DIR)/$(TIME_TARGET_BINARY)
	install -d $(DOC_DIR)/doc/time
	@for f in COPYING README ; do \
		install -m0644 $(TIME_DIR)/$$f $(DOC_DIR)/doc/time/$$f ;\
	done

time: uclibc $(TARGET_DIR)/$(TIME_TARGET_BINARY)

time-clean:
	-$(MAKE) bindir=$(TARGET_DIR)/usr/bin infodir=$(TARGET_DIR)/usr/info -C $(TIME_DIR) uninstall uninstall-info
	-rm -rf $(DOC_DIR)/doc/time
	-$(MAKE) -C $(TIME_DIR) clean

time-dirclean:
	rm -rf $(TIME_DIR)
endif

