#############################################################
#
# sendmail
#
#############################################################

ifneq ($(USE_CVS), true)
SENDMAIL_SOURCE:=sendmail.tar.gz
SENDMAIL_CAT:=zcat
endif

SENDMAIL_DIR:=$(BUILD_DIR)/sendmail

export SENDMAIL_SUFFIX=linux

SENDMAIL_OBJ = $(SENDMAIL_DIR)/obj.frv.linux

SENDMAIL_OPTIONS := $(TARGET_CONFIGURE_OPTS)

SENDMAIL_TARGET_DIRS := $(TARGET_DIR)/etc/mail \
			$(TARGET_DIR)/etc/smrsh \
			$(TARGET_DIR)/var/log/mail \
			$(TARGET_DIR)/var/spool/clientmqueue \
			$(TARGET_DIR)/var/spool/mail \
			$(TARGET_DIR)/var/spool/mqueue

SENDMAIL_BINARIES :=	$(SENDMAIL_OBJ)/sendmail/sendmail \
			$(SENDMAIL_OBJ)/rmail/rmail \
			$(SENDMAIL_OBJ)/mailstats/mailstats \
			$(SENDMAIL_OBJ)/makemap/makemap  \
			$(SENDMAIL_OBJ)/praliases/praliases \
			$(SENDMAIL_OBJ)/smrsh/smrsh

SENDMAIL_SBINTARGETS :=	$(TARGET_DIR)/usr/sbin/sendmail \
			$(TARGET_DIR)/usr/sbin/mailstats \
			$(TARGET_DIR)/usr/sbin/praliases \
			$(TARGET_DIR)/usr/sbin/smrsh

SENDMAIL_BINTARGETS :=	$(TARGET_DIR)/usr/bin/makemap \
			$(TARGET_DIR)/usr/bin/rmail

SENDMAIL_TARGET_BINLINKS :=	$(TARGET_DIR)/usr/bin/hoststat \
				$(TARGET_DIR)/usr/bin/mailq \
				$(TARGET_DIR)/usr/bin/newaliases \
				$(TARGET_DIR)/usr/bin/purgestat

SENDMAIL_CFGTARGETS :=	$(TARGET_DIR)/etc/mail/sendmail.cf \
			$(TARGET_DIR)/etc/mail/submit.cf \
			$(TARGET_DIR)/etc/mail/sendmail.mc \
			$(TARGET_DIR)/etc/mail/submit.mc \
			$(TARGET_DIR)/etc/rc.d/init.d/sendmail \
			$(TARGET_DIR)/etc/mail/local-host-names \
			$(TARGET_DIR)/etc/mail/trusted-users \
			$(TARGET_DIR)/etc/mail/access \
			$(TARGET_DIR)/etc/aliases \
			$(TARGET_DIR)/etc/sysconfig/sendmail

SENDMAIL_MANTARGETS:=	$(TARGET_DIR)/usr/man/man8/mailstats.8 \
			$(TARGET_DIR)/usr/man/man8/makemap.8 \
			$(TARGET_DIR)/usr/man/man8/smrsh.8 \
			$(TARGET_DIR)/usr/man/man8/praliases.8 \
			$(TARGET_DIR)/usr/man/man8/sendmail.8 \
			$(TARGET_DIR)/usr/man/man8/rmail.8 \
			$(TARGET_DIR)/usr/man/man5/aliases.5 \
			$(TARGET_DIR)/usr/man/man1/mailq.1

SENDMAIL_LIBTARGETS:=	$(TARGET_DIR)/usr/lib/sendmail.sendmail

SENDMAIL_DBTARGETS:=	$(TARGET_DIR)/etc/mail/virtusertable \
			$(TARGET_DIR)/etc/mail/domaintable \
			$(TARGET_DIR)/etc/mail/mailertable

sendmail:	uclibc \
	 	berkeleydb \
		initscripts \
		sendmail-target-dirs \
		sendmail-target-binlinks \
		sendmail-dbtargets \
		$(SENDMAIL_SBINTARGETS) \
		$(SENDMAIL_BINTARGETS) \
		$(SENDMAIL_MANTARGETS) \
		$(SENDMAIL_CFGTARGETS) \
		$(SENDMAIL_LIBTARGETS) \
		sendmail-var-spool \
		sendmail-var-mail

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(SENDMAIL_SOURCE):

sendmail-source: $(DL_DIR)/$(SENDMAIL_SOURCE)
else
sendmail-source:
endif

SENDMAIL_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d sendmail $(CVS_TAG) $(CVS_PREFIX)sendmail

sendmail-checkout:
	@$(SENDMAIL_CVSCO)

$(SENDMAIL_DIR)/.unpacked: $(DL_DIR)/$(SENDMAIL_SOURCE)
ifneq ($(USE_CVS), true)
	$(SENDMAIL_CAT) $(DL_DIR)/$(SENDMAIL_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SENDMAIL_CVSCO)
endif
	-cat $(SOURCE_DIR)/sendmail.patch | patch -p0 -d $(SENDMAIL_DIR)
	mkdir -p $(SENDMAIL_DIR)/obj.frv.linux
	cp $(SOURCE_DIR)/sendmail.init $(SENDMAIL_DIR)/contrib
	cp $(SOURCE_DIR)/sendmail-redhat.mc $(SENDMAIL_DIR)/cf/cf
	cp $(SOURCE_DIR)/sendmail-redhat.config.m4 $(SENDMAIL_DIR)/redhat.config.m4
	touch $(SENDMAIL_DIR)/.unpacked

$(SENDMAIL_BINARIES): $(SENDMAIL_DIR)/.unpacked
	$(MAKE) $(SENDMAIL_OPTIONS) -C $(SENDMAIL_DIR) CONFIG="-f ../redhat.config.m4" FLAGS=""
	(cd $(SENDMAIL_DIR)/cf/cf; umask 022; \
	mv -f submit.cf submit.cf.bak; \
	m4 ../m4/cf.m4 submit.mc > submit.cf; \
	sed -e 's|@@PATH@@|/usr/share/sendmail-cf|' < sendmail-redhat.mc > redhat.mc; \
	perl -pi -e 's:/etc/mail/statistics:/var/log/mail/statistics:' redhat.mc; \
	m4 ../m4/cf.m4 redhat.mc > redhat.cf; \
	)

sendmail-target-dirs: $(SENDMAIL_TARGET_DIRS)

$(SENDMAIL_TARGET_DIRS):
	@for d in $(SENDMAIL_TARGET_DIRS); do \
		[ -d $$d ] || mkdir -p $$d; \
		chmod 755 $$d; \
	done
# Clean up the exceptions...
	chmod 700 $(TARGET_DIR)/var/spool/mqueue
	chmod 775 $(TARGET_DIR)/var/spool/clientmqueue
	chmod 775 $(TARGET_DIR)/var/spool/mail

sendmail-var-mail: $(TARGET_DIR)/var/mail

$(TARGET_DIR)/var/mail: $(TARGET_DIR)/var/spool/mail
	-rm -rf $@
	ln -sf ../spool/mail $@

# Make sure the permissions are right on /var/spool itself
sendmail-var-spool:
	chmod 755 $(TARGET_DIR)/var/spool

sendmail-clean:
	rm -f $(SENDMAIL_SBINTARGETS) $(SENDMAIL_BINTARGETS) \
		$(SENDMAIL_CFTARGETS) $(SENDMAIL_MANTARGETS)
	rm -rf $(SENDMAIL_OBJ)

sendmail-dirclean:
	rm -rf $(SENDMAIL_DIR)

$(TARGET_DIR)/usr/sbin/sendmail: $(SENDMAIL_OBJ)/sendmail/sendmail
	install -m 0755 $(SENDMAIL_OBJ)/sendmail/sendmail $@
	frv-linux-gnu-strip $@

$(TARGET_DIR)/usr/sbin/mailstats: $(SENDMAIL_OBJ)/mailstats/mailstats
	install -m 0755 $(SENDMAIL_OBJ)/mailstats/mailstats $@
	frv-linux-gnu-strip $@

$(TARGET_DIR)/usr/sbin/praliases: $(SENDMAIL_OBJ)/praliases/praliases
	install -m 0755 $(SENDMAIL_OBJ)/praliases/praliases $@
	frv-linux-gnu-strip $@

$(TARGET_DIR)/usr/sbin/smrsh: $(SENDMAIL_OBJ)/smrsh/smrsh
	install -m 0755 $(SENDMAIL_OBJ)/smrsh/smrsh $@
	frv-linux-gnu-strip $@

$(TARGET_DIR)/usr/bin/makemap: $(SENDMAIL_OBJ)/makemap/makemap
	install -m 0755 $(SENDMAIL_OBJ)/makemap/makemap $@
	frv-linux-gnu-strip $@

$(TARGET_DIR)/usr/bin/rmail: $(SENDMAIL_OBJ)/rmail/rmail
	install -m 0755 $(SENDMAIL_OBJ)/rmail/rmail $@
	frv-linux-gnu-strip $@

$(TARGET_DIR)/etc/mail/sendmail.cf:	$(SENDMAIL_DIR)/cf/cf/redhat.cf
	install -m 0644 $(SENDMAIL_DIR)/cf/cf/redhat.cf $@

$(TARGET_DIR)/etc/mail/submit.cf:	$(SENDMAIL_DIR)/cf/cf/submit.cf
	install -m 0644 $(SENDMAIL_DIR)/cf/cf/submit.cf $@

$(TARGET_DIR)/etc/mail/sendmail.mc:	$(SENDMAIL_DIR)/cf/cf/redhat.mc
	install -m 0644 $(SENDMAIL_DIR)/cf/cf/redhat.mc $@

$(TARGET_DIR)/etc/mail/submit.mc:	$(SENDMAIL_DIR)/cf/cf/submit.cf
	install -m 0644 $(SENDMAIL_DIR)/cf/cf/submit.mc $@

$(TARGET_DIR)/usr/man/man8/mailstats.8: $(SENDMAIL_DIR)/mailstats/mailstats.8
	install -m 0666 $(SENDMAIL_DIR)/mailstats/mailstats.8 $@

$(TARGET_DIR)/usr/man/man8/makemap.8: $(SENDMAIL_DIR)/makemap/makemap.8
	install -m 0666 $(SENDMAIL_DIR)/makemap/makemap.8 $@

$(TARGET_DIR)/usr/man/man8/smrsh.8: $(SENDMAIL_DIR)/smrsh/smrsh.8
	install -m 0666 $(SENDMAIL_DIR)/smrsh/smrsh.8 $@

$(TARGET_DIR)/usr/man/man8/praliases.8: $(SENDMAIL_DIR)/praliases/praliases.8
	install -m 0666 $(SENDMAIL_DIR)/praliases/praliases.8 $@

$(TARGET_DIR)/usr/man/man8/sendmail.8: $(SENDMAIL_DIR)/sendmail/sendmail.8
	install -m 0666 $(SENDMAIL_DIR)/sendmail/sendmail.8 $@

$(TARGET_DIR)/usr/man/man8/rmail.8: $(SENDMAIL_DIR)/rmail/rmail.8
	install -m 0666 $(SENDMAIL_DIR)/rmail/rmail.8 $@

$(TARGET_DIR)/usr/man/man5/aliases.5: $(SENDMAIL_DIR)/sendmail/aliases.5
	install -m 0666 $(SENDMAIL_DIR)/sendmail/aliases.5 $@

$(TARGET_DIR)/usr/man/man1/mailq.1: $(SENDMAIL_DIR)/sendmail/mailq.1
	install -m 0666 $(SENDMAIL_DIR)/sendmail/mailq.1 $@

$(TARGET_DIR)/etc/rc.d/init.d/sendmail: $(SENDMAIL_DIR)/contrib/sendmail.init
	install -m 0755 $(SENDMAIL_DIR)/contrib/sendmail.init $@

$(TARGET_DIR)/etc/mail/local-host-names:
	umask 022
	echo "# local-host-names - include all aliases for your machine here." \
		> $(TARGET_DIR)/etc/mail/local-host-names

$(TARGET_DIR)/etc/mail/trusted-users:
	umask 022
	( echo "# trusted-users - users that can send mail as others without a warning"; \
	echo "# apache, mailman, majordomo, uucp, are good candidates" ) \
		> $(TARGET_DIR)/etc/mail/trusted-users

$(TARGET_DIR)/usr/lib/sendmail.sendmail: $(TARGET_DIR)/usr/sbin/sendmail
	ln -sf ../sbin/sendmail $@

sendmail-target-binlinks: $(SENDMAIL_TARGET_BINLINKS)

$(SENDMAIL_TARGET_BINLINKS): $(TARGET_DIR)/usr/sbin/sendmail
	for l in $(SENDMAIL_TARGET_BINLINKS); do \
		ln -sf ../sbin/sendmail $$l; \
	done

$(TARGET_DIR)/etc/mail/access:
	install -m 0644 $(SOURCE_DIR)/sendmail.access $@

sendmail-dbtargets: $(SENDMAIL_DBTARGETS)

$(SENDMAIL_DBTARGETS):
# We can't go ahead and make the *.db files because they would
# have endian problems...  We'll depend on the startup script making
# them correctly. 
	for map in virtusertable domaintable mailertable ; do \
	    touch $(TARGET_DIR)/etc/mail/$${map}; \
	    chmod 0644 $(TARGET_DIR)/etc/mail/$${map}; \
	done

$(TARGET_DIR)/etc/aliases:
	install -m 0644 $(SOURCE_DIR)/sendmail.aliases $@

$(TARGET_DIR)/etc/sysconfig/sendmail:
	install -m 0644 $(SOURCE_DIR)/sendmail.sysconfig $@


