#############################################################
#
# rp-pppoe
#
#############################################################
ifneq ($(USE_CVS), true)
RP_PPPOE_SOURCE:=rp-pppoe.tar.gz
RP_PPPOE_CAT:=zcat
endif

RP_PPPOE_DIR:=$(BUILD_DIR)/rp-pppoe/src
RP_PPPOE_BINARY:=src/pppoe
RP_PPPOE_TARGET_BINARY:=usr/sbin/pppoe

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(RP_PPPOE_SOURCE):

rp-pppoe-source: $(DL_DIR)/$(RP_PPPOE_SOURCE)
else
rp-pppoe-source:
endif

RP_PPPOE_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d rp-pppoe $(CVS_TAG) $(CVS_PREFIX)rp-pppoe

rp-pppoe-checkout:
	@$(RP_PPPOE_CVSCO)

$(RP_PPPOE_DIR)/.unpacked: $(DL_DIR)/$(RP_PPPOE_SOURCE)
ifneq ($(USE_CVS), true)
	$(RP_PPPOE_CAT) $(DL_DIR)/$(RP_PPPOE_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(RP_PPPOE_CVSCO)
endif
	-cat $(SOURCE_DIR)/rp-pppoe.patch | patch -d $(RP_PPPOE_DIR)
	touch  $(RP_PPPOE_DIR)/.unpacked

$(RP_PPPOE_DIR)/.configured: $(RP_PPPOE_DIR)/.unpacked
	(cd $(RP_PPPOE_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
	);
	touch $(RP_PPPOE_DIR)/.configured

$(RP_PPPOE_DIR)/$(RP_PPPOE_BINARY): $(RP_PPPOE_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(RP_PPPOE_DIR)

$(TARGET_DIR)/$(RP_PPPOE_TARGET_BINARY): $(RP_PPPOE_DIR)/$(RP_PPPOE_BINARY)
	make RPM_INSTALL_ROOT=$(TARGET_DIR) -C $(RP_PPPOE_DIR) install

rp-pppoe: uclibc $(TARGET_DIR)/$(RP_PPPOE_TARGET_BINARY)

rp-pppoe-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(RP_PPPOE_DIR) uninstall
	-$(MAKE) -C $(RP_PPPOE_DIR) clean

rp-pppoe-dirclean:
	rm -rf $(RP_PPPOE_DIR)

