#################################################################
#
# rda
#
#################################################################
RDA_DIR:=$(BUILD_DIR)/devo
RDA_WORKDIR:=$(BUILD_DIR)/rda-build
RDA_BINARY:=$(RDA_WORKDIR)/unix/rda
RDA_TARGET_BINARY:=usr/bin/rda
ifneq ($(USE_CVS),true)
RDA_SOURCE:=rda.tar.gz
RDA_CAT:=zcat
else
RDA_CVS_TAG:=-r frv-031128-branch
endif

ifneq ($(USE_CVS),true)
rda-source: $(DL_DIR)/$(RDA_SOURCE)
else
rda-source:
endif

RDA_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co $(RDA_CVS_TAG) rda

rda-checkout:
	@$(RDA_CVSCO)

$(RDA_DIR)/.unpacked: $(DL_DIR)/$(RDA_SOURCE)
ifneq ($(USE_CVS),true)
	$(RDA_CAT) $(DL_DIR)/$(RDA_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(RDA_CVSCO)
endif
	touch $(RDA_DIR)/.unpacked

$(RDA_WORKDIR)/.configured: $(RDA_DIR)/.unpacked
	mkdir $(RDA_WORKDIR) 2>/dev/null || :
	(cd $(RDA_WORKDIR) ; rm -f config.cache ; CFLAGS="$(TARGET_CFLAGS)" \
	    $(TARGET_CONFIGURE_OPTS) \
	    $(RDA_DIR)/rda/configure \
		--host=frv-uclinux \
		--target=frv-uclinux \
		--build=i686-pc-linux-gnulibc2.2 \
	);
	touch $(RDA_WORKDIR)/.configured

$(RDA_BINARY): $(RDA_WORKDIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(RDA_WORKDIR)

$(TARGET_DIR)/$(RDA_TARGET_BINARY): $(RDA_BINARY)
	cp -p $(RDA_BINARY) $(TARGET_DIR)/$(RDA_TARGET_BINARY)
	$(STRIP) $(TARGET_DIR)/$(RDA_TARGET_BINARY)
	mkdir -p $(DOC_DIR)/doc/rda
	for f in rda/HOWTO rda/NEWS rda/README rda/REMOTE-HACK-RULES ; do \
	    install -m0644 $(RDA_DIR)/$$f $(DOC_DIR)/doc/rda/ ; \
	done

rda: uclibc $(TARGET_DIR)/$(RDA_TARGET_BINARY)

rda-clean:
	$(MAKE) -C $(RDA_WORKDIR) clean
	-rm -f $(TARGET_DIR)/$(RDA_TARGET_BINARY) 
	-rm -rf $(DOC_DIR)/doc/rda

rda-dirclean:
	-rm -rf $(RDA_DIR) $(RDA_WORKDIR)

