#############################################################
#
# gzip
#
#############################################################
ifneq ($(USE_CVS),true)
#GZIP_SOURCE:=gzip-1.3.5.tar.gz
GZIP_SOURCE:=gzip.tar.gz
GZIP_SITE:=ftp://alpha.gnu.org/gnu/gzip
GZIP_CAT:=zcat
endif

GZIP_DIR:=$(BUILD_DIR)/gzip
GZIP_BINARY:=$(GZIP_DIR)/gzip
GZIP_TARGET_BINARY:=$(TARGET_DIR)/bin/zmore

ifeq ($(strip $(BUILD_WITH_LARGEFILE)),false)
GZIP_LARGEFILE="--disable-largefile"
endif

ifneq ($(USE_CVS),true)
gzip-fetch:
	 $(WGET) -P $(DL_DIR) $(GZIP_SITE)/$(GZIP_SOURCE)

gzip-source: $(DL_DIR)/$(GZIP_SOURCE)
endif

GZIP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d gzip $(CVS_TAG) $(CVS_PREFIX)gzip

gzip-checkout:
	@$(GZIP_CVSCO)

$(GZIP_DIR)/.unpacked: $(DL_DIR)/$(GZIP_SOURCE)
ifneq ($(USE_CVS),true)
	$(GZIP_CAT) $(DL_DIR)/$(GZIP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(GZIP_CVSCO)
endif
	#ln -s /usr/share/automake-1.6/install-sh $(GZIP_DIR)/install-sh
	touch $(GZIP_DIR)/.unpacked

$(GZIP_DIR)/.configured: $(GZIP_DIR)/.unpacked
	(cd $(GZIP_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/ \
		--bindir=/bin \
		--sbindir=/bin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		$(GZIP_LARGEFILE) \
	);
	touch  $(GZIP_DIR)/.configured

$(GZIP_BINARY): $(GZIP_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(GZIP_DIR)

$(GZIP_TARGET_BINARY): $(GZIP_BINARY)
	$(MAKE) prefix=$(TARGET_DIR) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(GZIP_DIR) install
	(cd $(TARGET_DIR)/bin; \
	ln -sf gzip gunzip; \
	ln -sf gzip zcat; \
	ln -sf zdiff zcmp; \
	ln -sf zgrep zegrep; \
	ln -sf zgrep zfgrep;)
	$(STRIP) $(TARGET_DIR)/bin/gzip
	install -d $(DOC_DIR)/doc/gzip
	-for f in AUTHORS COPYING NEWS README THANKS ; do \
		install -m0644 $(GZIP_DIR)/$$f $(DOC_DIR)/doc/gzip/$$f ;\
	done

gzip: uclibc $(GZIP_TARGET_BINARY)

gzip-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(GZIP_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/gzip
	-$(MAKE) -C $(GZIP_DIR) clean

gzip-dirclean:
	rm -rf $(GZIP_DIR)

