#############################################################
#
# findutils
#
#############################################################
ifneq ($(USE_CVS),true)
FINDUTILS_SOURCE:=findutils.tar.gz
FINDUTILS_SITE:=http://ftp.debian.org/debian/pool/main/f/findutils
FINDUTILS_CAT:=zcat
endif

FINDUTILS_DIR:=$(BUILD_DIR)/findutils
FINDUTILS_BINARY:=find/find
FINDUTILS_TARGET_BINARY:=usr/bin/find

ifneq ($(USE_CVS),true)
findutils-fetch:
	 $(WGET) -P $(DL_DIR) $(FINDUTILS_SITE)/$(FINDUTILS_SOURCE)

findutils-source: $(DL_DIR)/$(FINDUTILS_SOURCE)
endif

FINDUTILS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d findutils $(CVS_TAG) $(CVS_PREFIX)findutils

findutils-checkout:
	@$(FINDUTILS_CVSCO)

$(FINDUTILS_DIR)/.unpacked: $(DL_DIR)/$(FINDUTILS_SOURCE)
ifneq ($(USE_CVS),true)
	$(FINDUTILS_CAT) $(DL_DIR)/$(FINDUTILS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(FINDUTILS_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(FINDUTILS_DIR)/
	touch $(FINDUTILS_DIR)/.unpacked

$(FINDUTILS_DIR)/.configured: $(FINDUTILS_DIR)/.unpacked
	(cd $(FINDUTILS_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="-D_GNU_SOURCE" \
		ac_cv_func_setvbuf_reversed=no \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib/locate \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var/lib \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(FINDUTILS_DIR)/.configured

$(FINDUTILS_DIR)/$(FINDUTILS_BINARY): $(FINDUTILS_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(FINDUTILS_DIR)

# This stuff is needed to work around GNU make deficiencies
findutils-target_binary: $(FINDUTILS_DIR)/$(FINDUTILS_BINARY)
	@if [ -L $(TARGET_DIR)/$(FINDUTILS_TARGET_BINARY) ] ; then \
		rm -f $(TARGET_DIR)/$(FINDUTILS_TARGET_BINARY); fi;
	@if [ $(TARGET_DIR)/$(FINDUTILS_TARGET_BINARY) -ot $(FINDUTILS_DIR)/$(FINDUTILS_BINARY) ] ; then \
	    set -x; \
	    $(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(FINDUTILS_DIR) install; \
	    $(STRIP) $(TARGET_DIR)/usr/lib/locate/* > /dev/null 2>&1; \
	    $(STRIP) $(TARGET_DIR)/$(FINDUTILS_TARGET_BINARY) \
			$(TARGET_DIR)/usr/bin/locate \
			$(TARGET_DIR)/usr/bin/xargs ;\
	fi
	install -d $(DOC_DIR)/doc/findutils
	for f in COPYING NEWS ; do \
		install -m0644 $(FINDUTILS_DIR)/$$f $(DOC_DIR)/doc/findutils/$$f ;\
	done

findutils: uclibc findutils-target_binary

findutils-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(FINDUTILS_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/findutils
	-$(MAKE) -C $(FINDUTILS_DIR) clean

findutils-dirclean:
	rm -rf $(FINDUTILS_DIR)

