#############################################################
#
# bash
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
BASH_SOURCE:=bash.tar.gz
BASH_SITE:=ftp://ftp.gnu.org/gnu/bash
BASH_CAT:=zcat
endif

BASH_DIR:=$(BUILD_DIR)/bash
BASH_BINARY:=bash
BASH_TARGET_BINARY:=bin/bash



ifneq ($(USE_CVS),true)
bash-source: $(DL_DIR)/$(BASH_SOURCE)
else
bash-source:
endif

BASH_CVSCO := cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d bash $(CVS_TAG) $(CVS_PREFIX)bash

bash-checkout:
	@$(BASH_CVSCO)

$(BASH_DIR)/.unpacked: $(DL_DIR)/$(BASH_SOURCE)
ifneq ($(USE_CVS),true)
	$(BASH_CAT) $(DL_DIR)/$(BASH_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(BASH_CVSCO)
endif
	# This is broken when -lintl is added to LIBS
	sed -i -e 's,LIBS_FOR_BUILD =.*,LIBS_FOR_BUILD =,g' \
		$(BASH_DIR)/builtins/Makefile.in
	cp $(SOURCE_DIR)/config.sub $(BASH_DIR)/
	cp $(SOURCE_DIR)/config.sub $(BASH_DIR)/support/
	#cat $(SOURCE_DIR)/bash-frv.patch | patch -d $(BASH_DIR) -p1
	touch $(BASH_DIR)/.unpacked

$(BASH_DIR)/.configured: $(BASH_DIR)/.unpacked
	(cd $(BASH_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		ac_cv_func_setvbuf_reversed=no \
		bash_cv_have_mbstate_t=yes \
		bash_cv_job_control_missing=no \
		ac_cv_rl_version="$(READLINE_VERSION)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--localstatedir=/var \
		--enable-job-control \
		--with-installed-readline \
		--without-bash-malloc \
		$(DISABLE_NLS) \
	);
	touch  $(BASH_DIR)/.configured

$(BASH_DIR)/$(BASH_BINARY): $(BASH_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(BASH_DIR)

$(TARGET_DIR)/$(BASH_TARGET_BINARY): $(BASH_DIR)/$(BASH_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(BASH_DIR) install
	rm -f $(TARGET_DIR)/bin/bash*
	mv $(TARGET_DIR)/usr/bin/bash* $(TARGET_DIR)/bin/
	(cd $(TARGET_DIR)/bin; ln -fs bash sh)
	$(STRIP) $(TARGET_DIR)/$(BASH_TARGET_BINARY) $(TARGET_DIR)/usr/bin/bashbug
	install -d $(DOC_DIR)/doc/bash
	for f in COMPAT COPYING POSIX RBASH README ; do \
		install -m0644 $(BASH_DIR)/$$f $(DOC_DIR)/doc/bash/$$f ;\
	done

bash: uclibc ncurses readline $(TARGET_DIR)/$(BASH_TARGET_BINARY)

bash-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(BASH_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/bash
	-$(MAKE) -C $(BASH_DIR) clean

bash-dirclean:
	rm -rf $(BASH_DIR)

bash-fetch:
	 $(WGET) -P $(DL_DIR) $(BASH_SITE)/$(BASH_SOURCE)



endif

