# We have to override the new %%install behavior because, well... the kernel is special.
%global __spec_install_pre %{___build_pre}

Summary: The Linux kernel

# For a stable, released kernel, released_kernel should be 1. For rawhide
# and/or a kernel built from an rc or git snapshot, released_kernel should
# be 0.
%global released_kernel 1

# Versions of various parts

# Polite request for people who spin their own kernel rpms:
# please modify the "buildid" define in a way that identifies
# that the kernel isn't the stock distribution kernel, for example,
# by setting the define to ".local" or ".bz123456"
#
# % define buildid .local
%define buildid .lp01

# fedora_build defines which build revision of this kernel version we're
# building. Rather than incrementing forever, as with the prior versioning
# setup, we set fedora_cvs_origin to the current cvs revision s/1.// of the
# kernel spec when the kernel is rebased, so fedora_build automatically
# works out to the offset from the rebase, so it doesn't get too ginormous.
#
# If you're building on a branch, the RCS revision will be something like
# 1.1205.1.1.  In this case we drop the initial 1, subtract fedora_cvs_origin
# from the second number, and then append the rest of the RCS string as is.
# Don't stare at the awk too long, you'll go blind.
%define fedora_cvs_origin   1679
%define fedora_cvs_revision() %2
%global fedora_build %(echo %{fedora_cvs_origin}.%{fedora_cvs_revision $Revision: 1.1784 $} | awk -F . '{ OFS = "."; ORS = ""; print $3 - $1 ; i = 4 ; OFS = ""; while (i <= NF) { print ".", $i ; i++} }')

# base_sublevel is the kernel version we're starting with and patching
# on top of -- for example, 2.6.22-rc7-git1 starts with a 2.6.21 base,
# which yields a base_sublevel of 21.
%define base_sublevel 30

## If this is a released kernel ##
%if 0%{?released_kernel}

# Do we have a -stable update to apply?
%define stable_update 10
# Is it a -stable RC?
%define stable_rc 0
# Set rpm version accordingly
%if 0%{?stable_update}
%define stablerev .%{stable_update}
%define stable_base %{stable_update}
%if 0%{?stable_rc}
# stable RCs are incremental patches, so we need the previous stable patch
%define stable_base %(echo $((%{stable_update} - 1)))
%endif
%endif
%define rpmversion 2.6.%{base_sublevel}%{?stablerev}

## The not-released-kernel case ##
%else
# The next upstream release sublevel (base_sublevel+1)
%define upstream_sublevel %(echo $((%{base_sublevel} + 1)))
# The rc snapshot level
%define rcrev 0
# The git snapshot level
%define gitrev 0
# Set rpm version accordingly
%define rpmversion 2.6.%{upstream_sublevel}
%endif
# Nb: The above rcrev and gitrev values automagically define Patch00 and Patch01 below.

# What parts do we want to build?  We must build at least one kernel.
# These are the kernels that are built IF the architecture allows it.
# All should default to 1 (enabled) and be flipped to 0 (disabled)
# by later arch-specific checks.

# The following build options are enabled by default.
# Use either --without <opt> in your rpmbuild command or force values
# to 0 in here to disable them.
#
# standard kernel
%define with_up        %{?_without_up:        0} %{?!_without_up:        1}
# kernel-smp (only valid for ppc 32-bit, sparc64)
%define with_smp       %{?_without_smp:       0} %{?!_without_smp:       1}
# kernel-kdump
%define with_kdump     %{?_without_kdump:     0} %{?!_without_kdump:     1}
# kernel-debug
%define with_debug     %{?_without_debug:     0} %{?!_without_debug:     1}
# kernel-doc
%define with_doc       %{?_without_doc:       0} %{?!_without_doc:       1}
# kernel-headers
%define with_headers   %{?_without_headers:   0} %{?!_without_headers:   1}
# kernel-firmware
%define with_firmware  %{?_with_firmware:  1} %{?!_with_firmware:  0}
# kernel-debuginfo
%define with_debuginfo %{?_without_debuginfo: 0} %{?!_without_debuginfo: 1}
# kernel-bootwrapper (for creating zImages from kernel + initrd)
%define with_bootwrapper %{?_without_bootwrapper: 0} %{?!_without_bootwrapper: 1}
# Want to build a the vsdo directories installed
%define with_vdso_install %{?_without_vdso_install: 0} %{?!_without_vdso_install: 1}

# Build the kernel-doc package, but don't fail the build if it botches.
# Here "true" means "continue" and "false" means "fail the build".
%if 0%{?released_kernel}
%define doc_build_fail true
%else
%define doc_build_fail true
%endif

%define rawhide_skip_docs 0
%if 0%{?rawhide_skip_docs}
%define with_doc 0
%endif

# Additional options for user-friendly one-off kernel building:
#
# Only build the base kernel (--with baseonly):
%define with_baseonly  %{?_with_baseonly:     1} %{?!_with_baseonly:     0}
# Only build the smp kernel (--with smponly):
%define with_smponly   %{?_with_smponly:      1} %{?!_with_smponly:      0}

# should we do C=1 builds with sparse
%define with_sparse	%{?_with_sparse:      1} %{?!_with_sparse:      0}

# Set debugbuildsenabled to 1 for production (build separate debug kernels)
#  and 0 for rawhide (all kernels are debug kernels).
# See also 'make debug' and 'make release'.
%define debugbuildsenabled 1

# Want to build a vanilla kernel build without any non-upstream patches?
# (well, almost none, we need nonintconfig for build purposes). Default to 0 (off).
%define with_vanilla %{?_with_vanilla: 1} %{?!_with_vanilla: 0}

# pkg_release is what we'll fill in for the rpm Release: field
%if 0%{?released_kernel}

%if 0%{?stable_rc}
%define stable_rctag .rc%{stable_rc}
%endif
%define pkg_release %{fedora_build}%{?stable_rctag}%{?buildid}%{?dist}

%else

# non-released_kernel
%if 0%{?rcrev}
%define rctag .rc%rcrev
%endif
%if 0%{?gitrev}
%define gittag .git%gitrev
%if !0%{?rcrev}
%define rctag .rc0
%endif
%endif
%define pkg_release 0.%{fedora_build}%{?rctag}%{?gittag}%{?buildid}%{?dist}

%endif

# The kernel tarball/base version
%define kversion 2.6.%{base_sublevel}

%define make_target bzImage

%define KVERREL %{PACKAGE_VERSION}-%{PACKAGE_RELEASE}.%{_target_cpu}
%define hdrarch %_target_cpu
%define asmarch %_target_cpu

%if 0%{!?nopatches:1}
%define nopatches 0
%endif

%if %{with_vanilla}
%define nopatches 1
%endif

%if %{nopatches}
%define with_bootwrapper 0
%define variant -vanilla
%else
%define variant_fedora -fedora
%endif

%define using_upstream_branch 0
%if 0%{?upstream_branch:1}
%define stable_update 0
%define using_upstream_branch 1
%define variant -%{upstream_branch}%{?variant_fedora}
%define pkg_release 0.%{fedora_build}%{upstream_branch_tag}%{?buildid}%{?dist}
%endif

%if !%{debugbuildsenabled}
%define with_debug 0
%endif

%if !%{with_debuginfo}
%define _enable_debug_packages 0
%endif
%define debuginfodir /usr/lib/debug

# We only build -PAE for 686 as of Fedora 11.
%ifarch i686
%define with_up 0
%define with_pae 1
%else
%define with_pae 0
%endif

# if requested, only build base kernel
%if %{with_baseonly}
%define with_smp 0
%define with_kdump 0
%define with_debug 0
%endif

# if requested, only build smp kernel
%if %{with_smponly}
%define with_up 0
%define with_kdump 0
%define with_debug 0
%endif

%define all_x86 i386 i586 i686

%if %{with_vdso_install}
# These arches install vdso/ directories.
%define vdso_arches %{all_x86} x86_64 ppc ppc64
%endif

# Overrides for generic default options

# only ppc and sparc64 need separate smp kernels
%ifnarch ppc sparc64 alphaev56
%define with_smp 0
%endif

# only build kernel-kdump on ppc64
# (no relocatable kernel support upstream yet)
#FIXME: Temporarily disabled to speed up builds.
#ifnarch ppc64
%define with_kdump 0
#endif

# don't do debug builds on anything but i686 and x86_64
%ifnarch i686 x86_64
%define with_debug 0
%endif

# only package docs noarch
%ifnarch noarch
%define with_doc 0
%endif

# no need to build headers again for these arches,
# they can just use i586 and ppc64 headers
%ifarch i686 ppc64iseries
%define with_headers 0
%endif

# don't build noarch kernels or headers (duh)
%ifarch noarch
%define with_up 0
%define with_headers 0
%define all_arch_configs kernel-%{version}-*.config
%define with_firmware  %{?_without_firmware:  0} %{?!_without_firmware:  1}
%endif

# bootwrapper is only on ppc
%ifnarch ppc ppc64
%define with_bootwrapper 0
%endif

# sparse blows up on ppc64 alpha and sparc64
%ifarch ppc64 ppc alpha sparc64
%define with_sparse 0
%endif

# Per-arch tweaks

%ifarch %{all_x86}
%define asmarch x86
%define hdrarch i386
%define all_arch_configs kernel-%{version}-i?86*.config
%define image_install_path boot
%define kernel_image arch/x86/boot/bzImage
%endif

%ifarch x86_64
%define asmarch x86
%define all_arch_configs kernel-%{version}-x86_64*.config
%define image_install_path boot
%define kernel_image arch/x86/boot/bzImage
%endif

%ifarch ppc64
%define asmarch powerpc
%define hdrarch powerpc
%define all_arch_configs kernel-%{version}-ppc64*.config
%define image_install_path boot
%define make_target vmlinux
%define kernel_image vmlinux
%define kernel_image_elf 1
%endif

%ifarch s390x
%define asmarch s390
%define hdrarch s390
%define all_arch_configs kernel-%{version}-s390x.config
%define image_install_path boot
%define make_target image
%define kernel_image arch/s390/boot/image
%endif

%ifarch sparc
# We only build sparc headers since we dont support sparc32 hardware
%endif

%ifarch sparc64
%define asmarch sparc
%define all_arch_configs kernel-%{version}-sparc64*.config
%define make_target image
%define kernel_image arch/sparc/boot/image
%define image_install_path boot
%endif

%ifarch ppc
%define asmarch powerpc
%define hdrarch powerpc
%define all_arch_configs kernel-%{version}-ppc{-,.}*config
%define image_install_path boot
%define make_target vmlinux
%define kernel_image vmlinux
%define kernel_image_elf 1
%endif

%ifarch ia64
%define all_arch_configs kernel-%{version}-ia64*.config
%define image_install_path boot/efi/EFI/redhat
%define make_target compressed
%define kernel_image vmlinux.gz
%endif

%ifarch alpha alphaev56
%define all_arch_configs kernel-%{version}-alpha*.config
%define image_install_path boot
%define make_target vmlinux
%define kernel_image vmlinux
%endif

%ifarch %{arm}
%define all_arch_configs kernel-%{version}-arm*.config
%define image_install_path boot
%define hdrarch arm
%define make_target vmlinux
%define kernel_image vmlinux
%endif

%if %{nopatches}
# XXX temporary until last vdso patches are upstream
%define vdso_arches ppc ppc64
%endif

%if %{nopatches}%{using_upstream_branch}
# Ignore unknown options in our config-* files.
# Some options go with patches we're not applying.
%define oldconfig_target loose_nonint_oldconfig
%else
%define oldconfig_target nonint_oldconfig
%endif

# To temporarily exclude an architecture from being built, add it to
# %nobuildarches. Do _NOT_ use the ExclusiveArch: line, because if we
# don't build kernel-headers then the new build system will no longer let
# us use the previous build of that package -- it'll just be completely AWOL.
# Which is a BadThing(tm).

# We don't build a kernel on i386; we only do kernel-headers there,
# and we no longer build for 31bit S390. Same for 32bit sparc and arm.
%define nobuildarches i386 s390 sparc %{arm}

%ifarch %nobuildarches
%define with_up 0
%define with_smp 0
%define with_pae 0
%define with_kdump 0
%define with_debuginfo 0
%define _enable_debug_packages 0
%endif

%define with_pae_debug 0
%if %{with_pae}
%define with_pae_debug %{with_debug}
%endif

#
# Three sets of minimum package version requirements in the form of Conflicts:
# to versions below the minimum
#

#
# First the general kernel 2.6 required versions as per
# Documentation/Changes
#
%define kernel_dot_org_conflicts  ppp < 2.4.3-3, isdn4k-utils < 3.2-32, nfs-utils < 1.0.7-12, e2fsprogs < 1.37-4, util-linux < 2.12, jfsutils < 1.1.7-2, reiserfs-utils < 3.6.19-2, xfsprogs < 2.6.13-4, procps < 3.2.5-6.3, oprofile < 0.9.1-2

#
# Then a series of requirements that are distribution specific, either
# because we add patches for something, or the older versions have
# problems with the newer kernel or lack certain things that make
# integration in the distro harder than needed.
#
%define package_conflicts initscripts < 7.23, udev < 063-6, iptables < 1.3.2-1, ipw2200-firmware < 2.4, iwl4965-firmware < 228.57.2, selinux-policy-targeted < 1.25.3-14, squashfs-tools < 4.0, wireless-tools < 29-3

#
# The ld.so.conf.d file we install uses syntax older ldconfig's don't grok.
#
%define kernel_xen_conflicts glibc < 2.3.5-1, xen < 3.0.1

%define kernel_PAE_obsoletes kernel-smp < 2.6.17, kernel-xen <= 2.6.27-0.2.rc0.git6.fc10
%define kernel_PAE_provides kernel-xen = %{rpmversion}-%{pkg_release}

%ifarch x86_64
%define kernel_obsoletes kernel-xen <= 2.6.27-0.2.rc0.git6.fc10
%define kernel_provides kernel-xen = %{rpmversion}-%{pkg_release}
%endif

# We moved the drm include files into kernel-headers, make sure there's
# a recent enough libdrm-devel on the system that doesn't have those.
%define kernel_headers_conflicts libdrm-devel < 2.4.0-0.15

#
# Packages that need to be installed before the kernel is, because the %post
# scripts use them.
#
%define kernel_prereq  fileutils, module-init-tools, initscripts >= 8.11.1-1, mkinitrd >= 6.0.61-1, kernel-firmware >= %{rpmversion}-%{pkg_release}, /sbin/new-kernel-pkg

#
# This macro does requires, provides, conflicts, obsoletes for a kernel package.
#	%%kernel_reqprovconf <subpackage>
# It uses any kernel_<subpackage>_conflicts and kernel_<subpackage>_obsoletes
# macros defined above.
#
%define kernel_reqprovconf \
Provides: kernel = %{rpmversion}-%{pkg_release}\
Provides: kernel-%{_target_cpu} = %{rpmversion}-%{pkg_release}%{?1:.%{1}}\
Provides: kernel-drm = 4.3.0\
Provides: kernel-drm-nouveau = 12\
Provides: kernel-modeset = 1\
Provides: kernel-uname-r = %{KVERREL}%{?1:.%{1}}\
Requires(pre): %{kernel_prereq}\
Conflicts: %{kernel_dot_org_conflicts}\
Conflicts: %{package_conflicts}\
%{expand:%%{?kernel%{?1:_%{1}}_conflicts:Conflicts: %%{kernel%{?1:_%{1}}_conflicts}}}\
%{expand:%%{?kernel%{?1:_%{1}}_obsoletes:Obsoletes: %%{kernel%{?1:_%{1}}_obsoletes}}}\
%{expand:%%{?kernel%{?1:_%{1}}_provides:Provides: %%{kernel%{?1:_%{1}}_provides}}}\
# We can't let RPM do the dependencies automatic because it'll then pick up\
# a correct but undesirable perl dependency from the module headers which\
# isn't required for the kernel proper to function\
AutoReq: no\
AutoProv: yes\
%{nil}

Name: kernel%{?variant}
Group: System Environment/Kernel
License: GPLv2
URL: http://www.kernel.org/
Version: %{rpmversion}
Release: %{pkg_release}
# DO NOT CHANGE THE 'ExclusiveArch' LINE TO TEMPORARILY EXCLUDE AN ARCHITECTURE BUILD.
# SET %%nobuildarches (ABOVE) INSTEAD
ExclusiveArch: noarch %{all_x86} x86_64 ppc ppc64 ia64 sparc sparc64 s390x alpha alphaev56 %{arm}
ExclusiveOS: Linux

%kernel_reqprovconf
%ifarch x86_64
Obsoletes: kernel-smp
%endif


#
# List the packages used during the kernel build
#
BuildRequires: module-init-tools, patch >= 2.5.4, bash >= 2.03, sh-utils, tar
BuildRequires: bzip2, findutils, gzip, m4, perl, make >= 3.78, diffutils, gawk
BuildRequires: gcc >= 3.4.2, binutils >= 2.12, redhat-rpm-config
BuildRequires: net-tools
%if %{with_doc}
BuildRequires: xmlto
%endif
%if %{with_sparse}
BuildRequires: sparse >= 0.4.1
%endif
BuildConflicts: rhbuildsys(DiskFree) < 500Mb

%define fancy_debuginfo 0
%if %{with_debuginfo}
%if 0%{?fedora} >= 8
%define fancy_debuginfo 1
%endif
%endif

%if %{fancy_debuginfo}
# Fancy new debuginfo generation introduced in Fedora 8.
BuildRequires: rpm-build >= 4.4.2.1-4
%define debuginfo_args --strict-build-id
%endif

Source0: ftp://ftp.kernel.org/pub/linux/kernel/v2.6/linux-%{kversion}.tar.bz2

Source11: genkey
Source14: find-provides
Source15: merge.pl

Source20: Makefile.config
Source21: config-debug
Source22: config-nodebug
Source23: config-generic
Source24: config-rhel-generic

Source30: config-x86-generic
Source31: config-i586
Source32: config-i686-PAE

Source40: config-x86_64-generic

Source50: config-powerpc-generic
Source51: config-powerpc32-generic
Source52: config-powerpc32-smp
Source53: config-powerpc64
Source54: config-powerpc64-kdump

Source60: config-ia64-generic

Source70: config-s390x

Source90: config-sparc64-generic
Source91: config-sparc64-smp

Source100: config-arm

# Here should be only the patches up to the upstream canonical Linus tree.

# For a stable release kernel
%if 0%{?stable_update}
%if 0%{?stable_base}
%define    stable_patch_00  patch-2.6.%{base_sublevel}.%{stable_base}.bz2
Patch00: %{stable_patch_00}
%endif
%if 0%{?stable_rc}
%define    stable_patch_01  patch-2.6.%{base_sublevel}.%{stable_update}-rc%{stable_rc}.bz2
Patch01: %{stable_patch_01}
%endif

# non-released_kernel case
# These are automagically defined by the rcrev and gitrev values set up
# near the top of this spec file.
%else
%if 0%{?rcrev}
Patch00: patch-2.6.%{upstream_sublevel}-rc%{rcrev}.bz2
%if 0%{?gitrev}
Patch01: patch-2.6.%{upstream_sublevel}-rc%{rcrev}-git%{gitrev}.bz2
%endif
%else
# pre-{base_sublevel+1}-rc1 case
%if 0%{?gitrev}
Patch00: patch-2.6.%{base_sublevel}-git%{gitrev}.bz2
%endif
%endif
%endif

%if %{using_upstream_branch}
### BRANCH PATCH ###
%endif

Patch02: git-linus.diff

# we always need nonintconfig, even for -vanilla kernels
Patch03: linux-2.6-build-nonintconfig.patch

# we also need compile fixes for -vanilla
Patch04: linux-2.6-compile-fixes.patch

# build tweak for build ID magic, even for -vanilla
Patch05: linux-2.6-makefile-after_link.patch

%if !%{nopatches}

# revert upstream patches we get via other methods
Patch09: linux-2.6-upstream-reverts.patch
# Git trees.
Patch10: git-cpufreq.patch
Patch11: git-bluetooth.patch

# Standalone patches
Patch20: linux-2.6-hotfixes.patch

Patch21: linux-2.6-tracehook.patch
Patch22: linux-2.6-utrace.patch
Patch23: linux-2.6-utrace-ftrace.patch

Patch41: linux-2.6-sysrq-c.patch

Patch80: linux-2.6-defaults-saner-vm-settings.patch
Patch81: linux-2.6-mm-lru-evict-streaming-io-pages-first.patch
Patch82: linux-2.6-mm-lru-report-vm-flags-in-page-referenced.patch
Patch83: linux-2.6-mm-lru-dont-evict-mapped-executable-pages.patch

Patch141: linux-2.6-ps3-storage-alias.patch
Patch143: linux-2.6-g5-therm-shutdown.patch
Patch144: linux-2.6-vio-modalias.patch
Patch145: linux-2.6-imac-transparent-bridge.patch
Patch146: linux-2.6-ppc64-vs-broadcom.patch
Patch147: linux-2.6-ppc64-vs-broadcom-lmb-no-init-1.patch
Patch148: linux-2.6-ppc64-vs-broadcom-lmb-no-init-2.patch

Patch150: linux-2.6.29-sparc-IOC_TYPECHECK.patch

Patch160: linux-2.6-execshield.patch

Patch200: linux-2.6-ext4-prealloc-fixes.patch
# eCryptfs fixes taken from 2.6.31.2 (fixes CVE-2009-2908)
Patch210: ecryptfs-handle-unrecognized-tag-3-cipher-codes.patch
Patch211: ecryptfs-check-for-o_rdonly-lower-inodes-when-opening-lower-files.patch
Patch212: ecryptfs-filename-encryption-only-supports-password-auth-tokens.patch
Patch213: ecryptfs-validate-global-auth-tok-keys.patch
Patch214: ecryptfs-prevent-lower-dentry-from-going-negative-during-unlink.patch

Patch250: linux-2.6-debug-sizeof-structs.patch
Patch260: linux-2.6-debug-nmi-timeout.patch
Patch270: linux-2.6-debug-taint-vm.patch
Patch280: linux-2.6-debug-spinlock-taint.patch
Patch340: linux-2.6-debug-vm-would-have-oomkilled.patch
Patch360: linux-2.6-debug-always-inline-kzalloc.patch
Patch380: linux-2.6-defaults-pci_no_msi.patch
Patch381: linux-2.6-pciehp-update.patch
Patch382: linux-2.6-defaults-pciehp.patch
Patch390: linux-2.6-defaults-acpi-video.patch
Patch391: linux-2.6-acpi-video-dos.patch
Patch392: linux-2.6-defaults-die-floppy-die.patch
Patch450: linux-2.6-input-kill-stupid-messages.patch
Patch451: linux-2.6-input-fix-toshiba-hotkeys.patch
Patch452: linux-2.6-input-wacom-bluetooth.patch

Patch460: linux-2.6-serial-460800.patch
Patch461: linux-2.6-drivers-char-low-latency-removal.patch
Patch462: linux-2.6-serial-add-txen-test-param.patch

Patch510: linux-2.6-silence-noise.patch
Patch530: linux-2.6-silence-fbcon-logo.patch
Patch570: linux-2.6-selinux-mprotect-checks.patch

Patch600: linux-2.6-defaults-alsa-hda-beep-off.patch
Patch610: hda_intel-prealloc-4mb-dmabuffer.patch

Patch670: linux-2.6-ata-quirk.patch

Patch680: linux-2.6-rt2x00-asus-leds.patch
Patch681: linux-2.6-mac80211-age-scan-results-on-resume.patch
Patch682: linux-2.6-iwlwifi_-fix-TX-queue-race.patch
Patch683: linux-2.6-zd1211rw_-adding-083a_e503-as-a-ZD1211B-device.patch

Patch800: linux-2.6-crash-driver.patch

Patch1000: linux-2.6-neigh_-fix-state-transition-INCOMPLETE-_FAILED-via-Netlink-request.patch

# Virt Patches
Patch1200: linux-2.6-xen-fix-brkpoints-hw-watchpoints.patch
Patch1201: linux-2.6-xen-clean-up-warnings.patch
Patch1202: linux-2.6-virtio_blk-revert-QUEUE_FLAG_VIRT-addition.patch
Patch1203: linux-2.6-virtio-net-refill-on-out-of-memory.patch

Patch1515: lirc-2.6.31.patch
Patch1517: hid-ignore-all-recent-imon-devices.patch
Patch1518: hdpvr-ir-enable.patch
Patch1519: lirc-revert-2.6.31-i2c-changes.patch

Patch1700: agp-set_memory_ucwb.patch
# nouveau + drm fixes
Patch1811: drm-next.patch
Patch1812: drm-modesetting-radeon.patch
Patch1813: drm-nouveau.patch
Patch1814: drm-no-gem-on-i8xx.patch
Patch1815: drm-i915-resume-force-mode.patch
Patch1816: drm-intel-big-hammer.patch
Patch1817: drm-intel-gen3-fb-hack.patch
Patch1818: drm-intel-hdmi-edid-fix.patch
Patch1819: drm-intel-gem-use-dma32-on-pae.patch
Patch1820: drm-modesetting-radeon-fixes.patch
Patch1821: drm-radeon-new-pciids.patch
Patch1822: drm-dont-frob-i2c.patch
Patch1824: drm-radeon-cs-oops-fix.patch
Patch1825: drm-pnp-add-resource-range-checker.patch
Patch1826: drm-i915-enable-mchbar.patch
Patch1827: shut-up-LOCK_TEST_WITH_RETURN.patch
Patch1838: drm-silence-pointless-vblank-warning.patch

# kludge to make ich9 e1000 work
Patch2000: linux-2.6-e1000-ich9.patch

# update Intel e1000e driver
Patch20000: linux-2.6-e1000e.patch
# update Intel GPU DRM driver (from F12)
Patch20020: linux-2.6-intel-gpu-updates.patch

# fix forcedeth race (#526546)
Patch2010: forcedeth-fix-napi-race.patch

# linux1394 git patches
Patch2200: linux-2.6-firewire-git-update.patch
Patch2201: linux-2.6-firewire-git-pending.patch

# Quiet boot fixes
# silence the ACPI blacklist code
Patch2802: linux-2.6-silence-acpi-blacklist.patch

Patch2899: linux-2.6-v4l-dvb-fixes.patch
Patch2900: linux-2.6-v4l-dvb-update.patch
Patch2901: linux-2.6-v4l-dvb-experimental.patch
Patch2903: linux-2.6-revert-dvb-net-kabi-change.patch
Patch2904: v4l-dvb-fix-cx25840-firmware-load.patch

# fs fixes
Patch3000: linux-2.6-fs-cifs-fix-port-numbers.patch

# ACPI
Patch4000: linux-2.6.30-cpuidle-faster-io.patch
# EC fixes from 2.6.32 (#492699, #525681)
Patch4010: acpi-ec-merge-irq-and-poll-modes.patch
Patch4020: acpi-ec-use-burst-mode-only-for-msi-notebooks.patch
Patch4030: acpi-ec-restart-command-even-if-no-interrupts-from-ec.patch

#snmp fixes
Patch10000: linux-2.6-missing-rfc2465-stats.patch

# VIA Nano / VX8xx updates
Patch11000: linux-2.6-cpufreq-enable-acpi-pstates-on-via.patch
Patch11010: via-hwmon-temp-sensor.patch
Patch11020: via-padlock-10-enable-64bit.patch
Patch11030: via-padlock-20-add-x86-dependency.patch
Patch11040: via-padlock-30-fix-might-sleep.patch
Patch11050: via-padlock-40-nano-ecb.patch
Patch11060: via-padlock-50-nano-cbc.patch
Patch11070: via-rng-enable-64bit.patch
Patch11080: via-sdmmc.patch
Patch11081: linux-2.6-x86-delay-tsc-barrier.patch

# Commit a44a4a006b860476881ec0098c36584036e1cb91 fron net-next-2.6.git
Patch12000: linux-2.6-xfrm-export-gc_thresh.patch

Patch13000: linux-2.6-kvm-skip-pit-check.patch
Patch13001: linux-2.6.29-xen-disable-gbpages.patch
Patch13002: linux-2.6-virtio_blk-dont-bounce-highmem-requests.patch

# sched fixes cherry-picked from 2.6.32
Patch13100: sched-deal-with-low-load-in-wake-affine.patch
Patch13102: sched-ensure-child-cant-gain-time-over-its-parent-after-fork.patch
Patch13103: sched-remove-shortcut-from-select-task-rq-fair.patch
# latency defaults from 2.6.32 but changed to be not so aggressive
Patch13104: sched-retune-scheduler-latency-defaults.patch

Patch14000: make-mmap_min_addr-suck-less.patch

# ----- send for upstream inclusion -----

# ----- patches headed for -stable -----

# Fix string overflows found by stackprotector:
Patch14050: hda-check-strcpy-length.patch
Patch14060: linux-2.6-v4l-dvb-af9015-fix-stack-corruption.patch

# fix stack protector problems with xen on x86_64
Patch14080: linux-2.6-x86-load-percpu-segment-no-stackprotector.patch
Patch14090: linux-2.6-xen-rearrange-to-fix-stackprotector.patch

# fix lockdep warnings in cpufreq (#522685)
Patch14100: linux-2.6-cpufreq-eliminate-lockdep-warnings.patch
Patch14101: linux-2.6-cpufreq-cleanup-locking-in-ondemand.patch

# fix hostap (#522269)
Patch14200: hostap-revert-toxic-part-of-conversion.patch

# fix cfq performance regression in 2.6.30
Patch14300: linux-2.6-cfq-choose-new-next-req.patch

# appletalk: fix skb leak (CVE-2009-2903)
Patch15200: appletalk-fix-skb-leak-when-ipddp-interface-is-not-loaded.patch

# fix stack randomization (F10#526882)
Patch15300: x86-increase-min_gap-to-include-randomized-stack.patch

# x86: Don't leak 64-bit reg contents to 32-bit tasks.
Patch15400: x86-dont-leak-64-bit-kernel-register-values.patch

# critical ftrace fixes
Patch15500: ftrace-use-module-notifier-for-function-tracer.patch
Patch15510: ftrace-check-for-failure-for-all-conversions.patch
Patch15520: tracing-correct-module-boundaries-for-ftrace_release.patch

# fix boot hang on some systems
Patch15600: acpi-revert-attach-device-to-handle-early.patch

# networking fixes from 2.6.31-stable
Patch15700: net-fix-wrong-sizeof.patch
Patch15710: net-unix-fix-sending-fds-in-multiple-buffers.patch
Patch15720: sit-fix-off-by-one-in-ipip6_tunnel_get_prl.patch
Patch15730: sky2-set-sky2_hw_ram_buffer-in-sky2_init.patch
Patch15740: smsc95xx-fix-transmission-where-zlp-is-expected.patch
Patch15750: tcp-fix-config_tcp_md5sig-config_preempt-timer-bug.patch
Patch15760: x86-fix-csum_ipv6_magic-asm-memory-clobber.patch

# libata fix from 2.6.31.4 (#524756)
Patch15800: libata-fix-incorrect-link-online-check-during-probe.patch

# ax25 security fix (cve-2009-2909)
Patch15900: ax25-fix-possible-oops-in-ax25_make_new.patch

# netlink security fix (CVE-2009-3612)
Patch16000: netlink-fix-typo-in-initialization.patch

# Fix huge wakeup latencies
Patch16200: sched-update-the-clock-of-runqueue-select-task-rq-selected.patch

# fix mouse and keyboard detection (#522126)
Patch16300: input-i8042-bypass-aux-irq-delivery-test-on-laptops.patch
Patch16310: input-i8042-try-disabling-and-re-enabling-aux-port-at-close.patch

# fix null deref in r128
Patch16400: drm-r128-add-test-for-initialisation-to-all-ioctls-that-require-it.patch

# rhbz#529626
Patch16401: af_unix-fix-deadlock-connecting-to-shutdown-socket.patch

# Fix exploitable oops in keyring code
Patch16420: keys-get_instantiation_keyring-should-inc-the-keyring-refcount.patch

# Fix overflow in KVM cpuid code
Patch16430: kvm-prevent-overflow-in-kvm-get-supported-cpuid.patch

# disable the stackprotector on fns that don't have onstack arrays
Patch16440: disable-stackprotector-all.patch

# fs/pipe.c: null ptr dereference fix
# rhbz#530490 (CVE-2009-3547) [ad3960243e55320d74195fb85c975e0a8cc4466c]
Patch16450: fs-pipe-null-ptr-deref-fix.patch

# another try at fixing bug #524756
Patch16460: sata_nv-make-sure-link-is-brough-up-online-when-skipping-hardreset.patch
Patch16470: sata_nv-use-hardreset-only-for-post-boot-probing.patch

# rhbz#538734 (CVE-tbd) [f60311d5f7670d9539b424e4ed8b5c0872fc9e83]
Patch16471: fuse-prevent-fuse_put_request-in-invalid-ptr.patch

# rhbz#549400 [0bd87182d3ab18a32a8e9175d3f68754c58e3432]
Patch16472: fuse-fix-kunmap-in-fuse_ioctl_copy_user.patch

%endif

BuildRoot: %{_tmppath}/kernel-%{KVERREL}-root

%description
The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system: memory allocation, process allocation, device
input and output, etc.


%package doc
Summary: Various documentation bits found in the kernel source
Group: Documentation
%description doc
This package contains documentation files from the kernel
source. Various bits of information about the Linux kernel and the
device drivers shipped with it are documented in these files.

You'll want to install this package if you need a reference to the
options that can be passed to Linux kernel modules at load time.


%package headers
Summary: Header files for the Linux kernel for use by glibc
Group: Development/System
Obsoletes: glibc-kernheaders
Provides: glibc-kernheaders = 3.0-46
%description headers
Kernel-headers includes the C header files that specify the interface
between the Linux kernel and userspace libraries and programs.  The
header files define structures and constants that are needed for
building most standard programs and are also needed for rebuilding the
glibc package.

%package firmware
Summary: Firmware files used by the Linux kernel
Group: Development/System
# This is... complicated.
# Look at the WHENCE file.
License: GPL+ and GPLv2+ and MIT and Redistributable, no modification permitted
%if "x%{?variant}" != "x"
Provides: kernel-firmware = %{rpmversion}-%{pkg_release}
%endif
%description firmware
Kernel-firmware includes firmware files required for some devices to
operate.

%package bootwrapper
Summary: Boot wrapper files for generating combined kernel + initrd images
Group: Development/System
Requires: gzip
%description bootwrapper
Kernel-bootwrapper contains the wrapper code which makes bootable "zImage"
files combining both kernel and initial ramdisk.

%package debuginfo-common-%{_target_cpu}
Summary: Kernel source files used by %{name}-debuginfo packages
Group: Development/Debug
%description debuginfo-common-%{_target_cpu}
This package is required by %{name}-debuginfo subpackages.
It provides the kernel source files common to all builds.


#
# This macro creates a kernel-<subpackage>-debuginfo package.
#	%%kernel_debuginfo_package <subpackage>
#
%define kernel_debuginfo_package() \
%package %{?1:%{1}-}debuginfo\
Summary: Debug information for package %{name}%{?1:-%{1}}\
Group: Development/Debug\
Requires: %{name}-debuginfo-common-%{_target_cpu} = %{version}-%{release}\
Provides: %{name}%{?1:-%{1}}-debuginfo-%{_target_cpu} = %{version}-%{release}\
AutoReqProv: no\
%description -n %{name}%{?1:-%{1}}-debuginfo\
This package provides debug information for package %{name}%{?1:-%{1}}.\
This is required to use SystemTap with %{name}%{?1:-%{1}}-%{KVERREL}.\
%{expand:%%global debuginfo_args %{?debuginfo_args} -p '/.*/%%{KVERREL}%{?1:\.%{1}}/.*|/.*%%{KVERREL}%{?1:\.%{1}}(\.debug)?' -o debuginfo%{?1}.list}\
%{nil}

#
# This macro creates a kernel-<subpackage>-devel package.
#	%%kernel_devel_package <subpackage> <pretty-name>
#
%define kernel_devel_package() \
%package %{?1:%{1}-}devel\
Summary: Development package for building kernel modules to match the %{?2:%{2} }kernel\
Group: System Environment/Kernel\
Provides: kernel%{?1:-%{1}}-devel-%{_target_cpu} = %{version}-%{release}\
Provides: kernel-devel-%{_target_cpu} = %{version}-%{release}%{?1:.%{1}}\
Provides: kernel-devel = %{version}-%{release}%{?1:.%{1}}\
Provides: kernel-devel-uname-r = %{KVERREL}%{?1:.%{1}}\
AutoReqProv: no\
Requires(pre): /usr/bin/find\
%description -n kernel%{?variant}%{?1:-%{1}}-devel\
This package provides kernel headers and makefiles sufficient to build modules\
against the %{?2:%{2} }kernel package.\
%{nil}

#
# This macro creates a kernel-<subpackage> and its -devel and -debuginfo too.
#	%%define variant_summary The Linux kernel compiled for <configuration>
#	%%kernel_variant_package [-n <pretty-name>] <subpackage>
#
%define kernel_variant_package(n:) \
%package %1\
Summary: %{variant_summary}\
Group: System Environment/Kernel\
%kernel_reqprovconf\
%{expand:%%kernel_devel_package %1 %{!?-n:%1}%{?-n:%{-n*}}}\
%{expand:%%kernel_debuginfo_package %1}\
%{nil}


# First the auxiliary packages of the main kernel package.
%kernel_devel_package
%kernel_debuginfo_package


# Now, each variant package.

%define variant_summary The Linux kernel compiled for SMP machines
%kernel_variant_package -n SMP smp
%description smp
This package includes a SMP version of the Linux kernel. It is
required only on machines with two or more CPUs as well as machines with
hyperthreading technology.

Install the kernel-smp package if your machine uses two or more CPUs.


%define variant_summary The Linux kernel compiled for PAE capable machines
%kernel_variant_package PAE
%description PAE
This package includes a version of the Linux kernel with support for up to
64GB of high memory. It requires a CPU with Physical Address Extensions (PAE).
The non-PAE kernel can only address up to 4GB of memory.
Install the kernel-PAE package if your machine has more than 4GB of memory.


%define variant_summary The Linux kernel compiled with extra debugging enabled for PAE capable machines
%kernel_variant_package PAEdebug
Obsoletes: kernel-PAE-debug
%description PAEdebug
This package includes a version of the Linux kernel with support for up to
64GB of high memory. It requires a CPU with Physical Address Extensions (PAE).
The non-PAE kernel can only address up to 4GB of memory.
Install the kernel-PAE package if your machine has more than 4GB of memory.

This variant of the kernel has numerous debugging options enabled.
It should only be installed when trying to gather additional information
on kernel bugs, as some of these options impact performance noticably.


%define variant_summary The Linux kernel compiled with extra debugging enabled
%kernel_variant_package debug
%description debug
The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

This variant of the kernel has numerous debugging options enabled.
It should only be installed when trying to gather additional information
on kernel bugs, as some of these options impact performance noticably.


%define variant_summary A minimal Linux kernel compiled for crash dumps
%kernel_variant_package kdump
%description kdump
This package includes a kdump version of the Linux kernel. It is
required only on machines which will use the kexec-based kernel crash dump
mechanism.


%prep
# do a few sanity-checks for --with *only builds
%if %{with_baseonly}
%if !%{with_up}%{with_pae}
echo "Cannot build --with baseonly, up build is disabled"
exit 1
%endif
%endif

%if %{with_smponly}
%if !%{with_smp}
echo "Cannot build --with smponly, smp build is disabled"
exit 1
%endif
%endif

# more sanity checking; do it quietly
if [ "%{patches}" != "%%{patches}" ] ; then
  for patch in %{patches} ; do
    if [ ! -f $patch ] ; then
      echo "ERROR: Patch  ${patch##/*/}  listed in specfile but is missing"
      exit 1
    fi
  done
fi 2>/dev/null

patch_command='patch -p1 -F1 -s'
ApplyPatch()
{
  local patch=$1
  shift
  if [ ! -f $RPM_SOURCE_DIR/$patch ]; then
    exit 1
  fi
  if ! egrep "^Patch[0-9]+: $patch\$" %{_specdir}/${RPM_PACKAGE_NAME%%%%%{?variant}}.spec ; then
    if [ "${patch:0:10}" != "patch-2.6." ] ; then
      echo "ERROR: Patch  $patch  not listed as a source patch in specfile"
      exit 1
    fi
  fi 2>/dev/null
  case "$patch" in
  *.bz2) bunzip2 < "$RPM_SOURCE_DIR/$patch" | $patch_command ${1+"$@"} ;;
  *.gz) gunzip < "$RPM_SOURCE_DIR/$patch" | $patch_command ${1+"$@"} ;;
  *) $patch_command ${1+"$@"} < "$RPM_SOURCE_DIR/$patch" ;;
  esac
}

# don't apply patch if it's empty
ApplyOptionalPatch()
{
  local patch=$1
  shift
  if [ ! -f $RPM_SOURCE_DIR/$patch ]; then
    exit 1
  fi
  local C=$(wc -l $RPM_SOURCE_DIR/$patch | awk '{print $1}')
  if [ "$C" -gt 9 ]; then
    ApplyPatch $patch ${1+"$@"}
  fi
}

# First we unpack the kernel tarball.
# If this isn't the first make prep, we use links to the existing clean tarball
# which speeds things up quite a bit.

# Update to latest upstream.
%if 0%{?released_kernel}
%define vanillaversion 2.6.%{base_sublevel}
# non-released_kernel case
%else
%if 0%{?rcrev}
%define vanillaversion 2.6.%{upstream_sublevel}-rc%{rcrev}
%if 0%{?gitrev}
%define vanillaversion 2.6.%{upstream_sublevel}-rc%{rcrev}-git%{gitrev}
%endif
%else
# pre-{base_sublevel+1}-rc1 case
%if 0%{?gitrev}
%define vanillaversion 2.6.%{base_sublevel}-git%{gitrev}
%endif
%endif
%endif

# We can share hardlinked source trees by putting a list of
# directory names of the CVS checkouts that we want to share
# with in .shared-srctree. (Full pathnames are required.)
[ -f .shared-srctree ] && sharedirs=$(cat .shared-srctree)

if [ ! -d kernel-%{kversion}/vanilla-%{vanillaversion} ]; then

  if [ -d kernel-%{kversion}/vanilla-%{kversion} ]; then

    cd kernel-%{kversion}

    # Any vanilla-* directories other than the base one are stale.
    for dir in vanilla-*; do
      [ "$dir" = vanilla-%{kversion} ] || rm -rf $dir &
    done

  else

    # Ok, first time we do a make prep.
    rm -f pax_global_header
    for sharedir in $sharedirs ; do
      if [[ ! -z $sharedir  &&  -d $sharedir/kernel-%{kversion}/vanilla-%{kversion} ]] ; then
        break
      fi
    done
    if [[ ! -z $sharedir  &&  -d $sharedir/kernel-%{kversion}/vanilla-%{kversion} ]] ; then
%setup -q -n kernel-%{kversion} -c -T
      cp -rl $sharedir/kernel-%{kversion}/vanilla-%{kversion} .
    else
%setup -q -n kernel-%{kversion} -c
      mv linux-%{kversion} vanilla-%{kversion}
    fi

  fi

%if "%{kversion}" != "%{vanillaversion}"

  for sharedir in $sharedirs ; do
    if [[ ! -z $sharedir  &&  -d $sharedir/kernel-%{kversion}/vanilla-%{vanillaversion} ]] ; then
      break
    fi
  done
  if [[ ! -z $sharedir  &&  -d $sharedir/kernel-%{kversion}/vanilla-%{vanillaversion} ]] ; then

    cp -rl $sharedir/kernel-%{kversion}/vanilla-%{vanillaversion} .

  else

    cp -rl vanilla-%{kversion} vanilla-%{vanillaversion}
    cd vanilla-%{vanillaversion}

# Update vanilla to the latest upstream.
# (non-released_kernel case only)
%if 0%{?rcrev}
    ApplyPatch patch-2.6.%{upstream_sublevel}-rc%{rcrev}.bz2
%if 0%{?gitrev}
    ApplyPatch patch-2.6.%{upstream_sublevel}-rc%{rcrev}-git%{gitrev}.bz2
%endif
%else
# pre-{base_sublevel+1}-rc1 case
%if 0%{?gitrev}
    ApplyPatch patch-2.6.%{base_sublevel}-git%{gitrev}.bz2
%endif
%endif

    cd ..

  fi

%endif

else
  # We already have a vanilla dir.
  cd kernel-%{kversion}
fi

if [ -d linux-%{kversion}.%{_target_cpu} ]; then
  # Just in case we ctrl-c'd a prep already
  rm -rf deleteme.%{_target_cpu}
  # Move away the stale away, and delete in background.
  mv linux-%{kversion}.%{_target_cpu} deleteme.%{_target_cpu}
  rm -rf deleteme.%{_target_cpu} &
fi

cp -rl vanilla-%{vanillaversion} linux-%{kversion}.%{_target_cpu}

cd linux-%{kversion}.%{_target_cpu}

# released_kernel with possible stable updates
%if 0%{?stable_base}
ApplyPatch %{stable_patch_00}
%endif
%if 0%{?stable_rc}
ApplyPatch %{stable_patch_01}
%endif

%if %{using_upstream_branch}
### BRANCH APPLY ###
%endif

# Drop some necessary files from the source dir into the buildroot
cp $RPM_SOURCE_DIR/config-* .
cp %{SOURCE15} .

# Dynamically generate kernel .config files from config-* files
make -f %{SOURCE20} VERSION=%{version} configs

#if a rhel kernel, apply the rhel config options
%if 0%{?rhel}
  for i in %{all_arch_configs}
  do
    mv $i $i.tmp
    ./merge.pl config-rhel-generic $i.tmp > $i
    rm $i.tmp
  done
%endif

#ApplyOptionalPatch git-linus.diff

# This patch adds a "make nonint_oldconfig" which is non-interactive and
# also gives a list of missing options at the end. Useful for automated
# builds (as used in the buildsystem).
ApplyPatch linux-2.6-build-nonintconfig.patch

ApplyPatch linux-2.6-makefile-after_link.patch

#
# misc small stuff to make things compile
#
ApplyOptionalPatch linux-2.6-compile-fixes.patch

%if !%{nopatches}

# revert patches from upstream that conflict or that we get via other means
ApplyOptionalPatch linux-2.6-upstream-reverts.patch -R

#ApplyPatch git-cpufreq.patch
#ApplyPatch git-bluetooth.patch

ApplyPatch linux-2.6-hotfixes.patch

# Roland's utrace ptrace replacement.
ApplyPatch linux-2.6-tracehook.patch
ApplyPatch linux-2.6-utrace.patch
ApplyPatch linux-2.6-utrace-ftrace.patch

# mm patches
ApplyPatch linux-2.6-defaults-saner-vm-settings.patch
ApplyPatch linux-2.6-mm-lru-evict-streaming-io-pages-first.patch
ApplyPatch linux-2.6-mm-lru-report-vm-flags-in-page-referenced.patch
ApplyPatch linux-2.6-mm-lru-dont-evict-mapped-executable-pages.patch

# iommu patches

# enable sysrq-c on all kernels, not only kexec
ApplyPatch linux-2.6-sysrq-c.patch

# Architecture patches
# x86(-64)
ApplyPatch linux-2.6-cpufreq-enable-acpi-pstates-on-via.patch
ApplyPatch via-hwmon-temp-sensor.patch
ApplyPatch via-padlock-10-enable-64bit.patch
ApplyPatch via-padlock-20-add-x86-dependency.patch
ApplyPatch via-padlock-30-fix-might-sleep.patch
ApplyPatch via-padlock-40-nano-ecb.patch
ApplyPatch via-padlock-50-nano-cbc.patch
ApplyPatch via-rng-enable-64bit.patch
ApplyPatch via-sdmmc.patch
ApplyPatch linux-2.6-x86-delay-tsc-barrier.patch

# Export xfrm[4|6] gc_thresh values to sysctl
ApplyPatch linux-2.6-xfrm-export-gc_thresh.patch

#
# PowerPC
#
### NOT (YET) UPSTREAM:
# The storage alias patch is Fedora-local, and allows the old 'ps3_storage'
# module name to work on upgrades. Otherwise, I believe mkinitrd will fail
# to pull the module in,
ApplyPatch linux-2.6-ps3-storage-alias.patch
# Alleviate G5 thermal shutdown problems
ApplyPatch linux-2.6-g5-therm-shutdown.patch
# Provide modalias in sysfs for vio devices
ApplyPatch linux-2.6-vio-modalias.patch
# Work around PCIe bridge setup on iSight
ApplyPatch linux-2.6-imac-transparent-bridge.patch
# Fix b43 support on no-iommu devices with <1GiB RAM
ApplyPatch linux-2.6-ppc64-vs-broadcom.patch
ApplyPatch linux-2.6-ppc64-vs-broadcom-lmb-no-init-1.patch 
ApplyPatch linux-2.6-ppc64-vs-broadcom-lmb-no-init-2.patch 

#
# SPARC64
#
ApplyPatch linux-2.6.29-sparc-IOC_TYPECHECK.patch

#
# Exec shield
#
ApplyPatch linux-2.6-execshield.patch

#
# bugfixes to drivers and filesystems
#

# ext4
ApplyPatch linux-2.6-ext4-prealloc-fixes.patch

# xfs

# btrfs

# ecryptfs

# 5 fixes from 2.6.31.2
ApplyPatch ecryptfs-handle-unrecognized-tag-3-cipher-codes.patch
ApplyPatch ecryptfs-check-for-o_rdonly-lower-inodes-when-opening-lower-files.patch
ApplyPatch ecryptfs-filename-encryption-only-supports-password-auth-tokens.patch
ApplyPatch ecryptfs-validate-global-auth-tok-keys.patch
# fixes CVE-2009-2908
ApplyPatch ecryptfs-prevent-lower-dentry-from-going-negative-during-unlink.patch

# nfs

# cifs
# fix cifs mount option "port=" (#506574)
ApplyPatch linux-2.6-fs-cifs-fix-port-numbers.patch

# USB

# ACPI
ApplyPatch linux-2.6-defaults-acpi-video.patch
ApplyPatch linux-2.6-acpi-video-dos.patch
ApplyPatch linux-2.6.30-cpuidle-faster-io.patch
# EC fixes from 2.6.32 (#492699, #525681)
ApplyPatch acpi-ec-merge-irq-and-poll-modes.patch
ApplyPatch acpi-ec-use-burst-mode-only-for-msi-notebooks.patch
ApplyPatch acpi-ec-restart-command-even-if-no-interrupts-from-ec.patch

# Various low-impact patches to aid debugging.
ApplyPatch linux-2.6-debug-sizeof-structs.patch
ApplyPatch linux-2.6-debug-nmi-timeout.patch
ApplyPatch linux-2.6-debug-taint-vm.patch
ApplyPatch linux-2.6-debug-spinlock-taint.patch
ApplyPatch linux-2.6-debug-vm-would-have-oomkilled.patch
ApplyPatch linux-2.6-debug-always-inline-kzalloc.patch

#
# PCI
#
# disable message signaled interrupts
ApplyPatch linux-2.6-defaults-pci_no_msi.patch

#
# SCSI Bits.
#

# ALSA
# squelch hda_beep by default
ApplyPatch linux-2.6-defaults-alsa-hda-beep-off.patch
ApplyPatch hda_intel-prealloc-4mb-dmabuffer.patch

# Networking
#
ApplyPatch linux-2.6-missing-rfc2465-stats.patch

# neigh: fix state transition INCOMPLETE->FAILED via Netlink request
ApplyPatch linux-2.6-neigh_-fix-state-transition-INCOMPLETE-_FAILED-via-Netlink-request.patch

# add ich9 lan
ApplyPatch linux-2.6-e1000-ich9.patch

# update Intel e1000e driver 
ApplyPatch linux-2.6-e1000e.patch

# fix forcedeth race
ApplyPatch forcedeth-fix-napi-race.patch

# Virt Fixes
# Xen Guest
ApplyPatch linux-2.6-xen-fix-brkpoints-hw-watchpoints.patch
ApplyPatch linux-2.6-xen-clean-up-warnings.patch

# Misc Virt
ApplyPatch linux-2.6-virtio_blk-revert-QUEUE_FLAG_VIRT-addition.patch
ApplyPatch linux-2.6-virtio-net-refill-on-out-of-memory.patch

# Misc fixes
# The input layer spews crap no-one cares about.
ApplyPatch linux-2.6-input-kill-stupid-messages.patch
# don't load the floppy driver by default
ApplyPatch linux-2.6-defaults-die-floppy-die.patch

# Get away from having to poll Toshibas
ApplyPatch linux-2.6-input-fix-toshiba-hotkeys.patch

# HID: add support for Bluetooth Wacom pads
ApplyPatch linux-2.6-input-wacom-bluetooth.patch

# Allow to use 480600 baud on 16C950 UARTs
ApplyPatch linux-2.6-serial-460800.patch
# fix oops in nozomi drver (#507005) plus two others
ApplyPatch linux-2.6-drivers-char-low-latency-removal.patch
# let users skip the TXEN bug test
ApplyPatch linux-2.6-serial-add-txen-test-param.patch

# Silence some useless messages that still get printed with 'quiet'
ApplyPatch linux-2.6-silence-noise.patch

# Make fbcon not show the penguins with 'quiet'
ApplyPatch linux-2.6-silence-fbcon-logo.patch

# Fix the SELinux mprotect checks on executable mappings
#  (but it's broken on sparc... sigh)
ApplyPatch linux-2.6-selinux-mprotect-checks.patch

# Changes to upstream defaults.

# ia64 ata quirk
ApplyPatch linux-2.6-ata-quirk.patch

# back-port scan result aging patches
#ApplyPatch linux-2.6-mac80211-age-scan-results-on-resume.patch

# iwlwifi: fix TX queue race
ApplyPatch linux-2.6-iwlwifi_-fix-TX-queue-race.patch

# zd1211rw: adding 083a:e503 as a ZD1211B device
ApplyPatch linux-2.6-zd1211rw_-adding-083a_e503-as-a-ZD1211B-device.patch

# /dev/crash driver.
ApplyPatch linux-2.6-crash-driver.patch

# http://www.lirc.org/
ApplyPatch lirc-2.6.31.patch
ApplyPatch hid-ignore-all-recent-imon-devices.patch
ApplyPatch hdpvr-ir-enable.patch
ApplyPatch lirc-revert-2.6.31-i2c-changes.patch

# DRM patches
ApplyPatch agp-set_memory_ucwb.patch
#ApplyPatch drm-next.patch
ApplyPatch drm-modesetting-radeon.patch
ApplyPatch drm-nouveau.patch
ApplyPatch drm-no-gem-on-i8xx.patch
ApplyPatch drm-i915-resume-force-mode.patch
ApplyPatch drm-intel-big-hammer.patch
ApplyPatch drm-intel-gen3-fb-hack.patch
ApplyPatch drm-intel-hdmi-edid-fix.patch
ApplyPatch drm-intel-gem-use-dma32-on-pae.patch
ApplyPatch drm-modesetting-radeon-fixes.patch
ApplyPatch drm-radeon-new-pciids.patch
ApplyPatch drm-dont-frob-i2c.patch
ApplyPatch drm-radeon-cs-oops-fix.patch
ApplyPatch drm-pnp-add-resource-range-checker.patch
ApplyPatch drm-i915-enable-mchbar.patch
ApplyPatch shut-up-LOCK_TEST_WITH_RETURN.patch
# 537196
ApplyPatch drm-silence-pointless-vblank-warning.patch

# linux1394 git patches
#ApplyPatch linux-2.6-firewire-git-update.patch
#ApplyOptionalPatch linux-2.6-firewire-git-pending.patch

# silence the ACPI blacklist code
ApplyPatch linux-2.6-silence-acpi-blacklist.patch

# V4L/DVB updates/fixes/experimental drivers
#ApplyPatch linux-2.6-v4l-dvb-fixes.patch
#ApplyPatch linux-2.6-v4l-dvb-update.patch
#ApplyPatch linux-2.6-v4l-dvb-experimental.patch
#ApplyPatch linux-2.6-revert-dvb-net-kabi-change.patch
ApplyPatch v4l-dvb-fix-cx25840-firmware-load.patch

# kvm
ApplyPatch linux-2.6-kvm-skip-pit-check.patch

# xen
ApplyPatch linux-2.6.29-xen-disable-gbpages.patch

# v12n
ApplyPatch linux-2.6-virtio_blk-dont-bounce-highmem-requests.patch

# sched fixes cherry-picked from 2.6.32
ApplyPatch sched-deal-with-low-load-in-wake-affine.patch
ApplyPatch sched-ensure-child-cant-gain-time-over-its-parent-after-fork.patch
ApplyPatch sched-remove-shortcut-from-select-task-rq-fair.patch
# latency defaults from 2.6.32 but changed to be not so aggressive
ApplyPatch sched-retune-scheduler-latency-defaults.patch

ApplyPatch make-mmap_min_addr-suck-less.patch

# ----- sent for upstream inclusion -----

# ----- patches headed for -stable -----

# CVE-2009-2847

# Fix string overflows found by stackprotector:
ApplyPatch hda-check-strcpy-length.patch
ApplyPatch linux-2.6-v4l-dvb-af9015-fix-stack-corruption.patch

# fix stack protector problems with xen on x86_64
ApplyPatch linux-2.6-x86-load-percpu-segment-no-stackprotector.patch
ApplyPatch linux-2.6-xen-rearrange-to-fix-stackprotector.patch

# fix lockdep warnings in cpufreq (#522685)
ApplyPatch linux-2.6-cpufreq-eliminate-lockdep-warnings.patch
ApplyPatch linux-2.6-cpufreq-cleanup-locking-in-ondemand.patch

# fix hostap driver (#522269)
ApplyPatch hostap-revert-toxic-part-of-conversion.patch

# fix cfq performance regression in 2.6.30
ApplyPatch linux-2.6-cfq-choose-new-next-req.patch

# appletalk: fix skb leak (CVE-2009-2903)
ApplyPatch appletalk-fix-skb-leak-when-ipddp-interface-is-not-loaded.patch

# copy stack randomization fix from 2.6.31.2
ApplyPatch x86-increase-min_gap-to-include-randomized-stack.patch

ApplyPatch x86-dont-leak-64-bit-kernel-register-values.patch

# critical ftrace fixes
ApplyPatch ftrace-use-module-notifier-for-function-tracer.patch
ApplyPatch ftrace-check-for-failure-for-all-conversions.patch
ApplyPatch tracing-correct-module-boundaries-for-ftrace_release.patch

# fix boot hang on some systems
ApplyPatch acpi-revert-attach-device-to-handle-early.patch

# networking fixes from 2.6.31-stable
ApplyPatch net-fix-wrong-sizeof.patch
ApplyPatch net-unix-fix-sending-fds-in-multiple-buffers.patch
ApplyPatch sit-fix-off-by-one-in-ipip6_tunnel_get_prl.patch
ApplyPatch sky2-set-sky2_hw_ram_buffer-in-sky2_init.patch
ApplyPatch smsc95xx-fix-transmission-where-zlp-is-expected.patch
ApplyPatch tcp-fix-config_tcp_md5sig-config_preempt-timer-bug.patch
ApplyPatch x86-fix-csum_ipv6_magic-asm-memory-clobber.patch

# libata fix from 2.6.31.4 (#524756)
ApplyPatch libata-fix-incorrect-link-online-check-during-probe.patch

# ax25 security fix (cve-2009-2909)
ApplyPatch ax25-fix-possible-oops-in-ax25_make_new.patch

# netlink security fix (CVE-2009-3612)
ApplyPatch netlink-fix-typo-in-initialization.patch

# fix wakeup latency
ApplyPatch sched-update-the-clock-of-runqueue-select-task-rq-selected.patch

# fix mouse and keyboard detection (#522126)
ApplyPatch input-i8042-bypass-aux-irq-delivery-test-on-laptops.patch
ApplyPatch input-i8042-try-disabling-and-re-enabling-aux-port-at-close.patch

# fix null deref in r128
ApplyPatch drm-r128-add-test-for-initialisation-to-all-ioctls-that-require-it.patch

# rhbz#529626
ApplyPatch af_unix-fix-deadlock-connecting-to-shutdown-socket.patch

# Fix exploitable oops in keyring code.
ApplyPatch keys-get_instantiation_keyring-should-inc-the-keyring-refcount.patch

# Fix overflow in KVM cpuid code
ApplyPatch kvm-prevent-overflow-in-kvm-get-supported-cpuid.patch

# disable the stackprotector on fns that don't have onstack arrays
ApplyPatch disable-stackprotector-all.patch

# fs/pipe.c: null ptr dereference fix
# rhbz#530490 (CVE-2009-3547) [ad3960243e55320d74195fb85c975e0a8cc4466c]
ApplyPatch fs-pipe-null-ptr-deref-fix.patch

# 524756
ApplyPatch sata_nv-use-hardreset-only-for-post-boot-probing.patch
ApplyPatch sata_nv-make-sure-link-is-brough-up-online-when-skipping-hardreset.patch

ApplyPatch fuse-prevent-fuse_put_request-in-invalid-ptr.patch

# rhbz#549400 [0bd87182d3ab18a32a8e9175d3f68754c58e3432]
ApplyPatch fuse-fix-kunmap-in-fuse_ioctl_copy_user.patch

# Update Intel GPU DRM drivers
ApplyPatch linux-2.6-intel-gpu-updates.patch

# END OF PATCH APPLICATIONS

%endif

# Any further pre-build tree manipulations happen here.

chmod +x scripts/checkpatch.pl

# only deal with configs if we are going to build for the arch
%ifnarch %nobuildarches

mkdir configs

# Remove configs not for the buildarch
for cfg in kernel-%{version}-*.config; do
  if [ `echo %{all_arch_configs} | grep -c $cfg` -eq 0 ]; then
    rm -f $cfg
  fi
done

%if !%{debugbuildsenabled}
rm -f kernel-%{version}-*debug.config
%endif

# now run oldconfig over all the config files
for i in *.config
do
  mv $i .config
  Arch=`head -1 .config | cut -b 3-`
  make ARCH=$Arch %{oldconfig_target} > /dev/null
  echo "# $Arch" > configs/$i
  cat .config >> configs/$i
done
# end of kernel config
%endif

# get rid of unwanted files resulting from patch fuzz
find . \( -name "*.orig" -o -name "*~" \) -exec rm -f {} \; >/dev/null

cd ..

###
### build
###
%build

%if %{with_sparse}
%define sparse_mflags	C=1
%endif

%if %{fancy_debuginfo}
# This override tweaks the kernel makefiles so that we run debugedit on an
# object before embedding it.  When we later run find-debuginfo.sh, it will
# run debugedit again.  The edits it does change the build ID bits embedded
# in the stripped object, but repeating debugedit is a no-op.  We do it
# beforehand to get the proper final build ID bits into the embedded image.
# This affects the vDSO images in vmlinux, and the vmlinux image in bzImage.
export AFTER_LINK=\
'sh -xc "/usr/lib/rpm/debugedit -b $$RPM_BUILD_DIR -d /usr/src/debug -i $@"'
%endif

cp_vmlinux()
{
  eu-strip --remove-comment -o "$2" "$1"
}

BuildKernel() {
    MakeTarget=$1
    KernelImage=$2
    Flavour=$3
    InstallName=${4:-vmlinuz}

    # Pick the right config file for the kernel we're building
    Config=kernel-%{version}-%{_target_cpu}${Flavour:+-${Flavour}}.config
    DevelDir=/usr/src/kernels/%{KVERREL}${Flavour:+.${Flavour}}

    # When the bootable image is just the ELF kernel, strip it.
    # We already copy the unstripped file into the debuginfo package.
    if [ "$KernelImage" = vmlinux ]; then
      CopyKernel=cp_vmlinux
    else
      CopyKernel=cp
    fi

    KernelVer=%{version}-%{release}.%{_target_cpu}${Flavour:+.${Flavour}}
    echo BUILDING A KERNEL FOR ${Flavour} %{_target_cpu}...

    # make sure EXTRAVERSION says what we want it to say
    perl -p -i -e "s/^EXTRAVERSION.*/EXTRAVERSION = %{?stablerev}-%{release}.%{_target_cpu}${Flavour:+.${Flavour}}/" Makefile

    # if pre-rc1 devel kernel, must fix up SUBLEVEL for our versioning scheme
    %if !0%{?rcrev}
    %if 0%{?gitrev}
    perl -p -i -e 's/^SUBLEVEL.*/SUBLEVEL = %{upstream_sublevel}/' Makefile
    %endif
    %endif

    # and now to start the build process

    make -s mrproper
    cp configs/$Config .config

    Arch=`head -1 .config | cut -b 3-`
    echo USING ARCH=$Arch

    make -s ARCH=$Arch %{oldconfig_target} > /dev/null
    make -s ARCH=$Arch V=1 %{?_smp_mflags} $MakeTarget %{?sparse_mflags}
    make -s ARCH=$Arch V=1 %{?_smp_mflags} modules %{?sparse_mflags} || exit 1

    # Start installing the results
%if %{with_debuginfo}
    mkdir -p $RPM_BUILD_ROOT%{debuginfodir}/boot
    mkdir -p $RPM_BUILD_ROOT%{debuginfodir}/%{image_install_path}
%endif
    mkdir -p $RPM_BUILD_ROOT/%{image_install_path}
    install -m 644 .config $RPM_BUILD_ROOT/boot/config-$KernelVer
    install -m 644 System.map $RPM_BUILD_ROOT/boot/System.map-$KernelVer
    touch $RPM_BUILD_ROOT/boot/initrd-$KernelVer.img
    if [ -f arch/$Arch/boot/zImage.stub ]; then
      cp arch/$Arch/boot/zImage.stub $RPM_BUILD_ROOT/%{image_install_path}/zImage.stub-$KernelVer || :
    fi
    $CopyKernel $KernelImage \
    		$RPM_BUILD_ROOT/%{image_install_path}/$InstallName-$KernelVer
    chmod 755 $RPM_BUILD_ROOT/%{image_install_path}/$InstallName-$KernelVer

    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer
    # Override $(mod-fw) because we don't want it to install any firmware
    # We'll do that ourselves with 'make firmware_install'
    make -s ARCH=$Arch INSTALL_MOD_PATH=$RPM_BUILD_ROOT modules_install KERNELRELEASE=$KernelVer mod-fw=
%ifarch %{vdso_arches}
    make -s ARCH=$Arch INSTALL_MOD_PATH=$RPM_BUILD_ROOT vdso_install KERNELRELEASE=$KernelVer
    if grep '^CONFIG_XEN=y$' .config >/dev/null; then
      echo > ldconfig-kernel.conf "\
# This directive teaches ldconfig to search in nosegneg subdirectories
# and cache the DSOs there with extra bit 0 set in their hwcap match
# fields.  In Xen guest kernels, the vDSO tells the dynamic linker to
# search in nosegneg subdirectories and to match this extra hwcap bit
# in the ld.so.cache file.
hwcap 0 nosegneg"
    fi
    if [ ! -s ldconfig-kernel.conf ]; then
      echo > ldconfig-kernel.conf "\
# Placeholder file, no vDSO hwcap entries used in this kernel."
    fi
    %{__install} -D -m 444 ldconfig-kernel.conf \
        $RPM_BUILD_ROOT/etc/ld.so.conf.d/kernel-$KernelVer.conf
%endif

    # And save the headers/makefiles etc for building modules against
    #
    # This all looks scary, but the end result is supposed to be:
    # * all arch relevant include/ files
    # * all Makefile/Kconfig files
    # * all script/ files

    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/source
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    (cd $RPM_BUILD_ROOT/lib/modules/$KernelVer ; ln -s build source)
    # dirs for additional modules per module-init-tools, kbuild/modules.txt
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/extra
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/updates
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/weak-updates
    # first copy everything
    cp --parents `find  -type f -name "Makefile*" -o -name "Kconfig*"` $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp Module.symvers $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp System.map $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    if [ -s Module.markers ]; then
      cp Module.markers $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    fi
    # then drop all but the needed Makefiles/Kconfig files
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Documentation
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    cp .config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp -a scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    if [ -d arch/$Arch/scripts ]; then
      cp -a arch/$Arch/scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{_arch} || :
    fi
    if [ -f arch/$Arch/*lds ]; then
      cp -a arch/$Arch/*lds $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{_arch}/ || :
    fi
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*.o
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*/*.o
%ifarch ppc
    cp -a --parents arch/powerpc/lib/crtsavres.[So] $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/
%endif
    if [ -d arch/%{asmarch}/include ]; then
      cp -a --parents arch/%{asmarch}/include $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/
    fi
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    cd include
    cp -a acpi config crypto keys linux math-emu media mtd net pcmcia rdma rxrpc scsi sound trace video drm asm-generic $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    asmdir=$(readlink asm)
    cp -a $asmdir $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/
    pushd $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    ln -s $asmdir asm
    popd
    # Make sure the Makefile and version.h have a matching timestamp so that
    # external modules can be built
    touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Makefile $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/linux/version.h
    touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/.config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/linux/autoconf.h
    # Copy .config to include/config/auto.conf so "make prepare" is unnecessary.
    cp $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/.config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/config/auto.conf
    cd ..

    #
    # save the vmlinux file for kernel debugging into the kernel-debuginfo rpm
    #
%if %{with_debuginfo}
    mkdir -p $RPM_BUILD_ROOT%{debuginfodir}/lib/modules/$KernelVer
    cp vmlinux $RPM_BUILD_ROOT%{debuginfodir}/lib/modules/$KernelVer
%endif

    find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" -type f >modnames

    # mark modules executable so that strip-to-file can strip them
    xargs --no-run-if-empty chmod u+x < modnames

    # Generate a list of modules for block and networking.

    fgrep /drivers/ modnames | xargs --no-run-if-empty nm -upA |
    sed -n 's,^.*/\([^/]*\.ko\):  *U \(.*\)$,\1 \2,p' > drivers.undef

    collect_modules_list()
    {
      sed -r -n -e "s/^([^ ]+) \\.?($2)\$/\\1/p" drivers.undef |
      LC_ALL=C sort -u > $RPM_BUILD_ROOT/lib/modules/$KernelVer/modules.$1
    }

    collect_modules_list networking \
    			 'register_netdev|ieee80211_register_hw|usbnet_probe'
    collect_modules_list block \
    			 'ata_scsi_ioctl|scsi_add_host|blk_init_queue|register_mtd_blktrans|scsi_esp_register'
    collect_modules_list drm \
    			 'drm_open|drm_init'
    collect_modules_list modesetting \
    			 'drm_crtc_init'

    # detect missing or incorrect license tags
    rm -f modinfo
    while read i
    do
      echo -n "${i#$RPM_BUILD_ROOT/lib/modules/$KernelVer/} " >> modinfo
      /sbin/modinfo -l $i >> modinfo
    done < modnames

    egrep -v \
    	  'GPL( v2)?$|Dual BSD/GPL$|Dual MPL/GPL$|GPL and additional rights$' \
	  modinfo && exit 1

    rm -f modinfo modnames

    # remove files that will be auto generated by depmod at rpm -i time
    for i in alias alias.bin ccwmap dep dep.bin ieee1394map inputmap isapnpmap ofmap pcimap seriomap symbols symbols.bin usbmap
    do
      rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/modules.$i
    done

    # Move the devel headers out of the root file system
    mkdir -p $RPM_BUILD_ROOT/usr/src/kernels
    mv $RPM_BUILD_ROOT/lib/modules/$KernelVer/build $RPM_BUILD_ROOT/$DevelDir
    ln -sf ../../..$DevelDir $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
}

###
# DO it...
###

# prepare directories
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/boot

cd linux-%{kversion}.%{_target_cpu}

%if %{with_debug}
%if %{with_up}
BuildKernel %make_target %kernel_image debug
%endif
%if %{with_pae}
BuildKernel %make_target %kernel_image PAEdebug
%endif
%endif

%if %{with_pae}
BuildKernel %make_target %kernel_image PAE
%endif

%if %{with_up}
BuildKernel %make_target %kernel_image
%endif

%if %{with_smp}
BuildKernel %make_target %kernel_image smp
%endif

%if %{with_kdump}
BuildKernel vmlinux vmlinux kdump vmlinux
%endif

%if %{with_doc}
# Make the HTML and man pages.
make %{?_smp_mflags} htmldocs mandocs || %{doc_build_fail}

# sometimes non-world-readable files sneak into the kernel source tree
chmod -R a=rX Documentation
find Documentation -type d | xargs chmod u+w
%endif

###
### Special hacks for debuginfo subpackages.
###

# This macro is used by %%install, so we must redefine it before that.
%define debug_package %{nil}

%if %{fancy_debuginfo}
%define __debug_install_post \
  /usr/lib/rpm/find-debuginfo.sh %{debuginfo_args} %{_builddir}/%{?buildsubdir}\
%{nil}
%endif

%if %{with_debuginfo}
%ifnarch noarch
%global __debug_package 1
%files -f debugfiles.list debuginfo-common-%{_target_cpu}
%defattr(-,root,root)
%endif
%endif

###
### install
###

%install

cd linux-%{kversion}.%{_target_cpu}

%if %{with_doc}
docdir=$RPM_BUILD_ROOT%{_datadir}/doc/kernel-doc-%{rpmversion}
man9dir=$RPM_BUILD_ROOT%{_datadir}/man/man9

# copy the source over
mkdir -p $docdir
tar -f - --exclude=man --exclude='.*' -c Documentation | tar xf - -C $docdir

# Install man pages for the kernel API.
mkdir -p $man9dir
find Documentation/DocBook/man -name '*.9.gz' -print0 |
xargs -0 --no-run-if-empty %{__install} -m 444 -t $man9dir $m
ls $man9dir | grep -q '' || > $man9dir/BROKEN
%endif

%if %{with_headers}
# Install kernel headers
make ARCH=%{hdrarch} INSTALL_HDR_PATH=$RPM_BUILD_ROOT/usr headers_install

# Do headers_check but don't die if it fails.
make ARCH=%{hdrarch} INSTALL_HDR_PATH=$RPM_BUILD_ROOT/usr headers_check \
     > hdrwarnings.txt || :
if grep -q exist hdrwarnings.txt; then
   sed s:^$RPM_BUILD_ROOT/usr/include/:: hdrwarnings.txt
   # Temporarily cause a build failure if header inconsistencies.
   # exit 1
fi

find $RPM_BUILD_ROOT/usr/include \
     \( -name .install -o -name .check -o \
     	-name ..install.cmd -o -name ..check.cmd \) | xargs rm -f

# glibc provides scsi headers for itself, for now
rm -rf $RPM_BUILD_ROOT/usr/include/scsi
rm -f $RPM_BUILD_ROOT/usr/include/asm*/atomic.h
rm -f $RPM_BUILD_ROOT/usr/include/asm*/io.h
rm -f $RPM_BUILD_ROOT/usr/include/asm*/irq.h
%endif

%if %{with_firmware}
# having a .config file present during firmware install creates confusion
mv .config .config.firmware_save
make INSTALL_FW_PATH=$RPM_BUILD_ROOT/lib/firmware firmware_install
mv .config.firmware_save .config
%endif

%if %{with_bootwrapper}
make DESTDIR=$RPM_BUILD_ROOT bootwrapper_install WRAPPER_OBJDIR=%{_libdir}/kernel-wrapper WRAPPER_DTSDIR=%{_libdir}/kernel-wrapper/dts
%endif

###
### clean
###

%clean
rm -rf $RPM_BUILD_ROOT

###
### scripts
###

#
# This macro defines a %%post script for a kernel*-devel package.
#	%%kernel_devel_post [<subpackage>]
#
%define kernel_devel_post() \
%{expand:%%post %{?1:%{1}-}devel}\
if [ -f /etc/sysconfig/kernel ]\
then\
    . /etc/sysconfig/kernel || exit $?\
fi\
if [ "$HARDLINK" != "no" -a -x /usr/sbin/hardlink ]\
then\
    (cd /usr/src/kernels/%{KVERREL}%{?1:.%{1}} &&\
     /usr/bin/find . -type f | while read f; do\
       hardlink -c /usr/src/kernels/*.fc*.*/$f $f\
     done)\
fi\
%{nil}

# This macro defines a %%posttrans script for a kernel package.
#	%%kernel_variant_posttrans [<subpackage>]
# More text can follow to go at the end of this variant's %%post.
#
%define kernel_variant_posttrans() \
%{expand:%%posttrans %{?1}}\
/sbin/new-kernel-pkg --package kernel%{?1:-%{1}} --rpmposttrans %{KVERREL}%{?1:.%{1}} || exit $?\
%{nil}

#
# This macro defines a %%post script for a kernel package and its devel package.
#	%%kernel_variant_post [-v <subpackage>] [-r <replace>]
# More text can follow to go at the end of this variant's %%post.
#
%define kernel_variant_post(v:r:) \
%{expand:%%kernel_devel_post %{?-v*}}\
%{expand:%%kernel_variant_posttrans %{?-v*}}\
%{expand:%%post %{?-v*}}\
%{-r:\
if [ `uname -i` == "x86_64" -o `uname -i` == "i386" ] &&\
   [ -f /etc/sysconfig/kernel ]; then\
  /bin/sed -r -i -e 's/^DEFAULTKERNEL=%{-r*}$/DEFAULTKERNEL=kernel%{?-v:-%{-v*}}/' /etc/sysconfig/kernel || exit $?\
fi}\
/sbin/new-kernel-pkg --package kernel%{?-v:-%{-v*}} --mkinitrd --depmod --install %{KVERREL}%{?-v:.%{-v*}} || exit $?\
#if [ -x /sbin/weak-modules ]\
#then\
#    /sbin/weak-modules --add-kernel %{KVERREL}%{?-v*} || exit $?\
#fi\
%{nil}

#
# This macro defines a %%preun script for a kernel package.
#	%%kernel_variant_preun <subpackage>
#
%define kernel_variant_preun() \
%{expand:%%preun %{?1}}\
/sbin/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVERREL}%{?1:.%{1}} || exit $?\
#if [ -x /sbin/weak-modules ]\
#then\
#    /sbin/weak-modules --remove-kernel %{KVERREL}%{?1} || exit $?\
#fi\
%{nil}

%kernel_variant_preun
%ifarch x86_64
%kernel_variant_post -r (kernel-smp|kernel-xen)
%else
%kernel_variant_post -r kernel-smp
%endif

%kernel_variant_preun smp
%kernel_variant_post -v smp

%kernel_variant_preun PAE
%kernel_variant_post -v PAE -r (kernel|kernel-smp|kernel-xen)

%kernel_variant_preun debug
%kernel_variant_post -v debug

%kernel_variant_post -v PAEdebug -r (kernel|kernel-smp|kernel-xen)
%kernel_variant_preun PAEdebug

if [ -x /sbin/ldconfig ]
then
    /sbin/ldconfig -X || exit $?
fi

###
### file lists
###

%if %{with_headers}
%files headers
%defattr(-,root,root)
/usr/include/*
%endif

%if %{with_firmware}
%files firmware
%defattr(-,root,root)
/lib/firmware/*
%doc linux-%{kversion}.%{_target_cpu}/firmware/WHENCE
%endif

%if %{with_bootwrapper}
%files bootwrapper
%defattr(-,root,root)
/usr/sbin/*
%{_libdir}/kernel-wrapper
%endif

# only some architecture builds need kernel-doc
%if %{with_doc}
%files doc
%defattr(-,root,root)
%{_datadir}/doc/kernel-doc-%{rpmversion}/Documentation/*
%dir %{_datadir}/doc/kernel-doc-%{rpmversion}/Documentation
%dir %{_datadir}/doc/kernel-doc-%{rpmversion}
%{_datadir}/man/man9/*
%endif

# This is %{image_install_path} on an arch where that includes ELF files,
# or empty otherwise.
%define elf_image_install_path %{?kernel_image_elf:%{image_install_path}}

#
# This macro defines the %%files sections for a kernel package
# and its devel and debuginfo packages.
#	%%kernel_variant_files [-k vmlinux] <condition> <subpackage>
#
%define kernel_variant_files(k:) \
%if %{1}\
%{expand:%%files %{?2}}\
%defattr(-,root,root)\
/%{image_install_path}/%{?-k:%{-k*}}%{!?-k:vmlinuz}-%{KVERREL}%{?2:.%{2}}\
/boot/System.map-%{KVERREL}%{?2:.%{2}}\
#/boot/symvers-%{KVERREL}%{?2:.%{2}}.gz\
/boot/config-%{KVERREL}%{?2:.%{2}}\
%dir /lib/modules/%{KVERREL}%{?2:.%{2}}\
/lib/modules/%{KVERREL}%{?2:.%{2}}/kernel\
/lib/modules/%{KVERREL}%{?2:.%{2}}/build\
/lib/modules/%{KVERREL}%{?2:.%{2}}/source\
/lib/modules/%{KVERREL}%{?2:.%{2}}/extra\
/lib/modules/%{KVERREL}%{?2:.%{2}}/updates\
/lib/modules/%{KVERREL}%{?2:.%{2}}/weak-updates\
%ifarch %{vdso_arches}\
/lib/modules/%{KVERREL}%{?2:.%{2}}/vdso\
/etc/ld.so.conf.d/kernel-%{KVERREL}%{?2:.%{2}}.conf\
%endif\
/lib/modules/%{KVERREL}%{?2:.%{2}}/modules.*\
%ghost /boot/initrd-%{KVERREL}%{?2:.%{2}}.img\
%{expand:%%files %{?2:%{2}-}devel}\
%defattr(-,root,root)\
%dir /usr/src/kernels\
%verify(not mtime) /usr/src/kernels/%{KVERREL}%{?2:.%{2}}\
/usr/src/kernels/%{KVERREL}%{?2:.%{2}}\
%if %{with_debuginfo}\
%ifnarch noarch\
%if %{fancy_debuginfo}\
%{expand:%%files -f debuginfo%{?2}.list %{?2:%{2}-}debuginfo}\
%else\
%{expand:%%files %{?2:%{2}-}debuginfo}\
%endif\
%defattr(-,root,root)\
%if !%{fancy_debuginfo}\
%if "%{elf_image_install_path}" != ""\
%{debuginfodir}/%{elf_image_install_path}/*-%{KVERREL}%{?2:.%{2}}.debug\
%endif\
%{debuginfodir}/lib/modules/%{KVERREL}%{?2:.%{2}}\
%{debuginfodir}/usr/src/kernels/%{KVERREL}%{?2:.%{2}}\
%endif\
%endif\
%endif\
%endif\
%{nil}


%kernel_variant_files %{with_up}
%kernel_variant_files %{with_smp} smp
%if %{with_up}
%kernel_variant_files %{with_debug} debug
%endif
%kernel_variant_files %{with_pae} PAE
%kernel_variant_files %{with_pae_debug} PAEdebug
%kernel_variant_files -k vmlinux %{with_kdump} kdump

# plz don't put in a version string unless you're going to tag
# and build.

%changelog
* Thu Dec 24 2009 Kyle McMartin <kyle@redhat.com> 2.6.30.10-105
- fuse: fix kunmap in fuse_ioctl_copy_user, #549400

* Tue Dec 08 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.10-104
- Copy fix for #540580 from F-12.

* Fri Dec 04 2009 Kyle McMartin <kyle@redhat.com> 2.6.30.10-103
- 2.6.30.10
- nuke ipv4-fix-null-ptr-deref-in-ip_fragment.patch, it's in the latest
  stable release.

* Thu Dec 03 2009 Kyle McMartin <kyle@redhat.com> 2.6.30.9-102
- ipv4-fix-null-ptr-deref-in-ip_fragment.patch: null ptr deref
  bug fix.

* Thu Nov 19 2009 Kyle McMartin <kyle@redhat.com>
- fuse-prevent-fuse_put_request-in-invalid-ptr.patch: fix oops in fuse
  when low on memory. rhbz#538734.

* Thu Nov 19 2009 David Woodhouse <David.Woodhouse@intel.com> 2.6.30.9-100
- Re-enable CONFIG_DMAR_GFX_WA on x86_64.

* Tue Nov 17 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-99
- Silence pointless DRM warning message (#537196)

* Tue Nov 17 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-98
- More sata_nv fixes (#524756).

* Mon Nov 16 2009 Eric Sandeen <sandeen@redhat.com> 2.6.30.9-97
- Fix ext4 preallocation-related corruption (#513221)

* Tue Nov 03 2009 Kyle McMartin <kyle@redhat.com> 2.6.30.9-96
- fs/pipe.c: fix null pointer dereference (CVE-2009-3547)

* Sun Oct 25 2009 Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-95
- Disable the stack protector on functions that don't have onstack arrays.

* Thu Oct 22 2009 Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-94
- Fix overflow in KVM cpuid code. (CVE-2009-3638)

* Thu Oct 22 2009 Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-93
- Fix exploitable oops in keyring code (CVE-2009-3624)

* Wed Oct 21 2009 Kyle McMartin <kyle@redhat.com>
- shut-up-LOCK_TEST_WITH_RETURN.patch: sort out #445331... or paper bag
  over it for now until the lock warnings can be killed.

* Mon Oct 19 2009 Kyle McMartin <kyle@redhat.com>
- af_unix-fix-deadlock-connecting-to-shutdown-socket.patch: fix for
  rhbz#529626 local DoS. (CVE-2009-3621)

* Sat Oct 17 2009 Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-90
- Fix null deref in r128 (F10#487546) (CVE-2009-3620)

* Sat Oct 17 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-89
- Keyboard and mouse fixes from 2.6.32 (#522126)

* Sat Oct 17 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-88
- Scheduler wakeup patch, fixes high latency on wakeup
  (sched-update-the-clock-of-runqueue-select-task-rq-selected.patch)

* Fri Oct 16 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-87
- Fix uninitialized data leak in netlink (CVE-2009-3612)

* Thu Oct 15 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-86
- AX.25 security fix (CVE-2009-2909)

* Thu Oct 15 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-85
- Disable CONFIG_USB_STORAGE_CYPRESS_ATACB because it causes failure
  to boot from USB disks using Cypress bridges (#524998)

* Tue Oct 13 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-84
- Copy libata drive detection fix from 2.6.31.4 (#524756)

* Tue Oct 13 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-83
- Networking fixes taken from 2.6.31-stable

* Tue Oct 13 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.9-82
- Fix boot hang with ACPI on some systems.

* Mon Oct 12 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-81
- Critical ftrace fixes:
  ftrace-use-module-notifier-for-function-tracer.patch
  ftrace-check-for-failure-for-all-conversions.patch
  tracing-correct-module-boundaries-for-ftrace_release.patch

* Thu Oct 08 2009 Ben Skeggs <bskeggs@redhat.com>     2.6.30.9-80
- ppc: compile nvidiafb as a module only, nvidiafb+nouveau = bang! (rh#491308)

* Wed Oct 07 2009 Dave Jones <davej@redhat.com>       2.6.30.9-78
- Disable IRQSOFF tracer. (Adds unnecessary overhead when unused)

* Wed Oct 07 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-77
- eCryptfs fixes taken from 2.6.31.2 (fixes CVE-2009-2908)

* Tue Oct 06 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-76
- fix race in forcedeth network driver (#526546)

* Tue Oct 06 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-75
- x86: Don't leak 64-bit reg contents to 32-bit tasks.

* Tue Oct 06 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-74
- ACPI EC bug fixes taken from kernel 2.6.32 (#492699, #525681)

* Mon Oct 05 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-73
- Linux 2.6.30.9

* Sun Oct 04 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-72.rc3
- Copy stack randomization fix from 2.6.31.2 (F10#526882)

* Sun Oct 04 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.9-71.rc3
- Linux 2.6.30.9-rc3
- Drop merged upstream patches:
  linux-2.6-cifs-reenable-lanman-security.patch
  kvm-guest-fix-bogus-wallclock-physical-address-calculation.patch
  kvm-mmu-make-__kvm_mmu_free_some_pages-handle-empty-list.patch
  kvm-vmx-check-cpl-before-emulating-debug-register-access.patch
  kvm-vmx-fix-cr8-exiting-control-clobbering-by-ept.patch
  kvm-x86-disallow-hypercalls-for-guest-callers-in-rings-0.patch
  linux-2.6-kvm-revert-x86-check-for-cr3-validity.patch

* Fri Oct  2 2009  Justin M. Forbes <jforbes@redhat.com>  2.6.30.8-70
- Add linux-2.6-virtio-net-refill-on-out-of-memory.patch, from 2.6.31
  to prevent page allocation failures in guests. (#520119)

* Mon Sep 28 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.8-69
- Add linux-2.6-kvm-revert-x86-check-for-cr3-validity.patch, from
  2.6.32-rc, fixes bug #525743

* Mon Sep 28 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.8-68
- Drop sched-disable-NEW-FAIR-SLEEPERS-for-now.patch, reported to
  cause problems on 2.6.30.

* Sat Sep 26 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.8-67
- Scheduler fixes cherry-picked from 2.6.32

* Sat Sep 26 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.8-66
- Backport "appletalk: Fix skb leak when ipddp interface is not loaded"
  (fixes CVE-2009-2903)

* Sat Sep 26 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.8-65
- KVM fixes from 2.6.31.1, including fix for CVE-2009-3290

* Fri Sep 25 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.8-64
- Fix serious CFQ performance regression.

* Fri Sep 25 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.8-63
- Disable the GEM graphics manager on i686 PAE kernels
  (fixes modesetting on Intel graphics.)

* Fri Sep 25 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.8-62
- Fix breakage in hostap driver (#522269)

* Thu Sep 24 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.8-61
- Backport the cpuidle-faster-io fix from Fedora 12 to fix I/O
  performance problems when reading/writing multiple disks.

* Thu Sep 24 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.8-60
- Linux 2.6.30.8

* Thu Sep 24 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.7-59
- Disable sound powersave by default; it still pops when playing sounds. (#523836)

* Wed Sep 16 2009 Justin M. Forbes <jforbes@redhat.com> 2.6.30.7-58
- Revert virtio_blk to rotational mode. (#509383)

* Tue Sep 15 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.7-57
- Linux 2.6.30.7

* Tue Sep 15 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.7-56.rc1
- Fix CIFS security flags mask broken in 2.6.30 (#523173)

* Tue Sep 15 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.7-55.rc1
- Fix cpufreq lockdep warnings (#522685)

* Sat Sep 12 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.7-54.rc1
- 2.6.30.7-rc1
- Drop patches merged in -stable:
   linux-2.6-slub-fix-destroy-by-rcu.patch

* Thu Sep 10 2009 Dennis Gilmore <dennis@ausil.us> 2.6.30.6-53
- kgdb only works on sparc64 smp kernels so disable on the up one and enable on the smp one
- update to 256 cpus supported on sparc64 smp

* Wed Sep 09 2009  Chuck Ebbert <cebbert@redhat.com>  2.6.30.6-52
- Add linux-2.6-slub-fix-destroy-by-rcu.patch (fixes bug in 2.6.30.4)

* Wed Sep 09 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.6-51
- 2.6.30.6
- Drop patches merged in -stable:
  do_sigaltstack-avoid-copying-stack_t-as-a-structure-to-userspace.patch
  linux-2.6-x86-dont-send-ipi-to-empty-set-cpus.patch
  linux-2.6-bitmap-make-ops-return-result.patch
  linux-2.6-x86-dont-call-send-ipi-mask-with-empty-mask.patch
  linux-2.6-clone-fix-race-between-copy-process-and-de-thread.patch
  linux-2.6-kthreads-fix-kthread-create-vs-kthread-stop.patch
  linux-2.6-xen-x86-dont-probe-if-apics-are-disabled.patch

* Tue Sep 08 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-50
- Disable Amiga One support to fix powerpc coherency bug (#521703)

* Fri Sep 04 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-49
- Fix build system getting confused during firmware install.

* Fri Sep 04 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-48
- Added additional fixes needed for #514787:
  linux-2.6-ppc64-vs-broadcom-lmb-no-init-*.patch
- Fix up lirc patch context so it applies.

* Wed Sep 02 2009 Jarod Wilson <jarod@redhat.com>
- Make it possible to rmmod lirc_zilog w/o it hanging indefinitely
- Add transmit support (via port 2 only) on 1st-gen mceusb transceiver

* Tue Sep 01 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-46
- Fix yet another Xen boot crash (#520517)

* Tue Sep 01 2009 Jarod Wilson <jarod@redhat.com> 2.6.30.5-45
- Refresh lirc patches, add new lirc_ene0100 driver
- Fix up hdpvr driver for use with modular i2c so that
  lirc_zilog can actually bind to it
- Make lirc_zilog IR transmit and receive work on the hdpvr
- Fix audio on PVR-500 when used in same system as HVR-1800 (#480728)

* Fri Aug 28 2009 David Woodhouse <David.Woodhouse@intel.com>
- Enable Solos DSL driver

* Thu Aug 27 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-43
- Don't load the floppy driver automatically:
  linux-2.6-defaults-die-floppy-die.patch

* Thu Aug 27 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-42
- Fix stackprotector problems with Xen on x86_64.
- Disable stackprotector on i386 until 32-bit Xen gets fixed.

* Thu Aug 27 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-41
- linux-2.6-kthreads-fix-kthread-create-vs-kthread-stop.patch:
  fix race in kthreads.

* Thu Aug 27 2009 Justin M. Forbes <jforbes@redhat.com> 2.6.30.5-40
- xen: Fix guest crash when trying to debug. (#458385)

* Thu Aug 27 2009 John W. Linville <linville@redhat.com> 2.6.30.5-39
- zd1211rw: adding 083a:e503 as a ZD1211B device (#518538)

* Thu Aug 27 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-38
- Fix string overflows found by stackprotector:
  hda-check-strcpy-length.patch
  linux-2.6-v4l-dvb-af9015-fix-stack-corruption.patch

* Thu Aug 27 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-37
- Fix race in clone() syscall.

* Thu Aug 27 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-36
- Fix hangs on older x86 systems with 440*X chipsets.

* Fri Aug 21 2009 David Woodhouse <David.Woodhouse@intel.com>
- Fix b43 on iMac G5 (#514787)

* Tue Aug 18 2009 Kyle McMartin <kyle@redhat.com>
- Backport several upstream commits 52dec22e739eec8f3a0154f768a599f5489048bd
  to improve mmap_min_addr.
- CVE-2009-2847: do_sigaltstack: avoid copying 'stack_t' as a
  structure to user space

* Mon Aug 17 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-32
- Change config options:
  CONFIG_SCSI_DEBUG=m
  CONFIG_PCI_MSI_DEFAULT_ON=y

* Mon Aug 17 2009 Jarod Wilson <jarod@redhat.com> 2.6.30.5-31
- Fix flub in prior lirc patch update that resulted in no lirc
  drivers getting built

* Sun Aug 16 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-29
- Linux 2.6.30.5

* Fri Aug 14 2009 Chuck Ebbert <cebbert@redhat.com> 2.6.30.5-28.rc2
- Linux 2.6.30.5-rc2
- Dropped drm-intel-tv-fix.patch, merged in -stable now.

* Wed Aug 12 2009 Kyle McMartin <kyle@redhat.com>
- drm-no-gem-on-i8xx.patch: fix misspelled IS_8XX & IS_I845G, sigh.

* Wed Aug 12 2009 Kyle McMartin <kyle@redhat.com>
- DRM patch sync-up with F-11-2.6.29.y, ABI probably isn't right yet though...
 - drm-modesetting-radeon.patch
 - drm-nouveau.patch
 - drm-no-gem-on-i8xx.patch
 - drm-i915-resume-force-mode.patch
 - drm-intel-big-hammer.patch
 - drm-intel-gen3-fb-hack.patch
 - drm-intel-hdmi-edid-fix.patch
 - drm-modesetting-radeon-fixes.patch
 - drm-radeon-new-pciids.patch
 - drm-dont-frob-i2c.patch
 - drm-intel-tv-fix.patch
 - drm-radeon-cs-oops-fix.patch
 - drm-pnp-add-resource-range-checker.patch
 - drm-i915-enable-mchbar.patch
- The rest were merged upstream.

* Wed Aug 12 2009 John W. Linville <linville@redhat.com>
- iwlwifi: fix TX queue race

* Mon Aug 10 2009 Kyle McMartin <kyle@redhat.com>
- Patch sync-up with F-11-2.6.29.y:
 - linux-2.6-x86-delay-tsc-barrier.patch
 - linux-2.6-fs-cifs-fix-port-numbers.patch
 - linux-2.6-kvm-skip-pit-check.patch
 - linux-2.6.29-xen-disable-gbpages.patch
 - linux-2.6-virtio_blk-dont-bounce-highmem-requests.patch
 - linux-2.6-drivers-char-low-latency-removal.patch
 - linux-2.6-serial-add-txen-test-param.patch
 - linux-2.6-input-wacom-bluetooth.patch
 - linux-2.6-defaults-saner-vm-settings.patch
 - linux-2.6-mm-lru-evict-streaming-io-pages-first.patch
 - linux-2.6-mm-lru-report-vm-flags-in-page-referenced.patch
 - linux-2.6-mm-lru-dont-evict-mapped-executable-pages.patch
 - linux-2.6-utrace.patch
 - linux-2.6-utrace-ftrace.patch
 - linux-2.6-tracehook.patch

* Mon Aug 10 2009 Jarod Wilson <jarod@redhat.com>
- Add tunable pad threshold support to lirc_imon
- Blacklist all iMON devices in usbhid driver so lirc_imon can bind
- Add new device ID to lirc_mceusb (#512483)
- Enable IR transceiver on the HD PVR

* Wed Aug 05 2009 Kyle McMartin <kyle@redhat.com>
- Update to released 2.6.30.4.
- Drop now-unneeded upstream reverts.

* Wed Jul 29 2009 Chuck Ebbert <cebbert@redhat.com>
- Linux 2.6.30.4-rc1

* Mon Jul 27 2009 Neil Horman <nhorman@redhat.com>
- Backport xfrm gc_thresh export code (bz 503124)

* Fri Jul 24 2009 Kyle McMartin <kyle@redhat.com>
- CONFIG_DEFAULT_MMAP_MIN_ADDR=65536 [i386 x86_64], 4096 elsewhere, as
  per defconfigs.
- Blat patches from other tag, now to rebase fixes, splat in the changelog,
  and tag it for building.

* Fri Jul 24 2009 Kyle McMartin <kyle@redhat.com>
- Copy over release configs from devel-2.6.30 tag.
- Fix up some spec deviations.

* Fri Jul 24 2009 Kyle McMartin <kyle@redhat.com>
- Linux 2.6.30.3 rebase for Fedora 11.
- Fedora 11 2.6.29 branch is on tag private-fedora-11-2_6_29_6.

