<?xml version="1.0"?>

<!-- 
	To support clustering, this is used to add the modeshape service bindings and system properties to the bindings-jboss-beans.xml file at install time.
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0"
    xmlns="urn:jboss:bean-deployer:2.0"
    xmlns:sbm="urn:jboss:bean-deployer:2.0"
    exclude-result-prefixes="sbm">
	<xsl:output method="xml" version="1.0" encoding="UTF-8"
		indent="yes"
	/>

    <xsl:template match="/sbm:deployment/sbm:bean[@name='SystemPropertyBinder']/sbm:constructor/sbm:parameter/sbm:set">
        <xsl:call-template name="add-system-property">
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="/sbm:deployment/sbm:bean/sbm:constructor/sbm:parameter/sbm:set[@elementClass='org.jboss.services.binding.ServiceBindingMetadata']">
        <xsl:call-template name="add-to-standard-bindings">
            <xsl:with-param name="jndiPort" select="1099"/>
            <xsl:with-param name="webPort" select="8080"/>
        </xsl:call-template>
    </xsl:template>

	<xsl:template name="add-to-standard-bindings">
        <xsl:copy xml:space="preserve"><xsl:apply-templates select="@*|node()"/>
            <xsl:text>
            </xsl:text>
            <xsl:comment> ************ ModeShape Bindings configuration for Clustering ************ </xsl:comment><xsl:text>
	</xsl:text>
             <bean class="org.jboss.services.binding.ServiceBindingMetadata">
                <property name="serviceName">JGroups</property>
                <property name="bindingName">modeshape-bind_port</property>
                <property name="port">55275</property>
                <property name="hostName">${jboss.jgroups.bind.address,jboss.bind.address}</property>
                <property name="description">The port used for the JGroups 'modeshape-cluster' stack</property>
             </bean>
 	     <xsl:text>
            </xsl:text>
             <bean class="org.jboss.services.binding.ServiceBindingMetadata">
                <property name="serviceName">JGroups</property>
                <property name="bindingName">modeshape-mcast</property>
                <property name="hostName">${jboss.partition.udpGroup:230.0.0.4}</property>
                <property name="port">45690</property>
                <property name="description">Multicast socket on which JGroups 'modeshape-cluster' stack communicates</property>
                <!-- This address should not be changed between different 
                     binding sets; all nodes need to listen on the same 
                     multicast address -->
                <property name="fixedHostName">true</property>
                <!-- This port should not be changed between different 
                     binding sets; all nodes need to listen on the same port -->
                <property name="fixedPort">true</property>
             </bean>
	     <xsl:text>
            </xsl:text>
	    </xsl:copy>
    </xsl:template>
    
    <xsl:template name="add-system-property">
        <xsl:copy xml:space="preserve"><xsl:apply-templates select="@*|node()"/>
            <xsl:text>
               </xsl:text>
            <xsl:comment>************ ModeShape System Properties ************ </xsl:comment><xsl:text>
               </xsl:text>

                <bean class="org.jboss.services.binding.SystemPropertyBinding">
                   <constructor>
                      <parameter>jboss.jgroups.modeshape.bind_port</parameter>
                      <parameter class="int">
                         <value-factory bean="ServiceBindingManager" method="getIntBinding">
                              <parameter>JGroups</parameter>
                              <parameter>modeshape-bind_port</parameter>
                         </value-factory>
                      </parameter>
                   </constructor>
                </bean>
                <bean class="org.jboss.services.binding.SystemPropertyBinding">
                   <constructor>
                      <parameter>jboss.jgroups.modeshape.mcast_port</parameter>
                      <parameter class="int">
                         <value-factory bean="ServiceBindingManager" method="getIntBinding">
                              <parameter>JGroups</parameter>
                              <parameter>modeshape-mcast</parameter>
                         </value-factory>
                      </parameter>
                   </constructor>
                </bean>
                <bean class="org.jboss.services.binding.SystemPropertyBinding">
                   <constructor>
                      <parameter>jboss.jgroups.modeshape.mcast_addr</parameter>
                      <parameter class="java.lang.String">
                         <value-factory bean="ServiceBindingManager" method="getStringBinding">
                              <parameter>JGroups</parameter>
                              <parameter>modeshape-mcast</parameter>
                              <parameter><null/></parameter>
                         </value-factory>
                      </parameter>
                   </constructor>
                </bean>

		<xsl:text>
            </xsl:text>
	    </xsl:copy>
    </xsl:template>

	<xsl:template name="identity" match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>


</xsl:stylesheet>
