/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.messaging.util.CompatibleExecutor;
import org.jboss.messaging.util.ExecutorFactory;
import org.jboss.messaging.util.StatefulRunnable;

public final class OrderedExecutorFactory
implements ExecutorFactory {
    private final Executor parent;
    private final Set<ChildExecutor> runningChildren = Collections.synchronizedSet(new HashSet());

    public OrderedExecutorFactory(Executor parent) {
        this.parent = parent;
    }

    public CompatibleExecutor getExecutor(String name) {
        return new ChildExecutor(name);
    }

    private final class ChildExecutor
    implements CompatibleExecutor,
    Runnable {
        private final LinkedList<Runnable> tasks = new LinkedList();
        private boolean shutdown = false;
        private String name = "default-thread";

        public ChildExecutor(String n) {
            this.name = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Runnable command) {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                if (!this.shutdown) {
                    this.tasks.add(command);
                    if (this.tasks.size() == 1 && OrderedExecutorFactory.this.runningChildren.add(this)) {
                        OrderedExecutorFactory.this.parent.execute(this);
                    }
                } else if (command instanceof StatefulRunnable) {
                    ((StatefulRunnable)command).setState(-1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Runnable task;
                LinkedList<Runnable> linkedList = this.tasks;
                synchronized (linkedList) {
                    task = this.tasks.poll();
                    if (task == null) {
                        OrderedExecutorFactory.this.runningChildren.remove(this);
                        this.tasks.notify();
                        return;
                    }
                }
                task.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearAllExceptCurrentTask() {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownNow() {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.clear();
                this.shutdown = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownAfterProcessingCurrentlyQueuedTasks() {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.shutdown = true;
                while (this.tasks.size() > 0) {
                    try {
                        this.tasks.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

