/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra.inflow;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.server.recovery.XARecoveryConfig;
import org.hornetq.ra.HornetQResourceAdapter;
import org.hornetq.ra.Util;
import org.hornetq.ra.inflow.HornetQActivationSpec;
import org.hornetq.ra.inflow.HornetQMessageHandler;
import org.hornetq.utils.SensitiveDataCodec;

public class HornetQActivation {
    private static final Logger log = Logger.getLogger(HornetQActivation.class);
    private static boolean trace = log.isTraceEnabled();
    public static final Method ONMESSAGE;
    private final HornetQResourceAdapter ra;
    private final HornetQActivationSpec spec;
    private final MessageEndpointFactory endpointFactory;
    private final AtomicBoolean deliveryActive = new AtomicBoolean(false);
    private boolean isTopic = false;
    private boolean isDeliveryTransacted;
    private HornetQDestination destination;
    private SimpleString topicTemporaryQueue;
    private final List<HornetQMessageHandler> handlers = new ArrayList<HornetQMessageHandler>();
    private HornetQConnectionFactory factory;
    private AtomicBoolean inFailure = new AtomicBoolean(false);
    private XARecoveryConfig resourceRecovery;

    public HornetQActivation(HornetQResourceAdapter ra, MessageEndpointFactory endpointFactory, HornetQActivationSpec spec) throws ResourceException {
        String pass;
        spec.validate();
        if (trace) {
            log.trace((Object)("constructor(" + ra + ", " + endpointFactory + ", " + spec + ")"));
        }
        if (ra.isUseMaskedPassword() && (pass = spec.getOwnPassword()) != null) {
            SensitiveDataCodec<String> codec = ra.getPasswordCodec();
            try {
                spec.setPassword((String)codec.decode((Object)pass));
            }
            catch (Exception e) {
                throw new ResourceException((Throwable)e);
            }
        }
        this.ra = ra;
        this.endpointFactory = endpointFactory;
        this.spec = spec;
        try {
            this.isDeliveryTransacted = endpointFactory.isDeliveryTransacted(ONMESSAGE);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public HornetQActivationSpec getActivationSpec() {
        if (trace) {
            log.trace((Object)"getActivationSpec()");
        }
        return this.spec;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        if (trace) {
            log.trace((Object)"getMessageEndpointFactory()");
        }
        return this.endpointFactory;
    }

    public boolean isDeliveryTransacted() {
        if (trace) {
            log.trace((Object)"isDeliveryTransacted()");
        }
        return this.isDeliveryTransacted;
    }

    public WorkManager getWorkManager() {
        if (trace) {
            log.trace((Object)"getWorkManager()");
        }
        return this.ra.getWorkManager();
    }

    public boolean isTopic() {
        if (trace) {
            log.trace((Object)"isTopic()");
        }
        return this.isTopic;
    }

    public void start() throws ResourceException {
        if (trace) {
            log.trace((Object)"start()");
        }
        this.deliveryActive.set(true);
        this.ra.getWorkManager().scheduleWork((Work)new SetupActivation());
    }

    public SimpleString getTopicTemporaryQueue() {
        return this.topicTemporaryQueue;
    }

    public void setTopicTemporaryQueue(SimpleString topicTemporaryQueue) {
        this.topicTemporaryQueue = topicTemporaryQueue;
    }

    public void stop() {
        if (trace) {
            log.trace((Object)"stop()");
        }
        this.deliveryActive.set(false);
        this.teardown();
    }

    protected synchronized void setup() throws Exception {
        log.debug((Object)("Setting up " + this.spec));
        this.setupCF();
        this.setupDestination();
        for (int i = 0; i < this.spec.getMaxSession(); ++i) {
            ClientSession session = null;
            try {
                ClientSessionFactory cf = this.factory.getServerLocator().createSessionFactory();
                session = this.setupSession(cf);
                HornetQMessageHandler handler = new HornetQMessageHandler(this, this.ra.getTM(), (ClientSessionInternal)session, cf, i);
                handler.setup();
                session.start();
                this.handlers.add(handler);
                continue;
            }
            catch (Exception e) {
                if (session != null) {
                    session.close();
                }
                throw e;
            }
        }
        log.debug((Object)("Setup complete " + this));
    }

    protected synchronized void teardown() {
        log.debug((Object)("Tearing down " + this.spec));
        if (this.resourceRecovery != null) {
            this.ra.getRecoveryManager().unRegister(this.resourceRecovery);
        }
        for (HornetQMessageHandler handler : this.handlers) {
            handler.interruptConsumer();
        }
        for (HornetQMessageHandler handler : this.handlers) {
            handler.teardown();
        }
        if (this.spec.isHasBeenUpdated()) {
            this.factory.close();
            this.factory = null;
        }
        log.debug((Object)("Tearing down complete " + this));
    }

    protected void setupCF() throws Exception {
        if (this.spec.isHasBeenUpdated()) {
            this.factory = this.ra.createHornetQConnectionFactory(this.spec);
            this.resourceRecovery = this.ra.getRecoveryManager().register(this.factory, this.spec.getUser(), this.spec.getPassword());
        } else {
            this.factory = this.ra.getDefaultHornetQConnectionFactory();
        }
    }

    protected ClientSession setupSession(ClientSessionFactory cf) throws Exception {
        ClientSession result = null;
        try {
            String clientID;
            result = this.ra.createSession(cf, this.spec.getAcknowledgeModeInt(), this.spec.getUser(), this.spec.getPassword(), this.ra.getPreAcknowledge(), this.ra.getDupsOKBatchSize(), this.ra.getTransactionBatchSize(), this.isDeliveryTransacted, this.spec.isUseLocalTx(), this.spec.getTransactionTimeout());
            result.addMetaData("resource-adapter", "inbound");
            result.addMetaData("jms-session", "");
            String string = clientID = this.ra.getClientID() == null ? this.spec.getClientID() : this.ra.getClientID();
            if (clientID != null) {
                result.addMetaData("jms-client-id", clientID);
            }
            log.debug((Object)("Using queue connection " + result));
            return result;
        }
        catch (Throwable t) {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                log.trace((Object)"Ignored error closing connection", (Throwable)e);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeException("Error configuring connection", t);
        }
    }

    public SimpleString getAddress() {
        return this.destination.getSimpleAddress();
    }

    protected void setupDestination() throws Exception {
        String destinationName;
        block14: {
            destinationName = this.spec.getDestination();
            if (this.spec.isUseJNDI()) {
                String destinationTypeString;
                InitialContext ctx = this.spec.getParsedJndiParams() == null ? new InitialContext() : new InitialContext(this.spec.getParsedJndiParams());
                log.debug((Object)("Using context " + ctx.getEnvironment() + " for " + this.spec));
                if (trace) {
                    log.trace((Object)("setupDestination(" + ctx + ")"));
                }
                if ((destinationTypeString = this.spec.getDestinationType()) != null && !destinationTypeString.trim().equals("")) {
                    Class<Topic> destinationType;
                    log.debug((Object)("Destination type defined as " + destinationTypeString));
                    if (Topic.class.getName().equals(destinationTypeString)) {
                        destinationType = Topic.class;
                        this.isTopic = true;
                    } else {
                        destinationType = Queue.class;
                    }
                    log.debug((Object)("Retrieving destination " + destinationName + " of type " + destinationType.getName()));
                    try {
                        this.destination = (HornetQDestination)Util.lookup(ctx, destinationName, destinationType);
                    }
                    catch (Exception e) {
                        if (destinationName == null) {
                            throw e;
                        }
                        if (this.isTopic) {
                            this.destination = (HornetQDestination)HornetQJMSClient.createTopic((String)destinationName.substring(destinationName.lastIndexOf(47) + 1));
                            break block14;
                        }
                        this.destination = (HornetQDestination)HornetQJMSClient.createQueue((String)destinationName.substring(destinationName.lastIndexOf(47) + 1));
                    }
                } else {
                    log.debug((Object)"Destination type not defined");
                    log.debug((Object)("Retrieving destination " + destinationName + " of type " + Destination.class.getName()));
                    this.destination = (HornetQDestination)Util.lookup(ctx, destinationName, Destination.class);
                    if (this.destination instanceof Topic) {
                        this.isTopic = true;
                    }
                }
            } else if (Topic.class.getName().equals(this.spec.getDestinationType())) {
                this.destination = (HornetQDestination)HornetQJMSClient.createTopic((String)this.spec.getDestination());
                this.isTopic = true;
            } else {
                this.destination = (HornetQDestination)HornetQJMSClient.createQueue((String)this.spec.getDestination());
            }
        }
        log.debug((Object)("Got destination " + this.destination + " from " + destinationName));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(HornetQActivation.class.getName()).append('(');
        buffer.append("spec=").append(this.spec.getClass().getName());
        buffer.append(" mepf=").append(this.endpointFactory.getClass().getName());
        buffer.append(" active=").append(this.deliveryActive.get());
        if (this.spec.getDestination() != null) {
            buffer.append(" destination=").append(this.spec.getDestination());
        }
        buffer.append(" transacted=").append(this.isDeliveryTransacted);
        buffer.append(')');
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFailure(Throwable failure) {
        if (failure instanceof HornetQException && ((HornetQException)failure).getCode() == 100) {
            log.info((Object)("awaiting topic/queue creation " + this.getActivationSpec().getDestination()));
        } else {
            log.warn((Object)("Failure in HornetQ activation " + this.spec), failure);
        }
        int setupAttempts = this.spec.getSetupAttempts();
        long setupInterval = this.spec.getSetupInterval();
        if (this.inFailure.getAndSet(true)) {
            return;
        }
        try {
            for (int reconnectCount = 0; this.deliveryActive.get() && (setupAttempts == -1 || reconnectCount < setupAttempts); ++reconnectCount) {
                this.teardown();
                try {
                    Thread.sleep(setupInterval);
                }
                catch (InterruptedException e) {
                    log.debug((Object)("Interrupted trying to reconnect " + this.spec), (Throwable)e);
                    break;
                }
                log.info((Object)("Attempting to reconnect " + this.spec));
                try {
                    this.setup();
                    log.info((Object)"Reconnected with HornetQ");
                    break;
                }
                catch (Throwable t) {
                    if (failure instanceof HornetQException && ((HornetQException)failure).getCode() == 100) {
                        log.info((Object)("awaiting topic/queue creation " + this.getActivationSpec().getDestination()));
                        continue;
                    }
                    log.error((Object)("Unable to reconnect " + this.spec), t);
                    continue;
                }
            }
        }
        finally {
            this.inFailure.set(false);
        }
    }

    public HornetQConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    static {
        try {
            ONMESSAGE = MessageListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class SetupActivation
    implements Work {
        private SetupActivation() {
        }

        public void run() {
            try {
                HornetQActivation.this.setup();
            }
            catch (Throwable t) {
                HornetQActivation.this.handleFailure(t);
            }
        }

        public void release() {
        }
    }
}

