/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.zip.ZipBytesWrapper;
import org.jboss.virtual.plugins.context.zip.ZipEntryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZipStreamWrapper
extends ZipBytesWrapper {
    private static final Logger log = Logger.getLogger(ZipStreamWrapper.class);
    private static boolean optimizeForMemory = AccessController.doPrivileged(new CheckOptimizeForMemory());
    private Map<String, InMemoryFile> inMemoryFiles = new LinkedHashMap<String, InMemoryFile>();
    private int size;

    ZipStreamWrapper(InputStream zipStream, String name, long lastModified) throws IOException {
        super(zipStream, name, lastModified);
        ZipInputStream zis = new ZipInputStream(super.getRootAsStream());
        ZipEntry ent = zis.getNextEntry();
        while (ent != null) {
            byte[] fileBytes;
            if (!ent.isDirectory()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                VFSUtils.copyStream(zis, baos);
                fileBytes = baos.toByteArray();
                ent.setSize(fileBytes.length);
            } else {
                fileBytes = new byte[]{};
            }
            this.inMemoryFiles.put(ent.getName(), new InMemoryFile(ent, fileBytes));
            ent = zis.getNextEntry();
        }
        if (optimizeForMemory) {
            this.initZipSize();
            super.close();
        }
    }

    @Override
    InputStream openStream(ZipEntryInfo info) throws IOException {
        if (info.isDirectory()) {
            return this.recomposeZipAsInputStream(info.getName());
        }
        InMemoryFile memFile = this.inMemoryFiles.get(info.getName());
        if (memFile == null) {
            throw new FileNotFoundException("Failed to find nested jar entry: " + info.getName() + " in zip stream: " + this.toString());
        }
        return new ByteArrayInputStream(memFile.fileBytes);
    }

    @Override
    Enumeration<? extends ZipEntry> entries() throws IOException {
        return new ZipStreamEnumeration();
    }

    @Override
    InputStream getRootAsStream() throws FileNotFoundException {
        if (optimizeForMemory) {
            return this.recomposeZipAsInputStream();
        }
        return super.getRootAsStream();
    }

    @Override
    long getSize() {
        if (optimizeForMemory) {
            return this.size;
        }
        return super.getSize();
    }

    @Override
    void close() {
        this.inMemoryFiles = null;
        super.close();
    }

    private void initZipSize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.recomposeZip(baos);
        this.size = baos.size();
    }

    private void recomposeZip(ByteArrayOutputStream baos) throws IOException {
        this.recomposeZip(baos, "");
    }

    @Override
    protected void recomposeZip(OutputStream baos, String path) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(baos);
        zout.setMethod(0);
        for (InMemoryFile memFile : this.inMemoryFiles.values()) {
            String newName;
            ZipEntry oldEntry = memFile.entry;
            if (!oldEntry.getName().startsWith(path) || (newName = oldEntry.getName().substring(path.length())).length() == 0) continue;
            ZipEntry newEntry = new ZipEntry(newName);
            newEntry.setComment(oldEntry.getComment());
            newEntry.setTime(oldEntry.getTime());
            newEntry.setSize(oldEntry.getSize());
            newEntry.setCrc(oldEntry.getCrc());
            zout.putNextEntry(newEntry);
            if (oldEntry.isDirectory()) continue;
            zout.write(memFile.fileBytes);
        }
        zout.close();
    }

    private InputStream recomposeZipAsInputStream() throws FileNotFoundException {
        return this.recomposeZipAsInputStream("");
    }

    static {
        if (optimizeForMemory) {
            log.info((Object)"VFS optimizeForMemory is enabled.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckOptimizeForMemory
    implements PrivilegedAction<Boolean> {
        private CheckOptimizeForMemory() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.optimizeForMemory", "false");
            return Boolean.valueOf(forceString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ZipStreamEnumeration
    implements Enumeration<ZipEntry> {
        private Iterator<InMemoryFile> it;

        ZipStreamEnumeration() {
            this.it = ZipStreamWrapper.this.inMemoryFiles.values().iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        @Override
        public ZipEntry nextElement() {
            return this.it.next().entry;
        }
    }

    static class InMemoryFile {
        ZipEntry entry;
        byte[] fileBytes;

        public InMemoryFile(ZipEntry entry, byte[] fileBytes) {
            this.entry = entry;
            this.fileBytes = fileBytes;
        }
    }
}

