/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.cache;

import java.util.Collections;
import java.util.Map;
import org.jboss.virtual.plugins.cache.IterableVFSCache;
import org.jboss.virtual.spi.VFSContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapVFSCache
extends IterableVFSCache {
    private Map<String, VFSContext> cache;

    @Override
    public Iterable<VFSContext> getCachedContexts() {
        if (this.cache == null) {
            return Collections.emptySet();
        }
        return this.cache.values();
    }

    @Override
    public int size() {
        return this.cache != null ? this.cache.size() : -1;
    }

    @Override
    protected void check() {
        if (this.cache == null) {
            throw new IllegalArgumentException("Cache needs to be started first.");
        }
    }

    @Override
    protected Iterable<String> getKeys() {
        return this.cache.keySet();
    }

    @Override
    protected VFSContext getContext(String path) {
        return this.cache.get(path);
    }

    @Override
    protected void putContext(String path, VFSContext context) {
        this.cache.put(path, context);
    }

    @Override
    protected void removeContext(String path, VFSContext context) {
        this.cache.remove(path);
    }

    protected abstract Map<String, VFSContext> createMap();

    @Override
    public void start() throws Exception {
        if (this.cache == null) {
            this.cache = this.createMap();
        }
    }

    @Override
    public void stop() {
        this.flush();
        this.cache = null;
    }

    @Override
    public void flush() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }
}

