/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.distdiff;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.jboss.soa.distdiff.ZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirCrawler {
    public void crawl(File distDir, Map<String, List<String>> duplicateJarsResult, Map<String, List<String>> duplicateZipEntriesResult) {
        this.crawlDir(distDir, duplicateJarsResult, duplicateZipEntriesResult);
    }

    private void crawlDir(File dir, Map<String, List<String>> duplicateJarsResult, Map<String, List<String>> duplicateZipEntriesResult) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not directory");
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.crawlDir(file, duplicateJarsResult, duplicateZipEntriesResult);
                continue;
            }
            if (!ZipUtil.isZipFile(file.getName())) continue;
            this.recordFile(file.getName(), file.getPath(), duplicateJarsResult);
            this.crawlZip(file, file.getPath(), duplicateJarsResult, duplicateZipEntriesResult);
        }
    }

    private void recordFile(String name, String location, Map<String, List<String>> result) {
        if (!result.containsKey(name)) {
            result.put(name, new ArrayList());
        }
        result.get(name).add(location);
    }

    private void crawlZip(File file, String location, Map<String, List<String>> duplicateJarsResult, Map<String, List<String>> duplicateZipEntriesResult) {
        ZipFile zipFile = ZipUtil.openFile(file);
        ArrayList<String> filesInZip = new ArrayList<String>();
        Enumeration entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            if (filesInZip.contains(entry.getName())) {
                this.recordFile(location, entry.getName(), duplicateZipEntriesResult);
            }
            filesInZip.add(entry.getName());
            if (!ZipUtil.isZipFile(entry)) continue;
            this.recordFile(entry.getName(), location, duplicateJarsResult);
            this.crawlZip(ZipUtil.getExtractedZipFile(zipFile, entry), location + "!" + entry.getName(), duplicateJarsResult, duplicateZipEntriesResult);
        }
        try {
            zipFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

