/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.jboss.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.hornetq.core.logging.Logger;
import org.hornetq.integration.jboss.security.JBossASSecurityManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    private static final Logger log = Logger.getLogger(JBossASSecurityManager.class);

    SecurityActions() {
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject, String securityDomainName) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject, securityDomainName);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject, securityDomainName);
        }
    }

    static void popSubjectContext() {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.pop();
        } else {
            PrincipalInfoAction.PRIVILEGED.pop();
        }
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            @Override
            public void push(final Principal principal, final Object credential, final Subject subject, final String securityDomain) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            log.info((Object)"========================================================");
                            log.info((Object)("Setting subject = " + subject));
                            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                            if (sc == null) {
                                try {
                                    sc = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)credential, (Subject)subject, (String)securityDomain);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            } else {
                                sc.getUtil().createSubjectInfo(principal, credential, subject);
                            }
                            SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                            log.info((Object)"========================================================");
                        }
                        catch (Throwable t) {
                            log.warn((Object)"An error happened while setting the context", t);
                        }
                        return null;
                    }
                });
            }

            @Override
            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        SecurityContextAssociation.clearSecurityContext();
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            @Override
            public void push(Principal principal, Object credential, Subject subject, String securityDomain) {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    try {
                        sc = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)credential, (Subject)subject, (String)securityDomain);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    sc.getUtil().createSubjectInfo(principal, credential, subject);
                }
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
            }

            @Override
            public void pop() {
                SecurityContextAssociation.clearSecurityContext();
            }
        };

        public void push(Principal var1, Object var2, Subject var3, String var4);

        public void pop();
    }
}

