/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.utils;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.utils.Process;
import com.arjuna.common.util.propertyservice.PropertyManager;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Utility {
    private static volatile int myAddr = 0;
    private static Uid processUid = null;
    private static volatile Process processHandle = null;
    private static final String hexStart = "0x";
    private static final String defaultProcessId = "com.arjuna.ats.internal.arjuna.utils.SocketProcessId";
    public static final int BACKLOG = 50;
    public static final int MAX_PORT = 65535;

    public static String intToHexString(int number) throws NumberFormatException {
        return Integer.toString(number, 16);
    }

    public static int hexStringToInt(String s) throws NumberFormatException {
        boolean isNeg;
        String toUse = s;
        if (s.startsWith(hexStart)) {
            toUse = s.substring(hexStart.length());
        }
        String lastString = toUse.substring(toUse.length() - 1);
        if (toUse.substring(0, 1).equals("-")) {
            toUse = "-0" + toUse.substring(1, toUse.length() - 1);
            isNeg = true;
        } else {
            toUse = "0" + toUse.substring(0, toUse.length() - 1);
            isNeg = false;
        }
        Integer i = Integer.valueOf(toUse, 16);
        int val = i;
        val <<= 4;
        val = isNeg ? (val -= Integer.valueOf(lastString, 16).intValue()) : (val += Integer.valueOf(lastString, 16).intValue());
        return val;
    }

    public static String longToHexString(long number) throws NumberFormatException {
        return Long.toString(number, 16);
    }

    public static long hexStringToLong(String s) throws NumberFormatException {
        boolean isNeg;
        String toUse = s;
        if (s.startsWith(hexStart)) {
            toUse = s.substring(hexStart.length());
        }
        String lastString = toUse.substring(toUse.length() - 1);
        if (toUse.substring(0, 1).equals("-")) {
            toUse = "-0" + toUse.substring(1, toUse.length() - 1);
            isNeg = true;
        } else {
            toUse = "0" + toUse.substring(0, toUse.length() - 1);
            isNeg = false;
        }
        Long i = Long.valueOf(toUse, 16);
        long val = i;
        val <<= 4;
        val = isNeg ? (val -= Long.valueOf(lastString, 16).longValue()) : (val += Long.valueOf(lastString, 16).longValue());
        return val;
    }

    public static int hostInetAddr() throws UnknownHostException {
        if (myAddr == 0) {
            Utility.calculateHostInetAddr();
        }
        return myAddr;
    }

    private static synchronized void calculateHostInetAddr() throws UnknownHostException {
        if (myAddr == 0) {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] b = addr.getAddress();
            for (int i = 0; i < b.length; ++i) {
                int l = 0x7F & b[i];
                myAddr = myAddr << 8 | (l += 0x80 & b[i]);
            }
        }
    }

    public static InetAddress hostNameToInetAddress(String host, String messageKey) throws UnknownHostException {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled() && messageKey != null) {
                tsLogger.arjLoggerI18N.warn(messageKey, (Throwable)ex);
            }
            throw ex;
        }
    }

    public static Integer lookupBoundedIntegerProperty(PropertyManager pm, String intProperty, Integer defValue, String warnMsgKey, int minValue, int maxValue) {
        block5: {
            String intStr = pm.getProperty(intProperty);
            if (intStr == null || intStr.length() == 0) {
                return defValue;
            }
            try {
                int i = Integer.parseInt(intStr);
                if (i < minValue || i > maxValue) {
                    if (warnMsgKey != null && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn(warnMsgKey, new Object[]{intStr});
                    }
                    break block5;
                }
                return i;
            }
            catch (Exception ex) {
                if (warnMsgKey == null || !tsLogger.arjLoggerI18N.isWarnEnabled()) break block5;
                tsLogger.arjLoggerI18N.warn(warnMsgKey, (Throwable)ex);
            }
        }
        return defValue;
    }

    public static final int getpid() {
        Process handle = Utility.getProcess();
        return handle == null ? -1 : handle.getpid();
    }

    public static Uid getProcessUid() {
        if (processUid == null) {
            Utility.initProcessUid();
        }
        return processUid;
    }

    private static synchronized void initProcessUid() {
        if (processUid == null) {
            processUid = new Uid();
        }
    }

    public static final boolean isWindows() {
        String os = arjPropertyManager.propertyManager.getProperty("os.name");
        return "WIN32".equals(os) || os.indexOf("Windows") != -1;
    }

    public static final void setProcess(Process p) {
        processHandle = p;
    }

    private static synchronized void initDefaultProcess() {
        if (processHandle == null) {
            try {
                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(arjPropertyManager.getPropertyManager().getProperty("com.arjuna.ats.internal.arjuna.utils.processImplementation", defaultProcessId));
                processHandle = (Process)c.newInstance();
            }
            catch (Exception e) {
                tsLogger.arjLoggerI18N.warn("Utility_1", (Throwable)e);
            }
        }
    }

    private static final Process getProcess() {
        if (processHandle == null) {
            Utility.initDefaultProcess();
        }
        return processHandle;
    }
}

