require 'minitest_helper'
require 'three_scale/analytics/user_classifier'

class ThreeScale::Analytics::AccountClassifierTest < MiniTest::Unit::TestCase


  def classifier(user_attributes = {})
    provider = FactoryGirl.build_stubbed(:provider_account)
    provider.stubs(:users).returns([
                                       FactoryGirl.build_stubbed(:admin, username: '3scaleadmin', email: 'admin@3scale.net'),
                                       FactoryGirl.build_stubbed(:admin, user_attributes)
                                   ])

    ThreeScale::Analytics::AccountClassifier.new(provider)
  end

  def test_is_3scale?
    refute classifier(email: 'user@gmail.com').is_3scale?
    assert classifier(email: 'user@3scale.net').is_3scale?
    refute classifier.is_3scale?
  end

  def test_account_type
    assert_equal 'Customer', classifier(email: 'user@gmail.com', username: 'user').account_type

    assert_equal 'Internal', classifier(email: 'user@gmail.com', username: '3scaleadmin').account_type
    assert_equal 'Internal', classifier(email: 'user@3scale.net', username: 'user').account_type
    assert_equal 'Internal', classifier(email: 'user@3scale.net', username: '3scaleadmin').account_type

    assert_equal 'Customer', classifier(email: nil, username: nil).account_type
    assert_equal 'Customer', classifier(email: 'user@example.com', username: nil).account_type
    assert_equal 'Customer', classifier(email: nil, username: 'user').account_type

    assert_equal 'Internal', ThreeScale::Analytics::AccountClassifier.new(nil).account_type
  end
end
