module TestHelpers
  module FakeWeb
    module Transactions

       def fake_backend_transactions(service,transactions, provider_key = @provider_key)
        body = %(
<transactions>
  #{transactions.map do |transaction|
      %{<transaction application_id="#{transaction[:application_id]}"
                             timestamp="#{transaction[:timestamp]}">
                  #{transaction[:metrics].map do |metric|
                    %{<value metric_id="#{metric[:id]}">#{metric[:value]}</value>}
                  end.join}
      </transaction>}
    end.join}
</transactions>)

        ::FakeWeb.register_uri :get, fake_backend_url("/transactions/latest.xml?provider_key=#{provider_key}&service_id=#{service.id}"),
                             :status => [200, 'OK'], :content_type => CONTENT_TYPE,
                             :body => body
       end

      def fake_transaction_post
        ::FakeWeb.register_uri :post, fake_backend_url("/transactions.xml"), :status => [202], :content_type => CONTENT_TYPE, :body => ""
      end
    end
  end
end


