require 'test_helper'

class Buyers::ApplicationsTest < ActionDispatch::IntegrationTest
  def setup
    @provider = Factory(:provider_account)
    @plan = Factory :application_plan, :issuer => @provider.default_service

    # enabled
    feat = Factory :feature, :featurable => @provider.default_service, :name => "ticked"
    @plan.features_plans.create!(:feature => feat)

    # disabled
    Factory :feature, :featurable => @provider.default_service, :name => "crossed"

    @application = Factory(:cinstance, :plan => @plan)

    host! @provider.admin_domain
    provider_login_with @provider.admins.first.username, "supersecret"

    #TODO: dry with @ignore-backend tag on cucumber
    stub_backend_get_keys
    stub_backend_referrer_filters
    stub_backend_utilization
  end

  test 'plan widget features are drawn correctly' do
    get admin_buyers_application_path(:id => @application.id)

    assert_response :success

    page = Nokogiri::HTML::Document.parse(response.body)
    assert page.xpath("//tr[@class='feature enabled']").text  =~ /ticked/
    assert page.xpath("//tr[@class='feature disabled']").text =~ /crossed/
  end

  test 'plan of the app does not show in the plans select' do
    @application.customize_plan! #maybe not needed, but we are checking even that custom does not appear

    get admin_buyers_application_path(:id => @application.id)
    assert_response :success

    page = Nokogiri::HTML::Document.parse(response.body)
    assert page.xpath("//select[@id='cinstance_plan_id']/option").map(&:text).exclude?(@application.plan.name)
  end

end
