Factory.define(:plan) do |plan|
  plan.sequence(:name) { |n| "plan#{n}" }
  plan.sequence(:system_name) {|n| "plan#{n}" }

  plan.after_stub do |plan|
    plan.stubs(:features).returns([])
    plan.features.stubs(:find).with(:all, Mocha::ParameterMatchers::AnyParameters.new).returns([])
    plan.features.stubs(:visible).returns([])
  end
end

Factory.define(:account_plan, :parent => :plan, :class => AccountPlan) do |plan|
  plan.association(:issuer, :factory => :provider_account)
end

Factory.define(:service_plan, :parent => :plan, :class => ServicePlan) do |plan|
  plan.association(:issuer, :factory => :service)
end

Factory.define(:application_plan, :parent => :plan, :class => ApplicationPlan) do |plan|
  plan.association(:issuer, :factory => :service)
end

Factory.define(:published_plan, :parent => :application_plan) do |plan|
  plan.after_create do |plan|
    plan.publish!
  end

  plan.after_stub do |plan|
    plan.stubs(:state).returns('published')
  end
end
