#!/usr/bin/env groovy

def system = load 'system.groovy'

return { ->
    currentBuild.displayName = "#${env.BUILD_NUMBER} (${system.build_name})"

    system.begin()

    catchError {
        stage 'Build'


      parallel 1: {
          system.make_build('1')
      }, 2: {
          system.make_build('2')
      }, 3: {
          system.make_build('3')
      }, 4: {
          system.make_build('4')
      }, 5: {
          system.make_build('5')
      }, 6: {
          system.make_build('6')
      }, 7: {
          system.make_build('licenses', system.node_name, '1')
      }, failFast: false
    }

    currentBuild.result = currentBuild.result ?: 'SUCCESS'

    system.report()
}
