(function() {
  var ThreeScaleHttp, ThreeScaleResource, ThreeScaleSwaggerUi, port_part, swagger_add_api_declaration, swagger_execute, swagger_ui_load;

  if (!window.location.origin) {
    port_part = window.location.port ? ":" + window.location.port : "";
    window.location.origin = window.location.protocol + "//" + window.location.hostname + port_part;
  }

  swagger_ui_load = SwaggerUi.prototype.load;

  ThreeScaleSwaggerUi = (function() {
    function ThreeScaleSwaggerUi(swagger_ui_load) {
      this.swagger_ui_load = swagger_ui_load;
    }

    ThreeScaleSwaggerUi.prototype.load = function(account_type) {
      ThreeScaleAutoComplete.init(account_type || "buyer");
      return swagger_ui_load.apply(this.swagger_ui_load);
    };

    return ThreeScaleSwaggerUi;

  })();

  SwaggerUi.prototype.load = function(account_type) {
    return new ThreeScaleSwaggerUi(this).load(account_type);
  };

  swagger_add_api_declaration = SwaggerResource.prototype.addApiDeclaration;

  ThreeScaleResource = (function() {
    function ThreeScaleResource(swagger_api_declaration) {
      this.swagger_api_declaration = swagger_api_declaration;
    }

    ThreeScaleResource.prototype.addApiDeclaration = function(response) {
      this.swagger_api_declaration['__notifications'] = response.__notifications;
      return swagger_add_api_declaration.apply(this.swagger_api_declaration, [response]);
    };

    return ThreeScaleResource;

  })();

  SwaggerResource.prototype.addApiDeclaration = function(response) {
    return new ThreeScaleResource(this).addApiDeclaration(response);
  };

  swagger_execute = SwaggerHttp.prototype.execute;

  ThreeScaleHttp = (function() {
    var NO_CACHE_HEADERS;

    NO_CACHE_HEADERS = {
      "Cache-Control": "no-cache"
    };

    function ThreeScaleHttp(swagger_http) {
      this.swagger_http = swagger_http;
    }

    ThreeScaleHttp.prototype.execute = function(obj) {
      var patt, result;
      if (this.originHttps()) {
        obj.url = this.forceHttpsProtocol(obj.url);
      }
      this.createLinkElement(obj.url);
      obj.useJQuery = true;
      obj.originalUrl = obj.url;
      if (!this.sameOrigin()) {
        if (_.isUndefined(obj.method)) {
          obj.method = obj.type || "POST";
        }
        patt = new RegExp(":\/\/.*\.execute-api\..*amazonaws\.com");
        if (patt.test(obj.originalUrl) || ThreeScaleHttp.beta) {
          obj.url = 'https://apidocsresty.3sca.net/api_docs/proxy';
        } else {
          obj.url = this.locationOrigin() + '/api_docs/proxy';
        }
        obj.url += '?_=' + (new Date).getTime();
        $.extend(obj.headers, NO_CACHE_HEADERS, this.apiDocsHeaders(obj));
      }
      result = swagger_execute.apply(this.swagger_http, [obj]);
      if (!this.sameOrigin()) {
        result.url = obj.url = obj.originalUrl;
      }
      return result;
    };

    ThreeScaleHttp.prototype.apiDocsHeaders = function(obj) {
      return {
        'X-Apidocs-Method': obj.method,
        'X-Apidocs-Path': this.apiDocsPath(),
        'X-Apidocs-Url': this.desiredOrigin(),
        'X-Apidocs-Query': this.linkElement.search.replace("?", "")
      };
    };

    ThreeScaleHttp.prototype.apiDocsPath = function() {
      if (this.linkElement.pathname.indexOf("/") !== 0) {
        return "/" + this.linkElement.pathname;
      } else {
        return this.linkElement.pathname;
      }
    };

    ThreeScaleHttp.prototype.originHttps = function() {
      return window.top.location.protocol === 'https:';
    };

    ThreeScaleHttp.prototype.forceHttpsProtocol = function(url) {
      return url.replace(/^http:\/\//i, 'https://');
    };

    ThreeScaleHttp.prototype.locationOrigin = function() {
      return window.top.location.origin;
    };

    ThreeScaleHttp.prototype.createLinkElement = function(url) {
      this.linkElement = window.document.createElement("a");
      this.linkElement.href = url;
      return this.linkElement;
    };

    ThreeScaleHttp.prototype.sameOrigin = function() {
      return true;
    };

    ThreeScaleHttp.prototype.desiredOrigin = function() {
      var portPart;
      if (this.linkElement.port === "443" && this.linkElement.protocol === "https:") {
        portPart = "";
      } else {
        portPart = this.linkElement.port === "" ? "" : ":" + this.linkElement.port;
      }
      return this.linkElement.protocol + "//" + this.linkElement.hostname + portPart;
    };

    return ThreeScaleHttp;

  })();

  window.ThreeScaleHttp = ThreeScaleHttp;

  SwaggerHttp.prototype.execute = function(obj) {
    return new ThreeScaleHttp(this).execute(obj);
  };

}).call(this);
