module Finance

  # Including this module makes a model billable for fixed fee.
  # Attribute +plan+ with method #cost_for_period is required to exist
  # on the class, strictly speaking.
  #
  module FixedFee

    protected

    def bill_fixed_fee_for(period, invoice)
      fixed_cost = plan.cost_for_period(period)

      if fixed_cost.nonzero?
        invoice.bill do |li|
          li = li.becomes!(LineItem::PlanCost)
          li.contract = self
          li.plan_id = self.plan_id
          li.cost = fixed_cost
          li.quantity = 1
          li.name = "Fixed fee ('#{plan.name}')"
          li.description = period.to_time_range.to_s
        end
      end
    end
  end
end

