class MarketoAccountActivateWorker < MarketoWorker

  def self.enqueue(user)
    perform_async(user.as_json)
  end

  def perform(user_attributes)
    return unless self.class.enabled?

    attributes = build_attributes(user_attributes)
    @marketo_client.update_lead(attributes)
  end

  def build_attributes(user_attributes)
    user = user_attributes['user']
    account_activated = (user['state'] ==  'active')

    {
      email: user['email'],
      MT_account_activated__c: account_activated
    }
  end
end
