class PaymentGateway < Struct.new(:type, :fields)
  # So far hardcoded list of gateways, later maybe this will be loaded from a config file or db.
  GATEWAYS = [
    PaymentGateway.new(:authorize_net, login: 'LoginID', password: 'Transaction Key'),
    PaymentGateway.new(:braintree_blue, public_key: 'Public Key', merchant_id: 'Merchant ID', private_key: 'Private Key'),
    PaymentGateway.new(:ogone, login: 'PSPID', password: 'Password', user: 'User Id', signature: "SHA-IN Pass phrase", signature_out: "SHA-OUT Pass phrase"),
    PaymentGateway.new(:stripe, login: "Secret Key", publishable_key: "Publishable Key"),
    PaymentGateway.new(:adyen12, login: 'Login', password: 'Secret Password', public_key: "Client Encryption Public Key",
     merchantAccount: 'Merchant ID', encryption_js_url: "Library location")
  ]

  # deprecated gateways
  #PaymentGateway.new(:merchant_e_solutions, :login => 'Merchant Account Profile ID', :password => 'Merchant Key', :payhere_profile_id => 'Payhere Profile ID'),
  # PaymentGateway.new(:payment_express,
  #                       :login => 'PostUsername', :password => 'PostPassword',
  #                       :hosted_login => 'PxPayUserId', :hosted_password => 'PxPayKey'),

  def self.bogus_enabled?
    Rails.env.development? or Rails.env.test?
  end

  delegate :display_name, :homepage_url, :to => :implementation

  def implementation
    self.class.implementation(type)
  end

  # Return ActiveMerchant's implementation (subclass of ActiveMerchant::Billing::Gateway)
  # of gateway of given type.
  #
  # Example:
  #
  # PaymentGateway.implementation(:authorize_net) # ActiveMerchant::Billing::AuthorizeNetGateway
  #
  # Note:
  #
  # Since ActiveMerchant 1.9, Braintree can return 2 different kinds of implementation:
  #     BraintreeOrangeGateway if :login is given or BraintreeeBlueGateway otherwise
  #
  #
  def self.implementation(type)
    ActiveMerchant::Billing::Base.gateway(type)
  end

  def self.all(provider_gateway = nil)
    gateways = GATEWAYS.dup
    # this is supporting the deprecated gateway payment_express for providers that already have it (Pingar)
    if provider_gateway.to_s == "payment_express"
      gateways << PaymentGateway.new(:payment_express,
                                     :login => 'PostUsername', :password => 'PostPassword',
                                     :hosted_login => 'PxPayUserId', :hosted_password => 'PxPayKey')
    end

    if bogus_enabled?
      gateways << PaymentGateway.new(:bogus, {})
    end

    gateways
  end

  def self.available(existing_gateway)
    all(existing_gateway).map(&:type)
  end

  def self.find(type)
    all(type).find{|g| g.type.to_s == type.to_s}
  end

end
