module AnalyticsJsHelper
  def analytics
    enabled = segment.enabled && @_analytics_enabled

    capture { yield } if enabled && block_given?
  end

  def segment
    System::Application.config.three_scale.segment
  end

  def session_signup_success_user_id
    signup = session[:signup_success]
    signup && signup[:user_id]
  end

  PLAN_NAMES_WITHOUT_INTERCOM_BUTTON =  Regexp.union( [/developer/i, /heroku/i,
                                                       /2013 base/i, /personal/i,
                                                       /master plan/i, /test/i,
                                                       /plus/i, /power/i, /appdirect/i,
                                                       /30 day trial/i, /45 day trial/i])

  def analytics_intercom_widget?
    return unless current_user
    account = current_user.account
    !account.bought_plan.name.to_s.match(PLAN_NAMES_WITHOUT_INTERCOM_BUTTON)
  end

  include ThreeScale::Analytics::SessionStoredAnalytics::Helper
end
