class Provider::Admin::LiquidDocsController < Provider::Admin::BaseController
  activate_menu! :topmenu => :help
  layout 'provider'

  def show
    generator = Liquid::Docs::Generator.new
    generator << File.new(Rails.root.join('doc','liquid',"_intro.md")).read

    %w( drops tags filters ).map do |type|
      generator << "# #{type.capitalize}\n"
      generator << File.new(Rails.root.join('doc','liquid',"#{type}.md")).read.gsub(/^#/, '##')
    end

    generator << File.new(Rails.root.join('doc','liquid',"_links.md")).read
    @docs = generator.to_html.to_s.html_safe
  end

end
