require File.expand_path(File.dirname(__FILE__) + '/../test_helper')

class LineItemTest < ActiveSupport::TestCase
  should belong_to :invoice

  setup do
    master_account.try(:delete)
    master_account
  end

  test 'returns cost in currency of the billing strategy' do
    provider_account_one = Factory(:provider_with_billing)
    provider_account_two = Factory(:provider_with_billing)

    provider_account_one.billing_strategy.update_attribute(:currency, 'EUR')
    provider_account_two.billing_strategy.update_attribute(:currency, 'USD')

    invoice_one = Factory(:invoice, :provider_account => provider_account_one)
    invoice_two = Factory(:invoice, :provider_account => provider_account_two)

    line_item_one = invoice_one.line_items.new(:cost => 10)
    line_item_two = invoice_two.line_items.new(:cost => 42)

    assert_equal 'EUR', line_item_one.cost.currency
    assert_equal 'USD', line_item_two.cost.currency
  end

  test 'sum_by_invoice_state' do
    assert_equal 0, LineItem.sum_by_invoice_state(:finalized)
    assert_equal 0, LineItem.sum_by_invoice_state('finalized')
  end

  context 'LineItem' do
    setup do
      @line_item = Factory(:line_item_plan_cost)
    end


    should 'respond to #to_xml' do
      # TODO: add content assertioins
      assert_not_nil @line_item.to_xml
    end

  end

end
