require 'test_helper'

class BackendMetricJobTest < ActiveSupport::TestCase

  test 'lock_workers should return service and metric_name' do
    assert_equal 'service:1/metric:42', BackendMetricJob.lock_workers(1, 42, 'lol')
  end

  test 'update metric' do
    metric = Factory.create(:metric, system_name: 'some_system_name')
    service = metric.service

    ThreeScale::Core::Metric.expects(:save).with(id: metric.id, service_id: service.backend_id,
                                                 name: 'some_system_name', parent_id: nil)

    BackendMetricJob.perform(service.backend_id, metric.id, metric.system_name)
  end

  test 'destroy metric' do
    ThreeScale::Core::Metric.expects(:delete).with('foo', 'bar')
    BackendMetricJob.perform('foo', 'bar', 'lol')
  end
end
