require 'test_helper'

class Master::EventsImporterTest < ActionDispatch::IntegrationTest
  def setup
    @provider = FactoryGirl.create(:simple_provider)
    ::Events.stubs(shared_secret: 'shared-secret!')
  end

  def test_allow_import_event_if_on_admin_portal_wildcard
    host! @provider.self_domain

    ThreeScale.config.stubs(tenant_mode: 'multitenant')
    post master_events_import_url, secret: 'shared-secret!'
    assert_response :forbidden

    ThreeScale.config.stubs(tenant_mode: 'provider')
    post master_events_import_url, secret: 'shared-secret!'
    assert_response :success
  end
end