require 'test_helper'

class Api::PlanCopiesControllerTest < ActionController::TestCase

  def setup
    @provider = FactoryGirl.create(:provider_account)
    @plan     = @provider.provided_plans.first
    Logic::RollingUpdates.stubs(skipped?: true) # Rolling Update: FlightStats oldie charts

    host! @provider.admin_domain

    login_provider @provider
  end

  test 'should render a create template' do
    post :create, format: :js, plan_id: @plan.id

    assert_template 'api/plan_copies/create'
  end

  test 'should render a new template' do
    ServicePlan.any_instance.stubs(:persisted?).returns(false)

    post :create, format: :js, plan_id: @plan.id

    assert_template 'api/plan_copies/new'
  end

  test 'should make a copy of the account plan' do
    assert_difference(@provider.provided_plans.method(:count), + 1) do

      post :create, format: :js, plan_id: @plan.id
    end
  end

  test 'should make a copy with a default contracts_count value' do
    Plan.update_counters @plan.id, contracts_count: 25

    @plan.reload

    assert_equal 25, @plan.contracts_count

    post :create, format: :js, plan_id: @plan.id

    assert_equal 0, @provider.provided_plans.last.contracts_count
  end
end
