Factory.define(:authentication_provider) do |f|
  f.sequence(:name) { |n| "name-#{n}" }
  f.sequence(:system_name) { |n| "system_name_#{n}" }
  f.association :account, factory: :simple_provider
  f.client_id 'A12345'
  f.client_secret 'Z9876'
  f.branding_state 'custom_branded'
  # f.token_url "http://example.com/oauth/token"
  # f.user_info_url "http://example.com/user_info"
  f.site 'http://example.com'
  f.kind 'github'
end

Factory.define(:github_authentication_provider,
               parent: :authentication_provider,
               class: AuthenticationProvider::GitHub) do |f|
  f.branding_state 'threescale_branded'
end
