module ThreeScale

  class LocalhostValidator < ActiveModel::EachValidator

    LOCALHOST = 'localhost'.freeze

    def validate_each(record, attribute, value)
      uri = Addressable::URI.parse(value)

      return unless uri
      localhost = uri.host

      if localhost == LOCALHOST
        record.errors.add(attribute, :localhost)
      end

    end
  end
end
