namespace :localhost do
  desc 'makes changes to a dumped db to make it ready to run it in local rails server'
  task :site => :environment do
    if Rails.env.development?
      m = Account.master
      m.domain = "admin.3scale.net"
      m.site_access_code = nil
      m.save!
      puts "~ Admin domain is 'admin.3scale.net'"

      p = Account.providers.first
      p.domain = "demo.3scale.net"
      p.site_access_code = nil
      p.save!
      puts "~ Public domain is 'demo.3scale.net'"

      pu = p.admins.first
      pu.username = "prov"
      pu.password = '123456'
      pu.password_confirmation = '123456'
      pu.save!
      puts "~ Provider admin is 'prov' with password '123456'"

      bu = p.buyers.first.admins.first
      bu.username = "buyer"
      bu.password = '123456'
      bu.password_confirmation = '123456'
      bu.save!
      puts "~ Buyer admin is 'buyer' with password '123456'"
    else
      puts 'You can run this task in development environment only.'
    end
  end
end
