module Finance
  module SetupFee

    protected

    def bill_setup_fee_for(period, invoice)
      if setup_fee && setup_fee.nonzero?
        invoice.bill do |li|
          li = li.becomes!(LineItem::PlanCost)
          li.contract = self
          li.plan_id = self.plan_id
          li.cost = setup_fee
          li.name = "Setup fee ('#{plan.name}')"
        end

        self.setup_fee = nil
      end
    end
  end
end
