# Simple wrapper for the API2ls API
# How to use:
# ApiMonitor.new(:app_id, :api_id).response_times

class ApiMonitor

  class_attribute :base_uri, :resources
  self.base_uri  = "http://www.api2ls.com"
  self.resources = %w(uptime response_times events)

  def initialize app_id, api_id
    @app_id = app_id
    @api_id = api_id
  end

  resources.each do | meth |
    define_method(meth) { get(meth) }
  end

  def get resource
    raise ArgumentError.new "Resource: #{resource} is not available" unless self.class.resources.include? resource

    url = "#{self.class.base_uri}/api/#{resource}/#{@api_id}.json?app_id=#{@app_id}"
    response= HTTPClient.get url

    raise ArgumentError.new "Got http response code=#{response.code} while attempting to fetch #{url}" unless response.code == 200
    JSON.parse response.body
  end
end
