import $ from 'jquery'
import {StatsMetric} from './metric'

export class StatsMetricsList {
  static getMetrics (url) {
    return this._makeRequest(url).then(response => this._parseResponse(response))
  }

  static _makeRequest (url) {
    return new Promise((resolve, reject) => {
      this.request = $.getJSON(url)
        .done(response => resolve(response))
        .fail((xhr, status, error) => reject(`Request failed: ${status}, ${error}`))
    })
  }

  static _parseResponse (response) {
    let parsedResponse = {}
    for (let metric in response) {
      parsedResponse[metric] = response[metric].map(m => new StatsMetric(m.metric))
    }
    return parsedResponse
  }
}
