class ThreeScaleMailer < ActionMailer::Base
  default from: 'dev-list@3scale.net'

  def provider_weekly_stats(files = {})
    files.each do |name, file|
      attachments[name] = file
    end

    mail(subject: 'Provider weekly stats CSV', to: 'mt-weekly-csv-report@3scale.net') do |format|
      format.text { render text: "Analytics for #{l Date.today}" }
    end
  end
end
