class Monitor::BaseController < FrontendController

  activate_menu :monitoring
  sublayout :stats

  before_action :has_monitoring
  before_action :find_service

  protected
  def api_monitor
    ApiMonitor.new current_account.settings.monitor_app_id, current_account.settings.monitor_api_id
  end

  private
  def has_monitoring
    if current_account.settings.monitor_app_id.nil? || current_account.settings.monitor_api_id.nil?
      render_error "Account #{current_account.org_name} doesn't have api2ls monitoring integrated", :status => 404
    end
  end

  def find_service
    @service = current_account.first_service!
  end
end
