class Finance::Api::BaseController < Admin::Api::BaseController
  access_token_scopes :finance

  include Finance::ControllerRequirements

  self.default_per_page = 20

  skip_before_action :authorize_finance

  before_action :finance_module_required
  before_action :set_api_version

  after_action :report_traffic

  private

  def metric_to_report
    :billing
  end

  # TODO: Extract to rack-rest_api_versioning gem
  def set_api_version
    unless Finance::Builder::XmlMarkup.supports_version?(api_version)
      render :text => "Unsupported Finance API version #{api_version}", status: :unsupported_media_type
    end
  end

  def api_version
    '1.0'.freeze
  end

end
