//= require vendor/urlify
//= require vendor/jquery/mailgun_validator

(function($){

  $(function() {
    var first_name = $("#variation_b_account_user_first_name");
    var first_name_val = first_name.val();
    var last_name_list_item = $("#variation_b_account_user_last_name_input");
    var last_name_errors = last_name_list_item.find(".inline-errors");


    if(first_name_val !== "") {
      last_name_errors.find(".first-name").html(first_name_val);
    }

    first_name.change(function(e) {
      var first_name_val = first_name.val();
      var last_name_list_item = $("#variation_b_account_user_last_name_input");
      var last_name_hints = last_name_list_item.find(".inline-hints");
      var last_name_errors = last_name_list_item.find(".inline-errors");

      if(first_name_val !== "") {
        last_name_hints.find(".first-name").html(first_name_val);
        last_name_errors.find(".first-name").html(first_name_val);
      }
    });


    var domain = $("#variation_b_account_subdomain");
    var self_domain = $("#variation_b_account_self_subdomain");

    domain.keyup(function() {
      var val = domain.val();
      if(val !== "") { val += "-admin"; }
      self_domain.val(val);
    });

    if(domain.val() === "") {
      domain.data('autoupdate', true);
    }

    domain.change(function(e){
      if(domain.val() === "") {
        domain.data('autoupdate', true);
      } else {
        domain.data('autoupdate', false);
      }
    });

    function showSubdomainFields() {
        if($('#variation_b_account_org_name').val().toString().length > 0) {
            domain.parent('li').removeClass('hidden');
            self_domain.parent('li').removeClass('hidden');
        }
    }

    $(document).on('keyup change', '#variation_b_account_org_name', function() {
      var name = $(this).val();
      var slug = window.URLify(name);
      showSubdomainFields();

      if(domain.data('autoupdate')) {
        domain.val(slug);
        domain.trigger('keyup');
      }
    });

    $(document).on('change', 'input', showSubdomainFields);
    showSubdomainFields();

    var user_email = $('#variation_b_account_user_email');
    var user_email_error = $('<p class="inline-errors"></p>');
    var email_parent = user_email.parent('li');
    var previous_email_error = user_email.next(".inline-errors");

    user_email.mailgun_validator({
      api_key: 'pubkey-889234583a41faa6d99b50ae152b2a3f',
      success: function(response) {
        var error_message = '';

        user_email_error.remove();

        if (response.is_valid) {
          email_parent.removeClass('error');
          user_email_error.remove();
        } else {
          email_parent.addClass('error');

          if (response.did_you_mean) {
            error_message = "Did you mean: " + response.did_you_mean + "?";
          }
          else {
            error_message = "Ehm, the email address should exist on this planet.";
          }
        }
        previous_email_error.hide();
        user_email_error.appendTo(email_parent).text(error_message);
      },
      error: function() {
        user_email_error.remove();
      }
    })
  });
})(jQuery);
