ceph-ansible stable-3.1 release note
====================================

276 files changed, 5931 insertions(+), 2775 deletions(-)

Ansible version support
-----------------------

This version supports Ansible 2.4 exclusively.

Ceph version support
--------------------

This version can deploy any version of Ceph starting from Jewel to Mimic.

Removed features
----------------

* Using `mon_use_fqdn` or `mds_use_fqdn` is discouraged. This is not a feature we plan on supporting further. As a result, ceph-ansible will now fail if the option `use_fqdn_yes_i_am_sure` is not set to `True`. This option is only here for cluster that were deployed with FQDN already.

Deprecation warnings
--------------------

* The role `ceph-rest-api` is not maintained anymore since the binary has been removed from Ceph Nautilus. We keep it around for older versions of Ceph though.

* `ceph-disk` deprecation, in stable-3.2 `ceph-disk` scenarios will only be supported for release **before** Nautilus. `ceph-volume` will become the new default as of stable-3.2.

Major changes from stable-3.0
-----------------------------

* site: fetch images in parallel ([#1963](https://github.com/ceph/ceph-ansible/pull/1963))
* rolling_update: upgrade: support for rbd mirror and nfs ([#2055](https://github.com/ceph/ceph-ansible/pull/2055))
* mgr: add ability to enable ceph mgr modules ([#1963](https://github.com/ceph/ceph-ansible/pull/1963))
* common: add openSUSE Leap 42.3 support ([#1963](https://github.com/ceph/ceph-ansible/pull/1963))
* module: ceph_volume ansible module ([#1963](https://github.com/ceph/ceph-ansible/pull/1963))
* module: ceph_key ansible module (Sébastien Han, [#2456](https://github.com/ceph/ceph-ansible/pull/2456))
* container: expose /var/run/ceph, this is handy for software that need socket access for monitoring purpose (Sébastien Han, [#2520](https://github.com/ceph/ceph-ansible/pull/2520))
* mon: support setting application pool when creating one (Guillaume Abrioux, [#2545](https://github.com/ceph/ceph-ansible/pull/2545))
* site: add support for installation checkpoint, this is helpful to do more profiling on which tasks/role took most of the time and how long they took. (Sébastien Han, [#2423](https://github.com/ceph/ceph-ansible/pull/2423))
* common: add AArch64 to supported architecture (Di Xu, [#2541](https://github.com/ceph/ceph-ansible/pull/2541))
* common: install packages as a list ([#1963](https://github.com/ceph/ceph-ansible/pull/1963))
* common: configure firewalld (Eduard Egorov, [#2196](https://github.com/ceph/ceph-ansible/pull/2196))
* container: add CPU and memory restriction flags for OSD (John Fulton, [#2246](https://github.com/ceph/ceph-ansible/pull/2246))
* module: add ceph_crush Ansible module and various enhancement on CRUSH hierarchy creation (Sébastien Han, [#2409](https://github.com/ceph/ceph-ansible/pull/2409))
* ansible: tune ansible.cfg (Jorge Tudela, [#2436](https://github.com/ceph/ceph-ansible/pull/2436))
* client: create keys and pools for client nodes only on first node, this a major performance and ressource usage improvement (Guillaume Abrioux, [#2487](https://github.com/ceph/ceph-ansible/pull/2487))
* site: ability to only generate a ceph.conf on the machines (Sébastien Han, [#2383](https://github.com/ceph/ceph-ansible/pull/2383))

Notable changes from stable-3.0
-------------------------------

* [8f9d97d3](https://github.com/ceph/ceph-ansible/commit/8f9d97d3) defaults: fix rgw_hostname (Sébastien Han)
* [b187c508](https://github.com/ceph/ceph-ansible/commit/b187c508) rolling_upgrade: set sortbitwise properly (Sébastien Han)
* [4ef9d42e](https://github.com/ceph/ceph-ansible/commit/4ef9d42e) iscsi group name preserve backward compatibility (Sébastien Han)
* [aeff1dbf](https://github.com/ceph/ceph-ansible/commit/aeff1dbf) osd: fix ceph_release (Sébastien Han)
* [988b5a81](https://github.com/ceph/ceph-ansible/commit/988b5a81) take-over-existing-cluster: do not call var_files (Sébastien Han)
* [b2de642c](https://github.com/ceph/ceph-ansible/commit/b2de642c) roles: ceph-defaults: Delegate cluster information task to monitor node (Markos Chandras)
* [e9433afd](https://github.com/ceph/ceph-ansible/commit/e9433afd) roles: ceph-defaults: Check if 'rgw' attribute exists for rgw_hostname (Markos Chandras)
* [2c77e1ac](https://github.com/ceph/ceph-ansible/commit/2c77e1ac) mgr: improve/fix disabled modules check (Dardo D Kleiner)
* [f183be03](https://github.com/ceph/ceph-ansible/commit/f183be03) lv-create: use copy instead of the template module (Andrew Schoen)
* [1decd53e](https://github.com/ceph/ceph-ansible/commit/1decd53e) tests: cat the contents of lv-create.log in infra_lv_create (Andrew Schoen)
* [6081aea5](https://github.com/ceph/ceph-ansible/commit/6081aea5) lv-create: add an example logfile_path config option in lv_vars.yml (Andrew Schoen)
* [c1191509](https://github.com/ceph/ceph-ansible/commit/c1191509) tests: adds a testing scenario for lv-create and lv-teardown (Andrew Schoen)
* [634cc143](https://github.com/ceph/ceph-ansible/commit/634cc143) lv-teardown: fail silently if lv_vars.yml is not found (Andrew Schoen)
* [09e4ef33](https://github.com/ceph/ceph-ansible/commit/09e4ef33) lv-teardown: set become: true at the playbook level (Andrew Schoen)
* [293aaaf7](https://github.com/ceph/ceph-ansible/commit/293aaaf7) lv-create: fail silenty if lv_vars.yml is not found (Andrew Schoen)
* [26487514](https://github.com/ceph/ceph-ansible/commit/26487514) lv-create: set become: true at the playbook level (Andrew Schoen)
* [9af84246](https://github.com/ceph/ceph-ansible/commit/9af84246) lv-create: use the template module to write log file (Andrew Schoen)
* [7f44244d](https://github.com/ceph/ceph-ansible/commit/7f44244d) infrastructure-playbooks/vars/lv_vars.yaml: minor fixes (Neha Ojha)
* [db0e06cb](https://github.com/ceph/ceph-ansible/commit/db0e06cb) infrastructure-playbooks/lv-create.yml: use tempfile to create logfile (Neha Ojha)
* [89d950fd](https://github.com/ceph/ceph-ansible/commit/89d950fd) infrastructure-playbooks/lv-create.yml: add lvm_volumes to suggested paste (Neha Ojha)
* [1a0f7baf](https://github.com/ceph/ceph-ansible/commit/1a0f7baf) infrastructure-playbooks/lv-create.yml: copy without using a template file (Neha Ojha)
* [f1245e60](https://github.com/ceph/ceph-ansible/commit/f1245e60) infrastructure-playbooks/lv-create.yml: don't use action to copy (Neha Ojha)
* [21902f01](https://github.com/ceph/ceph-ansible/commit/21902f01) infrastructure-playbooks: standardize variable usage with a space after brackets (Neha Ojha)
* [fb06c6cb](https://github.com/ceph/ceph-ansible/commit/fb06c6cb) vars/lv_vars.yaml: remove journal_device (Neha Ojha)
* [10da7776](https://github.com/ceph/ceph-ansible/commit/10da7776) infrastructure-playbooks: playbooks for creating LVs for bucket indexes and journals (Ali Maredia)
* [28fc45e3](https://github.com/ceph/ceph-ansible/commit/28fc45e3) Revert "osd: generate device list for osd_auto_discovery on rolling_update" (Sébastien Han)
* [6f149980](https://github.com/ceph/ceph-ansible/commit/6f149980) rolling_update: register container osd units (Sébastien Han)
* [51de2904](https://github.com/ceph/ceph-ansible/commit/51de2904) contrib: fix generate group_vars samples (Sébastien Han)
* [19c7ca19](https://github.com/ceph/ceph-ansible/commit/19c7ca19) Use /var/lib/ceph/osd folder to filter osd mount point (Jeffrey Zhang)
* [c44638ae](https://github.com/ceph/ceph-ansible/commit/c44638ae) stable 3.1 igw: add api setting support (Mike Christie)
* [2b76e377](https://github.com/ceph/ceph-ansible/commit/2b76e377) stable 3.1 igw: enable and start rbd-target-api (Mike Christie)
* [e7596d56](https://github.com/ceph/ceph-ansible/commit/e7596d56) group_vars: resync missing options (Sébastien Han)
* [904a0a40](https://github.com/ceph/ceph-ansible/commit/904a0a40) fail if fqdn deployment attempted (Guillaume Abrioux)
* [97cf08e8](https://github.com/ceph/ceph-ansible/commit/97cf08e8) config: ensure rgw section has the correct name (Guillaume Abrioux)
* [95c28e78](https://github.com/ceph/ceph-ansible/commit/95c28e78) mgr: backward compatibility for module management (Guillaume Abrioux)
* [9a013ab3](https://github.com/ceph/ceph-ansible/commit/9a013ab3) tests: resync iscsigw group name with master (Guillaume Abrioux)
* [32ef06e8](https://github.com/ceph/ceph-ansible/commit/32ef06e8) tests: fix a typo in testinfra for iscsigws and jewel scenario (Guillaume Abrioux)
* [8ea9d140](https://github.com/ceph/ceph-ansible/commit/8ea9d140) osd: generate device list for osd_auto_discovery on rolling_update (Sébastien Han)
* [47857991](https://github.com/ceph/ceph-ansible/commit/47857991) rolling_update: add role ceph-iscsi-gw (Sébastien Han)
* [12083bda](https://github.com/ceph/ceph-ansible/commit/12083bda) mon: fix calamari initialisation (Sébastien Han)
* [651058bd](https://github.com/ceph/ceph-ansible/commit/651058bd) rgw: remove useless condition (Sébastien Han)
* [eba9547a](https://github.com/ceph/ceph-ansible/commit/eba9547a) rgw: remove unused file (Sébastien Han)
* [a16dc0e1](https://github.com/ceph/ceph-ansible/commit/a16dc0e1) rgw: ability to use ceph-ansible vars into containers (Sébastien Han)
* [1a2c6a35](https://github.com/ceph/ceph-ansible/commit/1a2c6a35) common: upgrade/install ceph-test deb first (Ken Dreyer)
* [19958f5c](https://github.com/ceph/ceph-ansible/commit/19958f5c) Allow mgr bootstrap keyring to be defined (Graeme Gillies)
* [b00d2d04](https://github.com/ceph/ceph-ansible/commit/b00d2d04) Resync rhcs_edits.txt (Sébastien Han)
* [a31ce962](https://github.com/ceph/ceph-ansible/commit/a31ce962) test: remove osd_crush_location from shrink scenarios (Sébastien Han)
* [b76c7c3a](https://github.com/ceph/ceph-ansible/commit/b76c7c3a) test: follow up on osd_crush_location for containers (Sébastien Han)
* [9403a3df](https://github.com/ceph/ceph-ansible/commit/9403a3df) iscsigw: install ceph-iscsi-cli package (Guillaume Abrioux)
* [29003517](https://github.com/ceph/ceph-ansible/commit/29003517) Fix in regular expression matching OSD ID on non-contenerized deployment. restart_osd_daemon.sh is used to discover and restart all OSDs on a host. To do it the scripts loops the list of ceph-osd@ services in the system. This commit fixes bug in the regular expression responsile for extraction of OSDs - prior version uses `[0-9]{1,2}` expression which is ignoring all OSDS which numbers are greater than 99 (thus longer than 2 digits). Fix removed upper limit of digits in the number. This problem existed in two places in the script. (Artur Fijalkowski)
* [706d0b82](https://github.com/ceph/ceph-ansible/commit/706d0b82) defaults: backward compatibility with fqdn deployments (Guillaume Abrioux)
* [31dd4eee](https://github.com/ceph/ceph-ansible/commit/31dd4eee) rolling_update: set osd sortbitwise (Sébastien Han)
* [2d5ed5ef](https://github.com/ceph/ceph-ansible/commit/2d5ed5ef) config: enforce socket name (Sébastien Han)
* [826da2c3](https://github.com/ceph/ceph-ansible/commit/826da2c3) tests: support update scenarios in test_rbd_mirror_is_up() (Guillaume Abrioux)
* [99f84f88](https://github.com/ceph/ceph-ansible/commit/99f84f88) igw: fix image removal during purge (Mike Christie)
* [f3f734f8](https://github.com/ceph/ceph-ansible/commit/f3f734f8) igw: do not fail purge on rbd removal errors (Mike Christie)
* [47fb07af](https://github.com/ceph/ceph-ansible/commit/47fb07af) osd: do not remove expose_partition container (Sébastien Han)
* [11d96d08](https://github.com/ceph/ceph-ansible/commit/11d96d08) ceph-osds: backward compatibility with jewel for osp pools creation (Guillaume Abrioux)
* [75d68040](https://github.com/ceph/ceph-ansible/commit/75d68040) rbd-mirror: bring back compatibility with jewel deployment (Guillaume Abrioux)
* [1ab0f2ce](https://github.com/ceph/ceph-ansible/commit/1ab0f2ce) iscsigw: do not run common roles when deploying jewel (Guillaume Abrioux)
* [40135a56](https://github.com/ceph/ceph-ansible/commit/40135a56) tests: leave an OSD node in default crush root (Guillaume Abrioux)
* [04ec87f3](https://github.com/ceph/ceph-ansible/commit/04ec87f3) ceph ansible 3.1 igw: fix rbd-target-gw startup (Mike Christie)
* [154b1dcc](https://github.com/ceph/ceph-ansible/commit/154b1dcc) rgw: add more config option for civetweb frontend (Sébastien Han)
* [9184b794](https://github.com/ceph/ceph-ansible/commit/9184b794) Run creation of empty rados index object to first monitor (Giulio Fidente)
* [a4c87e20](https://github.com/ceph/ceph-ansible/commit/a4c87e20) tests: add mimic support in stable-3.1 (Guillaume Abrioux)
* [3d19e1bc](https://github.com/ceph/ceph-ansible/commit/3d19e1bc) tests: do not deploy all daemons for shrink osds scenarios (Guillaume Abrioux)
* [36f24a80](https://github.com/ceph/ceph-ansible/commit/36f24a80) shrink-osd: purge osd on containerized deployment (Sébastien Han)
* [a3fd9c85](https://github.com/ceph/ceph-ansible/commit/a3fd9c85) tests: stop hardcoding ansible version (Guillaume Abrioux)
* [9db4a23d](https://github.com/ceph/ceph-ansible/commit/9db4a23d) tests: add latest-bis-jewel for jewel tests (Guillaume Abrioux)
* [6e464fbc](https://github.com/ceph/ceph-ansible/commit/6e464fbc) nfs: change default stable branch for nfs-ganesha repo (Guillaume Abrioux)
* [3b74a691](https://github.com/ceph/ceph-ansible/commit/3b74a691) client: do not rely on copy_admin_key to import keys (Guillaume Abrioux)
* [aee48a40](https://github.com/ceph/ceph-ansible/commit/aee48a40) mgr: fix condition to add modules to ceph-mgr (Guillaume Abrioux)
* [6fe3c706](https://github.com/ceph/ceph-ansible/commit/6fe3c706) tests: skip rgw_tuning_pools_are_set when rgw_create_pools is not defined (Guillaume Abrioux)
* [ee1cc6b6](https://github.com/ceph/ceph-ansible/commit/ee1cc6b6) tests: skip tests for node iscsi-gw when deploying jewel (Guillaume Abrioux)
* [b8dde664](https://github.com/ceph/ceph-ansible/commit/b8dde664) tests: refact test_all_*_osds_are_up_and_in (Guillaume Abrioux)
* [ee59e06e](https://github.com/ceph/ceph-ansible/commit/ee59e06e) tests: fix broken test when collocated daemons scenarios (Guillaume Abrioux)
* [9323b8d7](https://github.com/ceph/ceph-ansible/commit/9323b8d7) tests: fix `_get_osd_id_from_host()` in TestOSDs() (Guillaume Abrioux)
* [4c7d2b1c](https://github.com/ceph/ceph-ansible/commit/4c7d2b1c) tests: refact test_all_*_osds_are_up_and_in (Guillaume Abrioux)
* [3b6afdee](https://github.com/ceph/ceph-ansible/commit/3b6afdee) tests: factorize docker tests using docker_exec_cmd logic (Guillaume Abrioux)
* [06392b27](https://github.com/ceph/ceph-ansible/commit/06392b27) tests: add mimic support for test_rbd_mirror_is_up() (Guillaume Abrioux)
* [f8a4c57c](https://github.com/ceph/ceph-ansible/commit/f8a4c57c) common: switch from docker module to docker_container (Guillaume Abrioux)
* [722e7412](https://github.com/ceph/ceph-ansible/commit/722e7412) mon: ensure socker is purged when mon is stopped (Guillaume Abrioux)
* [8d954795](https://github.com/ceph/ceph-ansible/commit/8d954795) ceph-config: do not log cluster log on container (Sébastien Han)
* [d565f28e](https://github.com/ceph/ceph-ansible/commit/d565f28e) ceph-common: fix rhcs condition (Sébastien Han)
* [b3abd677](https://github.com/ceph/ceph-ansible/commit/b3abd677) mgr: fix enabling of mgr module on mimic (Guillaume Abrioux)
* [837d5a44](https://github.com/ceph/ceph-ansible/commit/837d5a44) ceph-client: do not kill the dummy container (Sébastien Han)
* [ceded7e2](https://github.com/ceph/ceph-ansible/commit/ceded7e2) ceph-defaults: add default application to pool (Sébastien Han)
* [d6f265f5](https://github.com/ceph/ceph-ansible/commit/d6f265f5) ceph-mds: enable application pool (Sébastien Han)
* [6431976e](https://github.com/ceph/ceph-ansible/commit/6431976e) Enable monitor repo for mgr nodes and Tools repo for iscsi/nfs/clients (Vasu Kulkarni)
* [2b471094](https://github.com/ceph/ceph-ansible/commit/2b471094) ceph-mon: Generate initial keyring (Ha Phan)
* [863e99ea](https://github.com/ceph/ceph-ansible/commit/863e99ea) systemd: remove changed_when: false (Sébastien Han)
* [89945f8d](https://github.com/ceph/ceph-ansible/commit/89945f8d) ceph-osd: trigger osd container restart on script change (Sébastien Han)
* [fae6e6e0](https://github.com/ceph/ceph-ansible/commit/fae6e6e0) tests: reduce the amount of time we wait (Guillaume Abrioux)
* [06275d22](https://github.com/ceph/ceph-ansible/commit/06275d22) mon: honour mon_docker_net_host option (Sébastien Han)
* [df3ecb45](https://github.com/ceph/ceph-ansible/commit/df3ecb45) tests: add more nodes in ooo testing scenario (Guillaume Abrioux)
* [92d92160](https://github.com/ceph/ceph-ansible/commit/92d92160) tests: fix *_has_correct_value tests (Guillaume Abrioux)
* [045ba36e](https://github.com/ceph/ceph-ansible/commit/045ba36e) common: remove duplicate include of configure_firewall_rpm.yml (Guillaume Abrioux)
* [7a099bb5](https://github.com/ceph/ceph-ansible/commit/7a099bb5) common: start firewalld if configure_firewall (Sébastien Han)
* [60c06a7a](https://github.com/ceph/ceph-ansible/commit/60c06a7a) mon/osd: bump container memory limit (Sébastien Han)
* [2670a1f4](https://github.com/ceph/ceph-ansible/commit/2670a1f4) tests: keep same ceph release during handlers/idempotency test (Guillaume Abrioux)
* [2bcc1c71](https://github.com/ceph/ceph-ansible/commit/2bcc1c71) ceph-mds: do not enable multimds on jewel (Patrick Donnelly)
* [35af792f](https://github.com/ceph/ceph-ansible/commit/35af792f) client: try to kill dummy container only on first client node (Guillaume Abrioux)
* [5137bc26](https://github.com/ceph/ceph-ansible/commit/5137bc26) ceph-osd: set 'openstack_keys_tmp' only when 'openstack_config' is defined. (Konstantin Shalygin)
* [408ef69f](https://github.com/ceph/ceph-ansible/commit/408ef69f) common: ability to enable/disable fw configuration (Sébastien Han)
* [d1c361cd](https://github.com/ceph/ceph-ansible/commit/d1c361cd) tests: set CEPH_DOCKER_IMAGE_TAG when ceph release is luminous (Guillaume Abrioux)
* [156daf10](https://github.com/ceph/ceph-ansible/commit/156daf10) tests: increase memory to 1024Mb for centos7_cluster scenario (Guillaume Abrioux)
* [18e79421](https://github.com/ceph/ceph-ansible/commit/18e79421) client: keyrings aren't created when single client node (Guillaume Abrioux)
* [fd10fced](https://github.com/ceph/ceph-ansible/commit/fd10fced) tests: update ooo inventory hostfile (Guillaume Abrioux)
* [c35203da](https://github.com/ceph/ceph-ansible/commit/c35203da) client: add a default value for keyring file (Guillaume Abrioux)
* [7bcb005e](https://github.com/ceph/ceph-ansible/commit/7bcb005e) client: use dummy created container when there is no mon in inventory (Guillaume Abrioux)
* [48e7cc50](https://github.com/ceph/ceph-ansible/commit/48e7cc50) tests: improve mds tests (Guillaume Abrioux)
* [9d50874d](https://github.com/ceph/ceph-ansible/commit/9d50874d) osd: copy openstack keys over to all mon (Guillaume Abrioux)
* [c5335569](https://github.com/ceph/ceph-ansible/commit/c5335569) rolling_update: fix facts gathering delegation (Guillaume Abrioux)
* [5199300a](https://github.com/ceph/ceph-ansible/commit/5199300a) test: do not always copy admin key (Sébastien Han)
* [4c5042ae](https://github.com/ceph/ceph-ansible/commit/4c5042ae) change max_mds default to 1 (Patrick Donnelly)
* [f940163a](https://github.com/ceph/ceph-ansible/commit/f940163a) tests: fix rgw tests (Guillaume Abrioux)
* [a558d8ae](https://github.com/ceph/ceph-ansible/commit/a558d8ae) rgw: refact rgw pools creation (Guillaume Abrioux)
* [36b2c4a5](https://github.com/ceph/ceph-ansible/commit/36b2c4a5) rgws: renames create_pools variable with rgw_create_pools. (jtudelag)
* [1d94d12c](https://github.com/ceph/ceph-ansible/commit/1d94d12c) Adds RGWs pool creation to containerized installation. (jtudelag)
* [cd6ef8e9](https://github.com/ceph/ceph-ansible/commit/cd6ef8e9) tests: skip disabling fastest mirror detection on atomic host (Guillaume Abrioux)
* [51a7eb5a](https://github.com/ceph/ceph-ansible/commit/51a7eb5a) ceph-defaults: Enable local epel repository (Erwan Velu)
* [c90535ec](https://github.com/ceph/ceph-ansible/commit/c90535ec) Fix template reference for ganesha.conf (Andy McCrae)
* [53dfd050](https://github.com/ceph/ceph-ansible/commit/53dfd050) ceph-defaults: add the nautilus 14.x entry to ceph_release_num (Andrew Schoen)
* [28319698](https://github.com/ceph/ceph-ansible/commit/28319698) mons: move set_fact of openstack_keys in ceph-osd (Guillaume Abrioux)
* [9c91bb8b](https://github.com/ceph/ceph-ansible/commit/9c91bb8b) osds: wait for osds to be up before creating pools (Guillaume Abrioux)
* [01701eed](https://github.com/ceph/ceph-ansible/commit/01701eed) Makefile: followup on #2585 (Guillaume Abrioux)
* [b0356972](https://github.com/ceph/ceph-ansible/commit/b0356972) Makefile: add "make tag" command (Ken Dreyer)
* [2ac720d2](https://github.com/ceph/ceph-ansible/commit/2ac720d2) rgw: container add option to configure multi-site zone (Sébastien Han)
* [4f0850ad](https://github.com/ceph/ceph-ansible/commit/4f0850ad) mon: remove check on pg_num for cephfs_pools (Guillaume Abrioux)
* [4328e0b4](https://github.com/ceph/ceph-ansible/commit/4328e0b4) mdss: do not make pg_num a mandatory params (Guillaume Abrioux)
* [77b02fe7](https://github.com/ceph/ceph-ansible/commit/77b02fe7) tests: fix broken symlink (Guillaume Abrioux)
* [6ee4b228](https://github.com/ceph/ceph-ansible/commit/6ee4b228) osds: do not set docker_exec_cmd fact (Guillaume Abrioux)
* [e1c1017e](https://github.com/ceph/ceph-ansible/commit/e1c1017e) tests: resize root partition when atomic host (Guillaume Abrioux)
* [92f0de37](https://github.com/ceph/ceph-ansible/commit/92f0de37) tests: avoid yum failures (Guillaume Abrioux)
* [220d528e](https://github.com/ceph/ceph-ansible/commit/220d528e) mds: move mds fs pools creation (Guillaume Abrioux)
* [bdff7204](https://github.com/ceph/ceph-ansible/commit/bdff7204) Add privilege escalation to iscsi purge tasks (Paul Cuzner)
* [0d3bce95](https://github.com/ceph/ceph-ansible/commit/0d3bce95) playbook: follow up on #2553 (Guillaume Abrioux)
* [49f6d3cb](https://github.com/ceph/ceph-ansible/commit/49f6d3cb) ceph-defaults: move cephfs vars from the ceph-mon role (Andrew Schoen)
* [1fe58744](https://github.com/ceph/ceph-ansible/commit/1fe58744) group_vars: resync group_vars (Sébastien Han)
* [683bec9e](https://github.com/ceph/ceph-ansible/commit/683bec9e) mdss: move cephfs pools creation in ceph-mds (Guillaume Abrioux)
* [b00a3cf7](https://github.com/ceph/ceph-ansible/commit/b00a3cf7) tests: move cephfs_pools variable (Guillaume Abrioux)
* [873abdbf](https://github.com/ceph/ceph-ansible/commit/873abdbf) osds: move openstack pools creation in ceph-osd (Guillaume Abrioux)
* [4487eaba](https://github.com/ceph/ceph-ansible/commit/4487eaba) defaults: resync sample files with actual defaults (Guillaume Abrioux)
* [d7f0ea33](https://github.com/ceph/ceph-ansible/commit/d7f0ea33) ceph-radosgw: disable NSS PKI db when SSL is disabled (Luigi Toscano)
* [7b2cefd9](https://github.com/ceph/ceph-ansible/commit/7b2cefd9) rhcs: bump version to 3.0 for stable 3.1 (Sébastien Han)
* [0e0bd09b](https://github.com/ceph/ceph-ansible/commit/0e0bd09b) Skip GPT header creation for lvm osd scenario (Vishal Kanaujia)
* [37693870](https://github.com/ceph/ceph-ansible/commit/37693870) rolling_update: fix get fsid for containers (Sébastien Han)
* [747b545a](https://github.com/ceph/ceph-ansible/commit/747b545a) Fix restarting OSDs twice during a rolling update. (Subhachandra Chandra)
* [ddafad3f](https://github.com/ceph/ceph-ansible/commit/ddafad3f) switch: disable ceph-disk units (Sébastien Han)
* [ec528b92](https://github.com/ceph/ceph-ansible/commit/ec528b92) purge_cluster: fix dmcrypt purge (Guillaume Abrioux)
* [17ee4e92](https://github.com/ceph/ceph-ansible/commit/17ee4e92) purge_cluster: wipe all partitions (Guillaume Abrioux)
* [7d0e072d](https://github.com/ceph/ceph-ansible/commit/7d0e072d) purge_cluster: fix bug when building device list (Guillaume Abrioux)
* [831491f7](https://github.com/ceph/ceph-ansible/commit/831491f7) defaults: restart_osd_daemon unit spaces (Sébastien Han)
* [e1aa85f0](https://github.com/ceph/ceph-ansible/commit/e1aa85f0) Do nothing when mgr module is in good state (Michael Vollman)
* [fb030423](https://github.com/ceph/ceph-ansible/commit/fb030423) take-over: fix bug when trying to override variable (Guillaume Abrioux)
* [1556b69e](https://github.com/ceph/ceph-ansible/commit/1556b69e) rolling_update: move osd flag section (Sébastien Han)
* [861f4b87](https://github.com/ceph/ceph-ansible/commit/861f4b87) client: remove default value for pg_num in pools creation (Guillaume Abrioux)
* [1de47563](https://github.com/ceph/ceph-ansible/commit/1de47563) rolling_update: move mgr key creation (Sébastien Han)
* [9ca1d1d5](https://github.com/ceph/ceph-ansible/commit/9ca1d1d5) Revert "mon: fix mgr keyring creation when upgrading from jewel" (Sébastien Han)
* [6338f749](https://github.com/ceph/ceph-ansible/commit/6338f749) rolling_update: fix dest path for mgr keys fetching (Guillaume Abrioux)
* [7c7f517b](https://github.com/ceph/ceph-ansible/commit/7c7f517b) iscsi-gw: fix issue when trying to mask target (Guillaume Abrioux)
* [0bb7e6dd](https://github.com/ceph/ceph-ansible/commit/0bb7e6dd) iscsi: add python-rtslib repository (Sébastien Han)
* [54ef0496](https://github.com/ceph/ceph-ansible/commit/54ef0496) Allow os_tuning_params to overwrite fs.aio-max-nr (Andy McCrae)
* [b6ea36e9](https://github.com/ceph/ceph-ansible/commit/b6ea36e9) adds missing state needed to upgrade nfs-ganesha (Gregory Meno)
* [259fae93](https://github.com/ceph/ceph-ansible/commit/259fae93) mon: fix mgr keyring creation when upgrading from jewel (Guillaume Abrioux)
* [7b387b50](https://github.com/ceph/ceph-ansible/commit/7b387b50) osd: clean legacy syntax in ceph-osd-run.sh.j2 (Guillaume Abrioux)
* [b12bf62c](https://github.com/ceph/ceph-ansible/commit/b12bf62c) Make sure the restart_mds_daemon script is created with the correct MDS name (Simone Caronni)
* [07ca91b5](https://github.com/ceph/ceph-ansible/commit/07ca91b5) common: enable Tools repo for rhcs clients (Sébastien Han)
* [e99351b9](https://github.com/ceph/ceph-ansible/commit/e99351b9) Fix install of nfs-ganesha-ceph for Debian/SuSE (Andy McCrae)
* [75733daf](https://github.com/ceph/ceph-ansible/commit/75733daf) playbook: improve facts gathering (Guillaume Abrioux)
* [31762ded](https://github.com/ceph/ceph-ansible/commit/31762ded) ceph-nfs: disable attribute caching (Ramana Raja)
* [4a186237](https://github.com/ceph/ceph-ansible/commit/4a186237) common: copy iso files if rolling_update (Sébastien Han)
* [d142be04](https://github.com/ceph/ceph-ansible/commit/d142be04) Move apt cache update to individual task per role (Andy McCrae)
* [6fe8df62](https://github.com/ceph/ceph-ansible/commit/6fe8df62) client: fix pool creation (Guillaume Abrioux)
* [43e23ffe](https://github.com/ceph/ceph-ansible/commit/43e23ffe) mon: change application pool support (Sébastien Han)
* [75ed437d](https://github.com/ceph/ceph-ansible/commit/75ed437d) check if pools already exist before creating them (Guillaume Abrioux)
* [a68091c9](https://github.com/ceph/ceph-ansible/commit/a68091c9) tests: update the type for the rule used in pools (Guillaume Abrioux)
* [adeecc51](https://github.com/ceph/ceph-ansible/commit/adeecc51) switch: fix ceph_uid fact for osd (Guillaume Abrioux)
* [5fa92804](https://github.com/ceph/ceph-ansible/commit/5fa92804) switch: resolve device path so we can umount the osd data dir (Sébastien Han)
* [767abb5d](https://github.com/ceph/ceph-ansible/commit/767abb5d) switch: fix ceph_uid fact (Sébastien Han)
* [bbc9942d](https://github.com/ceph/ceph-ansible/commit/bbc9942d) Revert "add .vscode/ to gitignore" (Sébastien Han)
* [12eebc31](https://github.com/ceph/ceph-ansible/commit/12eebc31) mon/client: honor key mode when copying it to other nodes (Sébastien Han)
* [71efa2ea](https://github.com/ceph/ceph-ansible/commit/71efa2ea) ci: bump client nodes to 2 (Sébastien Han)
* [74494253](https://github.com/ceph/ceph-ansible/commit/74494253) mon: remove redundant copy task (Sébastien Han)
* [85732d11](https://github.com/ceph/ceph-ansible/commit/85732d11) mon/client: remove acl code (Sébastien Han)
* [cfe8e51d](https://github.com/ceph/ceph-ansible/commit/cfe8e51d) mon/client: apply mode from ceph_key (Sébastien Han)
* [59551351](https://github.com/ceph/ceph-ansible/commit/59551351) ceph_key: ability to apply a mode to a file (Sébastien Han)
* [113eb254](https://github.com/ceph/ceph-ansible/commit/113eb254) add AArch64 to supported architecture (Di Xu)
* [949507d3](https://github.com/ceph/ceph-ansible/commit/949507d3) mon: remove mgr key from ceph_config_keys (Sébastien Han)
* [35c1eb71](https://github.com/ceph/ceph-ansible/commit/35c1eb71) mon: remove mon map from ceph_config_keys (Sébastien Han)
* [62ec33d1](https://github.com/ceph/ceph-ansible/commit/62ec33d1) config_template: resync with upstream (Sébastien Han)
* [203c9af0](https://github.com/ceph/ceph-ansible/commit/203c9af0) ci: test ansible 2.5 (Sébastien Han)
* [65ba85af](https://github.com/ceph/ceph-ansible/commit/65ba85af) Expose /var/run/ceph (Sébastien Han)
* [bf1e70e8](https://github.com/ceph/ceph-ansible/commit/bf1e70e8) default: extent ceph_uid and gid (Sébastien Han)
* [f3656ad1](https://github.com/ceph/ceph-ansible/commit/f3656ad1) move create ceph initial directories to default (Sébastien Han)
* [66c1ea8c](https://github.com/ceph/ceph-ansible/commit/66c1ea8c) shrink-osd: ability to shrink NVMe drives (Sébastien Han)
* [641f141c](https://github.com/ceph/ceph-ansible/commit/641f141c) selinux: remove chcon calls (Sébastien Han)
* [90e47c5f](https://github.com/ceph/ceph-ansible/commit/90e47c5f) client: add a --rm option to run the container (Sébastien Han)
* [6c742376](https://github.com/ceph/ceph-ansible/commit/6c742376) client: import the key in ceph is copy_admin_key is true (Sébastien Han)
* [42481550](https://github.com/ceph/ceph-ansible/commit/42481550) client: add quotes to the dict values (Sébastien Han)
* [8e386751](https://github.com/ceph/ceph-ansible/commit/8e386751) Add support for --diff in config_template (Andy McCrae)
* [d2a2793c](https://github.com/ceph/ceph-ansible/commit/d2a2793c) refactor the way we copy keys (Sébastien Han)
* [127a643f](https://github.com/ceph/ceph-ansible/commit/127a643f) ceph-defaults: fix ceph_uid fact on container deployments (Randy J. Martinez)
* [a98885a7](https://github.com/ceph/ceph-ansible/commit/a98885a7) rhcs: re-add apt-pining (Sébastien Han)
* [899b0eb4](https://github.com/ceph/ceph-ansible/commit/899b0eb4) defaults: check only 1 time if there is a running cluster (Guillaume Abrioux)
* [ac41efd3](https://github.com/ceph/ceph-ansible/commit/ac41efd3) site: make it more readable (Guillaume Abrioux)
* [5bbbce52](https://github.com/ceph/ceph-ansible/commit/5bbbce52) osd: do not do anything if the dev has a partition (Sébastien Han)
* [77831ccb](https://github.com/ceph/ceph-ansible/commit/77831ccb) tests: update tests for mds to cover multimds case (Guillaume Abrioux)
* [37117071](https://github.com/ceph/ceph-ansible/commit/37117071) common: add tools repo for iscsi gw (Sébastien Han)
* [c8573fe0](https://github.com/ceph/ceph-ansible/commit/c8573fe0) Remove deprecated allow_multimds (Douglas Fuller)
* [020e66c1](https://github.com/ceph/ceph-ansible/commit/020e66c1) Fixed a typo (extra space) (vasishta p shastry)
* [e1a1f81b](https://github.com/ceph/ceph-ansible/commit/e1a1f81b) osd: to support copy_admin_key (vasishta p shastry)
* [db3a5ce6](https://github.com/ceph/ceph-ansible/commit/db3a5ce6) mds: to support copy_admin_keyring (vasishta p shastry)
* [6b59416f](https://github.com/ceph/ceph-ansible/commit/6b59416f) nfs: to support copy_admin_key - containerized (vasishta p shastry)
* [01c58695](https://github.com/ceph/ceph-ansible/commit/01c58695) nfs: ensure nfs-server server is stopped (Ali Maredia)
* [4a430ae2](https://github.com/ceph/ceph-ansible/commit/4a430ae2) ceph-nfs: allow disabling ganesha caching (Ramana Raja)
* [82ccbdaf](https://github.com/ceph/ceph-ansible/commit/82ccbdaf) ceph-defaults: bring backward compatibility for old syntax (Sébastien Han)
* [82589021](https://github.com/ceph/ceph-ansible/commit/82589021) ci: fix tripleO scenario (Sébastien Han)
* [2011ec3b](https://github.com/ceph/ceph-ansible/commit/2011ec3b) ci: client copy admin key (Sébastien Han)
* [cf73647e](https://github.com/ceph/ceph-ansible/commit/cf73647e) ci: remove useless tests (Sébastien Han)
* [9657e4d6](https://github.com/ceph/ceph-ansible/commit/9657e4d6) ceph_key: use ceph_key in the playbook (Sébastien Han)
* [473939d2](https://github.com/ceph/ceph-ansible/commit/473939d2) infra: add playbook example for ceph_key module (Sébastien Han)
* [2a924c10](https://github.com/ceph/ceph-ansible/commit/2a924c10) add ceph_key module (Sébastien Han)
* [4a4fb1a4](https://github.com/ceph/ceph-ansible/commit/4a4fb1a4) ceph_volume: objectstore should default to 'bluestore' (Andrew Schoen)
* [08f48755](https://github.com/ceph/ceph-ansible/commit/08f48755) ceph_volume: refactor to not run ceph osd destroy (Andrew Schoen)
* [36e71f65](https://github.com/ceph/ceph-ansible/commit/36e71f65) ceph_volume: perserve newlines in stdout and stderr when zapping (Andrew Schoen)
* [c6e8f8fb](https://github.com/ceph/ceph-ansible/commit/c6e8f8fb) purge-cluster: no need to use objectstore for ceph_volume module (Andrew Schoen)
* [a8b0d3f0](https://github.com/ceph/ceph-ansible/commit/a8b0d3f0) ceph_volume: rc should be 0 on successful runs (Andrew Schoen)
* [dbd52741](https://github.com/ceph/ceph-ansible/commit/dbd52741) ceph_volume: defines the zap param in module_args (Andrew Schoen)
* [a9b4c01b](https://github.com/ceph/ceph-ansible/commit/a9b4c01b) ceph_volume: make state not required so I can provide a default (Andrew Schoen)
* [9f469e2c](https://github.com/ceph/ceph-ansible/commit/9f469e2c) ceph_volume: objectstore is now optional except when state is present (Andrew Schoen)
* [c29a75ac](https://github.com/ceph/ceph-ansible/commit/c29a75ac) purge-cluster: use ceph_volume module to zap and destroy OSDs (Andrew Schoen)
* [98e237d2](https://github.com/ceph/ceph-ansible/commit/98e237d2) tests: no need to remove partitions in lvm_setup.yml (Andrew Schoen)
* [59e700c9](https://github.com/ceph/ceph-ansible/commit/59e700c9) ceph_volume: adds a zap property and reworks to support state: absent (Andrew Schoen)
* [b553a734](https://github.com/ceph/ceph-ansible/commit/b553a734) ceph_volume: adds a state property (Andrew Schoen)
* [796caf7d](https://github.com/ceph/ceph-ansible/commit/796caf7d) ceph_volume: remove the subcommand argument (Andrew Schoen)
* [d1f2d64b](https://github.com/ceph/ceph-ansible/commit/d1f2d64b) purge-docker: added conditionals needed to successfully re-run purge (Randy J. Martinez)
* [ad26d842](https://github.com/ceph/ceph-ansible/commit/ad26d842) Fixed wrong path of ceph.conf in docs. (JohnHaan)
* [66c4118d](https://github.com/ceph/ceph-ansible/commit/66c4118d) defaults: fix backward compatibility (Guillaume Abrioux)
* [3752cc6f](https://github.com/ceph/ceph-ansible/commit/3752cc6f) common: upgrade/install ceph-test RPM first (Ken Dreyer)
* [bb60f2fe](https://github.com/ceph/ceph-ansible/commit/bb60f2fe) ceph-defaults: fix ceoh_uid for container image tag latest (Sébastien Han)
* [14eff6b5](https://github.com/ceph/ceph-ansible/commit/14eff6b5) tox: use container latest tag for upgrades (Sébastien Han)
* [0123d790](https://github.com/ceph/ceph-ansible/commit/0123d790) Use the CentOS repo for Red Hat dev packages (Zack Cerza)
* [d981c6bd](https://github.com/ceph/ceph-ansible/commit/d981c6bd) site-docker: followup on #2487 (Guillaume Abrioux)
* [3c4319ca](https://github.com/ceph/ceph-ansible/commit/3c4319ca) add .vscode/ to gitignore (Sébastien Han)
* [ecd3563c](https://github.com/ceph/ceph-ansible/commit/ecd3563c) Deploying without managed monitors failed (Attila Fazekas)
* [dcf6a246](https://github.com/ceph/ceph-ansible/commit/dcf6a246) defaults: remove `run_once: true` when creating fetch_directory (Guillaume Abrioux)
* [18c0c7a5](https://github.com/ceph/ceph-ansible/commit/18c0c7a5) config: use fact `ceph_uid` (Guillaume Abrioux)
* [9c979c63](https://github.com/ceph/ceph-ansible/commit/9c979c63) clients: refact `ceph-clients` role (Guillaume Abrioux)
* [cefd4719](https://github.com/ceph/ceph-ansible/commit/cefd4719) client: remove legacy code (Guillaume Abrioux)
* [9d3517c6](https://github.com/ceph/ceph-ansible/commit/9d3517c6) container: play docker-common only on first client node (Guillaume Abrioux)
* [cf27c5e9](https://github.com/ceph/ceph-ansible/commit/cf27c5e9) move selinux check to `ceph-defaults` (Guillaume Abrioux)
* [f3caee84](https://github.com/ceph/ceph-ansible/commit/f3caee84) ceph-iscsi: fix certificates generation and distribution (Sébastien Han)
* [5b73be25](https://github.com/ceph/ceph-ansible/commit/5b73be25) do not delegate facts on client nodes (Guillaume Abrioux)
* [e32a177a](https://github.com/ceph/ceph-ansible/commit/e32a177a) purge-docker: remove redundant task (Guillaume Abrioux)
* [ca572a11](https://github.com/ceph/ceph-ansible/commit/ca572a11) ceph-mds: delete duplicate tasks which cause multimds container deployments to fail. (Randy J. Martinez)
* [3fcf9668](https://github.com/ceph/ceph-ansible/commit/3fcf9668) ceph-osd note that some scenarios use ceph-disk vs. ceph-volume (Alfredo Deza)
* [e6e6bd07](https://github.com/ceph/ceph-ansible/commit/e6e6bd07) Refer to expected-num-ojects as expected_num_objects, not size (John Fulton)
* [691ddf53](https://github.com/ceph/ceph-ansible/commit/691ddf53) cleanup osd.conf.j2 in ceph-osd (Ning Yao)
* [7f915473](https://github.com/ceph/ceph-ansible/commit/7f915473) setup cephx keys when not nfs_obj_gw (Patrick Donnelly)
* [6cffbd54](https://github.com/ceph/ceph-ansible/commit/6cffbd54) ceph-defaults: set is_atomic variable (Andrew Schoen)
* [fe4ba9d1](https://github.com/ceph/ceph-ansible/commit/fe4ba9d1) Fix config_template to consistently order sections (Andy McCrae)
* [388562a4](https://github.com/ceph/ceph-ansible/commit/388562a4) Simplify ceph.conf generation (Andy McCrae)
* [e3275c1c](https://github.com/ceph/ceph-ansible/commit/e3275c1c) osd: add fs.aio-max-nr tuning (Sébastien Han)
* [f432819c](https://github.com/ceph/ceph-ansible/commit/f432819c) osd: apply systcl right away (Sébastien Han)
* [0f8a4251](https://github.com/ceph/ceph-ansible/commit/0f8a4251) move system tuning to osd role (Sébastien Han)
* [3ab89ab4](https://github.com/ceph/ceph-ansible/commit/3ab89ab4) ci: re-arrange group_vars files (Sébastien Han)
* [d5f8cac8](https://github.com/ceph/ceph-ansible/commit/d5f8cac8) ci: remove left over iscsi_gws file (Sébastien Han)
* [8000ae34](https://github.com/ceph/ceph-ansible/commit/8000ae34) remove unsed ceph_rgw_civetweb_port variable (Sébastien Han)
* [f119b25b](https://github.com/ceph/ceph-ansible/commit/f119b25b) client: implement proper pools creation (Sébastien Han)
* [e302c1ba](https://github.com/ceph/ceph-ansible/commit/e302c1ba) mon: add support for erasure code pool (Sébastien Han)
* [277d885b](https://github.com/ceph/ceph-ansible/commit/277d885b) mon: add support for pgp, pool type and rule name (Sébastien Han)
* [4806ff4f](https://github.com/ceph/ceph-ansible/commit/4806ff4f) ci: test pool creation on container (Sébastien Han)
* [26bc00fb](https://github.com/ceph/ceph-ansible/commit/26bc00fb) mon: fail if pool creation fails (Sébastien Han)
* [0011edd2](https://github.com/ceph/ceph-ansible/commit/0011edd2) mon: add support for expected-num-objects (Sébastien Han)
* [18402b63](https://github.com/ceph/ceph-ansible/commit/18402b63) defaults: add useful info if daemon are not restarted properly (Sébastien Han)
* [3a9d0c55](https://github.com/ceph/ceph-ansible/commit/3a9d0c55) Tune ansible.cfg (jtudelag)
* [60d4b75f](https://github.com/ceph/ceph-ansible/commit/60d4b75f) Cleanup plugins directories and references (Andy McCrae)
* [691f7c51](https://github.com/ceph/ceph-ansible/commit/691f7c51) Adds handy ceph aliases whe containerized installations. (jtudelag)
* [9181c94a](https://github.com/ceph/ceph-ansible/commit/9181c94a) client: fix pgs num for client pool creation (Guillaume Abrioux)
* [96c049be](https://github.com/ceph/ceph-ansible/commit/96c049be) common: run updatedb task on debian systems only (Sébastien Han)
* [a52ed430](https://github.com/ceph/ceph-ansible/commit/a52ed430) mon: fix osd_pool_default_crush_rule persistence and effectiveness (Sébastien Han)
* [47cef7a4](https://github.com/ceph/ceph-ansible/commit/47cef7a4) mon: fix set crush default rule (Sébastien Han)
* [3261ab23](https://github.com/ceph/ceph-ansible/commit/3261ab23) osd: remove old crush_location implementation (Sébastien Han)
* [fc0fa48e](https://github.com/ceph/ceph-ansible/commit/fc0fa48e) test: add tests for creating crush tree (Sébastien Han)
* [73c48467](https://github.com/ceph/ceph-ansible/commit/73c48467) mon: use ceph_crush module in the playbook (Sébastien Han)
* [5fac3784](https://github.com/ceph/ceph-ansible/commit/5fac3784) add ceph_crush module (Sébastien Han)
* [78c1f193](https://github.com/ceph/ceph-ansible/commit/78c1f193) mons: Current crush_rule playbook does not work if there is no default rule defined (default: true). One could want to add new crush rules while keeping his current default rule. Fixed it so that it works with all rules defined as "default: false". If multiple rules are defined as default (should not be) then the last rule listed in "crush_rules" is taken as default. (Greg Charot)
* [77f9c1df](https://github.com/ceph/ceph-ansible/commit/77f9c1df) no reason the ceph-ansible ansible default provided crush_rule_hdd rule should be set as rack root + default ruleset (Greg Charot)
* [50afc3fb](https://github.com/ceph/ceph-ansible/commit/50afc3fb) We don't want to automatically move the rbd pool to the new default crush rule. This operation shall be performed by the cluster operator. (Greg Charot)
* [f2e0ceed](https://github.com/ceph/ceph-ansible/commit/f2e0ceed) add support for installation checkpoint (Sébastien Han)
* [04ca685b](https://github.com/ceph/ceph-ansible/commit/04ca685b) Remove vars that are no longer used (Andy McCrae)
* [c3267b77](https://github.com/ceph/ceph-ansible/commit/c3267b77) Makes use of docker_exec_cmd in ceph-mon role. (jtudelag)
* [cb0f5989](https://github.com/ceph/ceph-ansible/commit/cb0f5989) common: run updatedb task on debian systems only (Sébastien Han)
* [7f19df81](https://github.com/ceph/ceph-ansible/commit/7f19df81) rgw: add cluster name option to the handler (Sébastien Han)
* [fd94840a](https://github.com/ceph/ceph-ansible/commit/fd94840a) ci: add copy_admin_key test to container scenario (Sébastien Han)
* [9c852806](https://github.com/ceph/ceph-ansible/commit/9c852806) rgw: ability to copy ceph admin key on containerized (Sébastien Han)
* [67f46d8e](https://github.com/ceph/ceph-ansible/commit/67f46d8e) rgw: run the handler on a mon host (Sébastien Han)
* [1e283bf6](https://github.com/ceph/ceph-ansible/commit/1e283bf6) tests: make CI jobs using 'ansible.cfg' (Guillaume Abrioux)
* [6d35bc9b](https://github.com/ceph/ceph-ansible/commit/6d35bc9b) client: use `ceph_uid` fact to set uid/gid on admin key (Guillaume Abrioux)
* [1e1b26ca](https://github.com/ceph/ceph-ansible/commit/1e1b26ca) mds: fix ansible_service_mgr typo (Grant Slater)
* [c33dae75](https://github.com/ceph/ceph-ansible/commit/c33dae75) Revert "[TEST] Test setting up correct systemd file for nfs-ganesha" (Andy McCrae)
* [a83e1aee](https://github.com/ceph/ceph-ansible/commit/a83e1aee) Make rule_name optional when defining items in openstack_pools (Giulio Fidente)
* [165d9dec](https://github.com/ceph/ceph-ansible/commit/165d9dec) remove kernel.pid_max (Sébastien Han)
* [4a898645](https://github.com/ceph/ceph-ansible/commit/4a898645) tests: change ceph_docker_image_tag for 2nd run (Guillaume Abrioux)
* [707458c9](https://github.com/ceph/ceph-ansible/commit/707458c9) ci: add tripleo scenario testing (Guillaume Abrioux)
* [2779d2a8](https://github.com/ceph/ceph-ansible/commit/2779d2a8) Adjust /etc/updatedb.conf to not parse /var/lib/ceph (Andy McCrae)
* [e88af3c4](https://github.com/ceph/ceph-ansible/commit/e88af3c4) [TEST] Test setting up correct systemd file for nfs-ganesha (Andy McCrae)
* [c04e6734](https://github.com/ceph/ceph-ansible/commit/c04e6734) update: look for short and fqdn in ceph_health_raw (Guillaume Abrioux)
* [463b5c6b](https://github.com/ceph/ceph-ansible/commit/463b5c6b) Remove redundant task to check if atomic (Paul Bourke)
* [59a4335a](https://github.com/ceph/ceph-ansible/commit/59a4335a) Restart services if handler called (Andy McCrae)
* [c816a928](https://github.com/ceph/ceph-ansible/commit/c816a928) container: osd remove run_once (Sébastien Han)
* [d47d02a5](https://github.com/ceph/ceph-ansible/commit/d47d02a5) docker-common: fix container restart on new image (Sébastien Han)
* [ebc19548](https://github.com/ceph/ceph-ansible/commit/ebc19548) default: remove duplicate code (Sébastien Han)
* [7d690878](https://github.com/ceph/ceph-ansible/commit/7d690878) test: add test for containers resources changes (Sébastien Han)
* [79864a89](https://github.com/ceph/ceph-ansible/commit/79864a89) test: add test for restart on new container image (Sébastien Han)
* [699c777e](https://github.com/ceph/ceph-ansible/commit/699c777e) rolling update: fix undefined jewel_minor_update failure (Andrew Schoen)
* [7c7017eb](https://github.com/ceph/ceph-ansible/commit/7c7017eb) infra: do not include host_vars/* in take-over-existing-cluster.yml (Andrew Schoen)
* [0be60456](https://github.com/ceph/ceph-ansible/commit/0be60456) osd: Add support for multipath disks (Caleb Boylan)
* [b4dbc862](https://github.com/ceph/ceph-ansible/commit/b4dbc862) Set application for OpenStack pools (Andy McCrae)
* [ff906610](https://github.com/ceph/ceph-ansible/commit/ff906610) site: ability to only generate a ceph.conf on the machines (Sébastien Han)
* [22f843e3](https://github.com/ceph/ceph-ansible/commit/22f843e3) default: define 'osd_scenario' variable (Sébastien Han)
* [e537779b](https://github.com/ceph/ceph-ansible/commit/e537779b) osd: fix osd restart when dmcrypt (Guillaume Abrioux)
* [fff438fb](https://github.com/ceph/ceph-ansible/commit/fff438fb) Update Documentation example link to 3.0 (Grant)
* [bdcc52b9](https://github.com/ceph/ceph-ansible/commit/bdcc52b9) Check for docker sockets named after both _hostname or _fqdn (Giulio Fidente)
* [a6d1922a](https://github.com/ceph/ceph-ansible/commit/a6d1922a) mon: Fixed crush_rule_config for containerised deployment. (Greg Charot)
* [3b2f6c34](https://github.com/ceph/ceph-ansible/commit/3b2f6c34) purge-docker: fix ceph-osd-zap name container (Guillaume Abrioux)
* [dd0c98c5](https://github.com/ceph/ceph-ansible/commit/dd0c98c5) common: do not use `shell` module when it is not needed (Guillaume Abrioux)
* [deaf273b](https://github.com/ceph/ceph-ansible/commit/deaf273b) syntax: change local_action syntax (Guillaume Abrioux)
* [b1a3c6e4](https://github.com/ceph/ceph-ansible/commit/b1a3c6e4) osd: resync group_vars file (Sébastien Han)
* [6f9dd26c](https://github.com/ceph/ceph-ansible/commit/6f9dd26c) config: remove any spaces in public_network or cluster_network (Sébastien Han)
* [f372a423](https://github.com/ceph/ceph-ansible/commit/f372a423) purge: fix resolve parent device task (Guillaume Abrioux)
* [5132cc3d](https://github.com/ceph/ceph-ansible/commit/5132cc3d) Do not search osd ids if ceph-volume (Sébastien Han)
* [481173f2](https://github.com/ceph/ceph-ansible/commit/481173f2) Add default for radosgw_keystone_ssl (Andy McCrae)
* [f1232b33](https://github.com/ceph/ceph-ansible/commit/f1232b33) Revert "monitor_interface: document need to use monitor_address when using IPv6" (Guillaume Abrioux)
* [93e9f372](https://github.com/ceph/ceph-ansible/commit/93e9f372) config: add host-specific ceph_conf_overrides evaluation and generation. (Eduard Egorov)
* [c7ec12d4](https://github.com/ceph/ceph-ansible/commit/c7ec12d4) upgrade: skip luminous tasks for jewel minor update (Guillaume Abrioux)
* [ec16cbdb](https://github.com/ceph/ceph-ansible/commit/ec16cbdb) defaults: avoid getting stuck (ceph --connect-timeout) (Guillaume Abrioux)
* [21931c54](https://github.com/ceph/ceph-ansible/commit/21931c54) docs for creating encrypted OSDs with the lvm scenario (Andrew Schoen)
* [79473bad](https://github.com/ceph/ceph-ansible/commit/79473bad) ceph-osd: adds dmcrypt to the lvm scenario (Andrew Schoen)
* [965d2965](https://github.com/ceph/ceph-ansible/commit/965d2965) ceph-volume: adds a dmcrypt param to the ceph_volume module (Andrew Schoen)
* [5bf56425](https://github.com/ceph/ceph-ansible/commit/5bf56425) ansible: set ssh retry option to 5 (Guillaume Abrioux)
* [9306a178](https://github.com/ceph/ceph-ansible/commit/9306a178) osds: change default value for `dedicated_devices` (Guillaume Abrioux)
* [cfb75b8e](https://github.com/ceph/ceph-ansible/commit/cfb75b8e) tests: remove crush_device_class from lvm tests (Andrew Schoen)
* [f88795e8](https://github.com/ceph/ceph-ansible/commit/f88795e8) rgw: disable legacy unit (Sébastien Han)
* [8af74594](https://github.com/ceph/ceph-ansible/commit/8af74594) rolling update: add mgr exception for jewel minor updates (Sébastien Han)
* [55298fa8](https://github.com/ceph/ceph-ansible/commit/55298fa8) purge-container: use lsblk to resolv parent device (Guillaume Abrioux)
* [58eb045d](https://github.com/ceph/ceph-ansible/commit/58eb045d) purge-container: remove awk usage in favor of blkid (Guillaume Abrioux)
* [fb4a6dc9](https://github.com/ceph/ceph-ansible/commit/fb4a6dc9) docs for the crush_device_class option of lvm_volumes (Andrew Schoen)
* [64f57721](https://github.com/ceph/ceph-ansible/commit/64f57721) tests: adds crush_device_class to lvm tests (Andrew Schoen)
* [6cbb56a3](https://github.com/ceph/ceph-ansible/commit/6cbb56a3) ceph-osd: adds the crush_device_class param to the lvm scenario (Andrew Schoen)
* [875e14ca](https://github.com/ceph/ceph-ansible/commit/875e14ca) ceph_volume: adds the crush_device_class param (Andrew Schoen)
* [752bf3e3](https://github.com/ceph/ceph-ansible/commit/752bf3e3) Makefile: handle "beta" Git tags (Ken Dreyer)
* [7d7080df](https://github.com/ceph/ceph-ansible/commit/7d7080df) crush: create rack type buckets and build crush tree according to {{ osd_crush_location }}. (Eduard Egorov)
* [6db4aea4](https://github.com/ceph/ceph-ansible/commit/6db4aea4) osd: skip devices marked as '/dev/dead' (Sébastien Han)
* [7ba25b20](https://github.com/ceph/ceph-ansible/commit/7ba25b20) ci: test on ansible 2.4.2 (Sébastien Han)
* [70401f95](https://github.com/ceph/ceph-ansible/commit/70401f95) container: trigger handlers on systemd file change (Guillaume Abrioux)
* [b29a42cb](https://github.com/ceph/ceph-ansible/commit/b29a42cb) handlers: avoid duplicate handler (Guillaume Abrioux)
* [8a19a833](https://github.com/ceph/ceph-ansible/commit/8a19a833) container: restart container when there is a new image (Sébastien Han)
* [900f447c](https://github.com/ceph/ceph-ansible/commit/900f447c) containers: fix bug when looking for existing cluster (Guillaume Abrioux)
* [c2e04623](https://github.com/ceph/ceph-ansible/commit/c2e04623) container: change the way we force no logs inside the container (Sébastien Han)
* [acfbebe6](https://github.com/ceph/ceph-ansible/commit/acfbebe6) defaults: rename check_socket files for containers (Guillaume Abrioux)
* [f0787e64](https://github.com/ceph/ceph-ansible/commit/f0787e64) mon: use crush rules for non-container too (Sébastien Han)
* [97f520bc](https://github.com/ceph/ceph-ansible/commit/97f520bc) containers: bump memory limit (Sébastien Han)
* [a8509fbc](https://github.com/ceph/ceph-ansible/commit/a8509fbc) test: set UPDATE_CEPH_DOCKER_IMAGE_TAG for jewel tests (Andrew Schoen)
* [b613321c](https://github.com/ceph/ceph-ansible/commit/b613321c) switch-to-containers: do not fail when stopping the nfs-ganesha service (Andrew Schoen)
* [0b4b60e3](https://github.com/ceph/ceph-ansible/commit/0b4b60e3) switch-to-containers: do not fail when stopping the ceph-mgr daemon (Andrew Schoen)
* [997edea2](https://github.com/ceph/ceph-ansible/commit/997edea2) rolling_update: do not fail the playbook if nfs-ganesha is not present (Andrew Schoen)
* [9c5e8ce7](https://github.com/ceph/ceph-ansible/commit/9c5e8ce7) doc: corrected a typo (Aviolat Romain)
* [0b55abe3](https://github.com/ceph/ceph-ansible/commit/0b55abe3) mon: always run ceph-create-keys (Sébastien Han)
* [ad54e192](https://github.com/ceph/ceph-ansible/commit/ad54e192) rgw: disable legacy rgw service unit (Sébastien Han)
* [895949d6](https://github.com/ceph/ceph-ansible/commit/895949d6) osd: fix check gpt (Guillaume Abrioux)
* [c5b7b371](https://github.com/ceph/ceph-ansible/commit/c5b7b371) purge-cluster: clean some code (Guillaume Abrioux)
* [eeedefdf](https://github.com/ceph/ceph-ansible/commit/eeedefdf) purge-cluster: wipe disk using dd (Guillaume Abrioux)
* [39f2bfd5](https://github.com/ceph/ceph-ansible/commit/39f2bfd5) fix jewel scenarios on container (Sébastien Han)
* [c315f81d](https://github.com/ceph/ceph-ansible/commit/c315f81d) site-docker: ability to disable fact sharing (Sébastien Han)
* [bbc79765](https://github.com/ceph/ceph-ansible/commit/bbc79765) osd: best effort if no device is found during activation (Sébastien Han)
* [20078583](https://github.com/ceph/ceph-ansible/commit/20078583) rolling_update: do not require root to answer question (Sébastien Han)
* [dfbef836](https://github.com/ceph/ceph-ansible/commit/dfbef836) nfs: fix package install for debian/suss systems (Sébastien Han)
* [50a848dc](https://github.com/ceph/ceph-ansible/commit/50a848dc) Rename fact docker_version to ceph_docker_version (Christian Berendt)
* [162b7d2b](https://github.com/ceph/ceph-ansible/commit/162b7d2b) roles: ceph-mgr: Install the ceph-mgr package on SUSE (Markos Chandras)
* [15287c66](https://github.com/ceph/ceph-ansible/commit/15287c66) contrib: do not skip ci on backport (Sébastien Han)
* [a24fd1cf](https://github.com/ceph/ceph-ansible/commit/a24fd1cf) client: don't make `osd_pool_default_pg_num` mandatory (Guillaume Abrioux)
* [ab1dd302](https://github.com/ceph/ceph-ansible/commit/ab1dd302) client: don't try to generate keys (Guillaume Abrioux)
* [26afe46e](https://github.com/ceph/ceph-ansible/commit/26afe46e) docker: add missing condition for selinux tasks (Guillaume Abrioux)
* [7eaf4443](https://github.com/ceph/ceph-ansible/commit/7eaf4443) default: look for the right return code on socket stat in-use (Sébastien Han)
* [8cba4426](https://github.com/ceph/ceph-ansible/commit/8cba4426) Add flags for OSD 'docker run --cpuset-{cpus,mems}' (John Fulton)
* [a8a2c13f](https://github.com/ceph/ceph-ansible/commit/a8a2c13f) firewall: add mds, nfs, restapi and iscsi ports, remove 'configure_firewall' variable used for conditional execution. Include the task only on rpm-based systems. (Eduard Egorov)
* [6a5e0da3](https://github.com/ceph/ceph-ansible/commit/6a5e0da3) firewall: configure firewalld if it's already installed on the host (#2192). (Eduard Egorov)
* [73a20e9b](https://github.com/ceph/ceph-ansible/commit/73a20e9b) Revert "tests: set CEPH_STABLE_RELEASE in ceph-build" (Guillaume Abrioux)
* [5676fa23](https://github.com/ceph/ceph-ansible/commit/5676fa23) Convert interface names to underscores for facts (Major Hayden)
* [d7dadc3e](https://github.com/ceph/ceph-ansible/commit/d7dadc3e) ceph-osd: respect nvme partitions when device is a disk. (Konstantin Shalygin)
* [6a9b5c96](https://github.com/ceph/ceph-ansible/commit/6a9b5c96) defaults: fix CI issue with ceph_uid fact (Guillaume Abrioux)
* [788c3f35](https://github.com/ceph/ceph-ansible/commit/788c3f35) ceph-osd: adds osd_objectstore to the name when using the ceph_volume module (Andrew Schoen)
* [15db3323](https://github.com/ceph/ceph-ansible/commit/15db3323) tests for the ceph_volume module (Andrew Schoen)
* [4b4680d1](https://github.com/ceph/ceph-ansible/commit/4b4680d1) refactor ceph_volume.py so it's easier to test (Andrew Schoen)
* [5e3d8dbf](https://github.com/ceph/ceph-ansible/commit/5e3d8dbf) ceph-osd: use the cluster param with the ceph_volume module (Andrew Schoen)
* [7721aa37](https://github.com/ceph/ceph-ansible/commit/7721aa37) ceph_volume: adds the cluster param (Andrew Schoen)
* [423166f6](https://github.com/ceph/ceph-ansible/commit/423166f6) ceph-osd: use the new ceph_volume module for the lvm scenario (Andrew Schoen)
* [61b4a1be](https://github.com/ceph/ceph-ansible/commit/61b4a1be) adds a ceph_volume module (Andrew Schoen)
* [a9981b41](https://github.com/ceph/ceph-ansible/commit/a9981b41) Vagrantfile: Fixed repeated OSD controller creation (Prisacari Dmitrii)
* [4f1e854c](https://github.com/ceph/ceph-ansible/commit/4f1e854c) Use parted module instead of command (Andy McCrae)
* [ffae2942](https://github.com/ceph/ceph-ansible/commit/ffae2942) Set tighter permissions on keyrings when containerized (John Fulton)
* [aaaf9801](https://github.com/ceph/ceph-ansible/commit/aaaf9801) purge: fix bug on 'wait_for' task (Guillaume Abrioux)
* [ebe0e602](https://github.com/ceph/ceph-ansible/commit/ebe0e602) Openstack: replaced hardcoded pool names with variables for openstack (nova) user (wintamute)
* [8f02bb00](https://github.com/ceph/ceph-ansible/commit/8f02bb00) Add support for using loopback devices as OSDs (Caleb Boylan)
* [b26a8400](https://github.com/ceph/ceph-ansible/commit/b26a8400) handlers: restart daemons only if docker is running (Guillaume Abrioux)
* [bb7b29a9](https://github.com/ceph/ceph-ansible/commit/bb7b29a9) common: install ceph-common on all the machines (Sébastien Han)
* [2435c48c](https://github.com/ceph/ceph-ansible/commit/2435c48c) Allow to use rados for ganesha exports (Jan Provaznik)
* [1cba6264](https://github.com/ceph/ceph-ansible/commit/1cba6264) osd: remove leftover and fix a typo (Guillaume Abrioux)
* [947766e2](https://github.com/ceph/ceph-ansible/commit/947766e2) purge-cluster: remove usage of `with_fileglob` (Guillaume Abrioux)
* [efe06be1](https://github.com/ceph/ceph-ansible/commit/efe06be1) osd: ensure a gpt label is set on device (Guillaume Abrioux)
* [d73f751b](https://github.com/ceph/ceph-ansible/commit/d73f751b) Make openstack_keys param support no acls list (John Fulton)
* [932345ab](https://github.com/ceph/ceph-ansible/commit/932345ab) osd: remove leftover from osd partition (Sébastien Han)
* [b1c13223](https://github.com/ceph/ceph-ansible/commit/b1c13223) osd: remove failed_when on activation (Sébastien Han)
* [80d3a242](https://github.com/ceph/ceph-ansible/commit/80d3a242) osd: fix bad activation for dmcrypt (Sébastien Han)
* [d9c1b610](https://github.com/ceph/ceph-ansible/commit/d9c1b610) purge-docker: remove osd disk prepare logs (Guillaume Abrioux)
* [ccad0ebf](https://github.com/ceph/ceph-ansible/commit/ccad0ebf) rbd: enable ceph-rbd-mirror.target for releases <= luminous (Guillaume Abrioux)
* [09724937](https://github.com/ceph/ceph-ansible/commit/09724937) fix: remove the duplicated code (Yixing Yan)
* [6dc090a4](https://github.com/ceph/ceph-ansible/commit/6dc090a4) update group_vars/osds.yml.sample for the new lvm_volumes examples (Andrew Schoen)
* [3c604f11](https://github.com/ceph/ceph-ansible/commit/3c604f11) lvm: support --data as a raw device or partition in ceph-volume (Andrew Schoen)
* [04f02910](https://github.com/ceph/ceph-ansible/commit/04f02910) lvm: ensure the data_vg exists before using it (Andrew Schoen)
* [d65cbaa5](https://github.com/ceph/ceph-ansible/commit/d65cbaa5) Set permissions and ACLs of OpenStack keys on all ceph-mons (John Fulton)
* [aa0b1ed1](https://github.com/ceph/ceph-ansible/commit/aa0b1ed1) tests: remove OSD_FORCE_ZAP variable from tests (Guillaume Abrioux)
* [7a1d7d92](https://github.com/ceph/ceph-ansible/commit/7a1d7d92) tests: set CEPH_STABLE_RELEASE in ceph-build (Guillaume Abrioux)
* [c7aa109b](https://github.com/ceph/ceph-ansible/commit/c7aa109b) vagrant_variables.yml.sample: Add openSUSE box (Markos Chandras)
* [f8e3d4bb](https://github.com/ceph/ceph-ansible/commit/f8e3d4bb) ceph-docker-common: Add support for openSUSE Leap distributions (Markos Chandras)
* [8c321b84](https://github.com/ceph/ceph-ansible/commit/8c321b84) ceph-nfs: Add support for openSUSE Leap distributions (Markos Chandras)
* [173959cf](https://github.com/ceph/ceph-ansible/commit/173959cf) ceph-rgw: Add support for openSUSE Leap distributions (Markos Chandras)
* [a868c52f](https://github.com/ceph/ceph-ansible/commit/a868c52f) ceph-restapi: Add support for openSUSE Leap distributions (Markos Chandras)
* [ddb468bf](https://github.com/ceph/ceph-ansible/commit/ddb468bf) ceph-rbd-mirror: Add support for openSUSE Leap distributions (Markos Chandras)
* [fb469503](https://github.com/ceph/ceph-ansible/commit/fb469503) ceph-osd: Add support for openSUSE Leap distributions (Markos Chandras)
* [34a40adc](https://github.com/ceph/ceph-ansible/commit/34a40adc) ceph-mon: Add support for openSUSE Leap distributions (Markos Chandras)
* [f944ee39](https://github.com/ceph/ceph-ansible/commit/f944ee39) ceph-mgr: Add support for openSUSE Leap distributions (Markos Chandras)
* [8135638c](https://github.com/ceph/ceph-ansible/commit/8135638c) ceph-mds: Add support for openSUSE Leap distributions (Markos Chandras)
* [c6103a0f](https://github.com/ceph/ceph-ansible/commit/c6103a0f) ceph-fetch-keys: Add support for openSUSE Leap distributions (Markos Chandras)
* [3e4a7c8b](https://github.com/ceph/ceph-ansible/commit/3e4a7c8b) ceph-config: Add support for the openSUSE Leap distributions (Markos Chandras)
* [211b0c33](https://github.com/ceph/ceph-ansible/commit/211b0c33) ceph-client: Add support for the openSUSE Leap distributions (Markos Chandras)
* [e06c1084](https://github.com/ceph/ceph-ansible/commit/e06c1084) ceph-agent: Add support for the openSUSE Leap distributions (Markos Chandras)
* [dd6ee725](https://github.com/ceph/ceph-ansible/commit/dd6ee725) ceph-common: Don't check for ceph_stable_release for distro packages (Markos Chandras)
* [84978696](https://github.com/ceph/ceph-ansible/commit/84978696) ceph-common: Add initial support for openSUSE Leap distributions (Markos Chandras)
* [44df3f91](https://github.com/ceph/ceph-ansible/commit/44df3f91) defaults: fix rgw restart script in handlers (Guillaume Abrioux)
* [3c999b31](https://github.com/ceph/ceph-ansible/commit/3c999b31) rpm: require ansible 2.4.1.0 (Ken Dreyer)
* [fa675f2e](https://github.com/ceph/ceph-ansible/commit/fa675f2e) purge-docker-cluster: ensure old logs are removed (Guillaume Abrioux)
* [591d7722](https://github.com/ceph/ceph-ansible/commit/591d7722) osd: always run disk_list test (Guillaume Abrioux)
* [43975a73](https://github.com/ceph/ceph-ansible/commit/43975a73) osd: avoid using non desired loop device in autodiscovery (Guillaume Abrioux)
* [80d32dec](https://github.com/ceph/ceph-ansible/commit/80d32dec) config: fix config generation (Guillaume Abrioux)
* [d5dfc63c](https://github.com/ceph/ceph-ansible/commit/d5dfc63c) osd: fix automatic prepare when auto_discover (Guillaume Abrioux)
* [d82a09dd](https://github.com/ceph/ceph-ansible/commit/d82a09dd) fix crush location for non-containerized deployment (yaoning)
* [0930f149](https://github.com/ceph/ceph-ansible/commit/0930f149) osd: do not use dm when osd_auto_discovery (Sébastien Han)
* [238754a8](https://github.com/ceph/ceph-ansible/commit/238754a8) osd: skip some set_fact when osd_scenario=lvm (Guillaume Abrioux)
* [39b584e5](https://github.com/ceph/ceph-ansible/commit/39b584e5) osd: fix a typo in roles/ceph-osd/defaults/main.yml (Guillaume Abrioux)
* [41d10a2f](https://github.com/ceph/ceph-ansible/commit/41d10a2f) infra: fix take-over-existing-cluster.yml playbook (Caleb Boylan)
* [5cde3175](https://github.com/ceph/ceph-ansible/commit/5cde3175) FIX: run restart scripts in `noexec` /tmp (Arano-kai)
* [7d239b69](https://github.com/ceph/ceph-ansible/commit/7d239b69) fix the ansible version for the stable-3.0 branch (Yixing Yan)
* [d4ed9a20](https://github.com/ceph/ceph-ansible/commit/d4ed9a20) osd: enhance backward compatibility (Sébastien Han)
* [de0900ea](https://github.com/ceph/ceph-ansible/commit/de0900ea) tests: sync with ceph/ceph-build for ceph-ansible-nightlies (Guillaume Abrioux)
* [ab7eb792](https://github.com/ceph/ceph-ansible/commit/ab7eb792) config: fix monitor_interface when not passed in the inventory file (Sébastien Han)
* [4596fbaa](https://github.com/ceph/ceph-ansible/commit/4596fbaa) common: make the delegate_facts feature optional (Guillaume Abrioux)
* [37a48209](https://github.com/ceph/ceph-ansible/commit/37a48209) test: when creating the /dev/sdc2 partition specify label as gpt (Andrew Schoen)
* [635fe381](https://github.com/ceph/ceph-ansible/commit/635fe381) contrib: skip ci and hightlight origin PR (Sébastien Han)
* [589cd27c](https://github.com/ceph/ceph-ansible/commit/589cd27c) Include ganesha dbus config file (Jan Provaznik)
* [c28882c1](https://github.com/ceph/ceph-ansible/commit/c28882c1) tests: add missing test for rbd (Guillaume Abrioux)
* [c9c278de](https://github.com/ceph/ceph-ansible/commit/c9c278de) docs: update patterns containing version number (Guillaume Abrioux)
* [97b1cb02](https://github.com/ceph/ceph-ansible/commit/97b1cb02) tests: followup on testing against ansible2.4 (Guillaume Abrioux)
* [429622dd](https://github.com/ceph/ceph-ansible/commit/429622dd) docs add lvm bluestore examples (Alfredo Deza)
* [517a2b3f](https://github.com/ceph/ceph-ansible/commit/517a2b3f) ceph-osd skip lvm creation if they are already in use (Alfredo Deza)
* [c4ad2477](https://github.com/ceph/ceph-ansible/commit/c4ad2477) Test ansible 2.4.1 (Sébastien Han)
* [473673ab](https://github.com/ceph/ceph-ansible/commit/473673ab) shrink-mon: fix typo in the code doc (Sébastien Han)
* [d2575c7f](https://github.com/ceph/ceph-ansible/commit/d2575c7f) default: remove dup variable (Sébastien Han)
* [ae156e9f](https://github.com/ceph/ceph-ansible/commit/ae156e9f) Make acls and mode parameters of opentack_keys optional (John Fulton)
* [2837d0a2](https://github.com/ceph/ceph-ansible/commit/2837d0a2) purge: do not reboot by default (Sébastien Han)
* [ab587642](https://github.com/ceph/ceph-ansible/commit/ab587642) Docker image pull retry (Joe Talerico)
* [f73232ca](https://github.com/ceph/ceph-ansible/commit/f73232ca) Use check_mode instead of always_run (Major Hayden)
* [c2b5118c](https://github.com/ceph/ceph-ansible/commit/c2b5118c) Revert "Avoid deprecated always_run" (Major Hayden)
* [8670b45e](https://github.com/ceph/ceph-ansible/commit/8670b45e) rgw/nfs: fix section duplication (Sébastien Han)
* [7f6c3910](https://github.com/ceph/ceph-ansible/commit/7f6c3910) Option to set TCMALLOC_MAX_TOTAL_THREAD_CACHE_BYTES (Andy McCrae)
* [d3b427e1](https://github.com/ceph/ceph-ansible/commit/d3b427e1) ceph-osd lvm scnearios are no longer limited to filestore (Alfredo Deza)
* [df05e63c](https://github.com/ceph/ceph-ansible/commit/df05e63c) ceph-osd use --cluster in ceph-volume calls (Alfredo Deza)
* [628d98a9](https://github.com/ceph/ceph-ansible/commit/628d98a9) ceph-osd add the CEPH_VOLUME_DEBUG env var to all ceph-volume commands (Alfredo Deza)
* [f0364ba4](https://github.com/ceph/ceph-ansible/commit/f0364ba4) tests add the bluestore scenario in tox.ini (Alfredo Deza)
* [027d57dd](https://github.com/ceph/ceph-ansible/commit/027d57dd) tests create a bluestore osd scenario (Alfredo Deza)
* [f77180cf](https://github.com/ceph/ceph-ansible/commit/f77180cf) group_vars: update the examples in lvm for bluestore support (Alfredo Deza)
* [b89309e2](https://github.com/ceph/ceph-ansible/commit/b89309e2) ceph-osd update the examples in defaults for lvm bluestore (Alfredo Deza)
* [bbc36722](https://github.com/ceph/ceph-ansible/commit/bbc36722) ceph-osd: lvm support for bluestore (Alfredo Deza)
* [b6296c13](https://github.com/ceph/ceph-ansible/commit/b6296c13) update sample file (Yixing Yan)
* [f90f2f3a](https://github.com/ceph/ceph-ansible/commit/f90f2f3a) purge: containers are not stopped (Guillaume Abrioux)
* [7a7ddab6](https://github.com/ceph/ceph-ansible/commit/7a7ddab6) Require osd_scenario parameter to be provided in containerized deploy (John Fulton)
* [280de304](https://github.com/ceph/ceph-ansible/commit/280de304) tests: split purge_cluster, followup on a53aa9e (Guillaume Abrioux)
* [9ebef8ba](https://github.com/ceph/ceph-ansible/commit/9ebef8ba) Add regexp check for setting CLUSTER_NAME (Andy McCrae)
* [05a1f965](https://github.com/ceph/ceph-ansible/commit/05a1f965) Typo fix for radosgw@ systemd file (Andy McCrae)
* [291e6b60](https://github.com/ceph/ceph-ansible/commit/291e6b60) ceph-nfs - add bind address variable (Jan Provaznik)
* [968ef043](https://github.com/ceph/ceph-ansible/commit/968ef043) osd: bring backward compatibility with old Jewel images (Sébastien Han)
* [4413511b](https://github.com/ceph/ceph-ansible/commit/4413511b) all: backward compatibility between stable-2.2 and 3.0 (Sébastien Han)
* [fccb9472](https://github.com/ceph/ceph-ansible/commit/fccb9472) mgr: force module addition (Sébastien Han)
* [ba5c6e66](https://github.com/ceph/ceph-ansible/commit/ba5c6e66) common: move restapi template to config (Sébastien Han)
* [5b1087f1](https://github.com/ceph/ceph-ansible/commit/5b1087f1) mgr: play 'enable modules' sequence only on luminous (Guillaume Abrioux)
* [98232637](https://github.com/ceph/ceph-ansible/commit/98232637) upgrade: fix upgrade jewel to luminous for nfs nodes (Guillaume Abrioux)
* [70034451](https://github.com/ceph/ceph-ansible/commit/70034451) upgrade: fix upgrade jewel to luminous for mgr nodes (Guillaume Abrioux)
* [db6b93d4](https://github.com/ceph/ceph-ansible/commit/db6b93d4) tests: only test upgrade jewel > luminous (Guillaume Abrioux)
* [93f08567](https://github.com/ceph/ceph-ansible/commit/93f08567) tests: re-add missing param in tox (Guillaume Abrioux)
* [ff228e2d](https://github.com/ceph/ceph-ansible/commit/ff228e2d) mgr: fix broken task on jewel (Guillaume Abrioux)
* [c2850b11](https://github.com/ceph/ceph-ansible/commit/c2850b11) rbd: fix restart script for jewel (Guillaume Abrioux)
* [a53aa9e8](https://github.com/ceph/ceph-ansible/commit/a53aa9e8) ci: new osd scenarios (Sébastien Han)
* [90b75185](https://github.com/ceph/ceph-ansible/commit/90b75185) defaults: fix handlers for collocation (Sébastien Han)
* [c72ddee2](https://github.com/ceph/ceph-ansible/commit/c72ddee2) rpm: remove ability to install ceph community version (Sébastien Han)
* [4c380c9e](https://github.com/ceph/ceph-ansible/commit/4c380c9e) Cleanup readme files in roles directories (Christian Berendt)
* [9a1e789a](https://github.com/ceph/ceph-ansible/commit/9a1e789a) Add missing backticks in docs index (Christian Berendt)
* [61113848](https://github.com/ceph/ceph-ansible/commit/61113848) Do not set release/version in sphinx configuration (Christian Berendt)
* [d920d483](https://github.com/ceph/ceph-ansible/commit/d920d483) upgrade: support for rbd mirror and nfs (Sébastien Han)
* [39bf102b](https://github.com/ceph/ceph-ansible/commit/39bf102b) switch: nicer way to check mon quorum (Sébastien Han)
* [cf901f01](https://github.com/ceph/ceph-ansible/commit/cf901f01) In docker start scripts replace \u00a0 with \u0020 (Christian Berendt)
* [3a587575](https://github.com/ceph/ceph-ansible/commit/3a587575) Add ability to enable ceph mgr modules. (Fabien Brachere)
* [d5358bd2](https://github.com/ceph/ceph-ansible/commit/d5358bd2) contrib: galaxy fix the array (Sébastien Han)
* [ec042219](https://github.com/ceph/ceph-ansible/commit/ec042219) ceph-defaults: fix handlers that are always triggered (Guillaume Abrioux)
* [71d81962](https://github.com/ceph/ceph-ansible/commit/71d81962) mds: fix fs pool creation (Sébastien Han)
* [90ce4276](https://github.com/ceph/ceph-ansible/commit/90ce4276) ci: use a container client VM (Sébastien Han)
* [b34a04ea](https://github.com/ceph/ceph-ansible/commit/b34a04ea) site-docker.yml try to fetch images in // (Sébastien Han)
* [3e058bff](https://github.com/ceph/ceph-ansible/commit/3e058bff) ci: reboot with ansible instead of vagrant reload (Sébastien Han)
* [59ca1065](https://github.com/ceph/ceph-ansible/commit/59ca1065) rbd-mirror: enable ceph-rbd-mirror.target (Guillaume Abrioux)
* [a1c76e83](https://github.com/ceph/ceph-ansible/commit/a1c76e83) Simplify NTP checks/install (Major Hayden)
* [c233c874](https://github.com/ceph/ceph-ansible/commit/c233c874) Enable profile_tasks callback plugin (Major Hayden)
* [c0185132](https://github.com/ceph/ceph-ansible/commit/c0185132) Remove jinja2 delimiters from `when` keys (Major Hayden)
* [b49f9bda](https://github.com/ceph/ceph-ansible/commit/b49f9bda) mds: precisely define cephfs pool (Sébastien Han)
* [33b200d4](https://github.com/ceph/ceph-ansible/commit/33b200d4) Suppress yum/dnf/rpm command warnings (Major Hayden)
* [620fb37d](https://github.com/ceph/ceph-ansible/commit/620fb37d) Avoid deprecated always_run (Major Hayden)
* [a179e312](https://github.com/ceph/ceph-ansible/commit/a179e312) tests: add missing override for collocation scenario (Guillaume Abrioux)
* [13bce287](https://github.com/ceph/ceph-ansible/commit/13bce287) infra: replace osd playbook (Sébastien Han)
* [a2880e63](https://github.com/ceph/ceph-ansible/commit/a2880e63) tests: rbd/rgw adapt testinfra for jewel (Guillaume Abrioux)
* [9d626303](https://github.com/ceph/ceph-ansible/commit/9d626303) Pass list of packages instead of with_items (Major Hayden)
* [aa70b07a](https://github.com/ceph/ceph-ansible/commit/aa70b07a) config: proper render ceph.conf when doing collocation (Sébastien Han)
* [155dd362](https://github.com/ceph/ceph-ansible/commit/155dd362) contrib: backport auto create PR (Sébastien Han)
* [32625c5e](https://github.com/ceph/ceph-ansible/commit/32625c5e) contrib: backport auto create PR (Sébastien Han)
* [d0a9e57b](https://github.com/ceph/ceph-ansible/commit/d0a9e57b) osd: rollback bindmount of /run/udev (Sébastien Han)
* [85e13a86](https://github.com/ceph/ceph-ansible/commit/85e13a86) purge-iscsi: fix group name (Sébastien Han)
* [10e1d464](https://github.com/ceph/ceph-ansible/commit/10e1d464) Remove duplicate 'package' key (Major Hayden)