/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.output.Problem;
import java.io.PrintStream;

class TestResultProblem
implements Problem {
    private final TestResult testResult;
    private static String NEW_LINE = System.getProperty("line.separator");

    public TestResultProblem(TestResult testResult) {
        this.testResult = testResult;
    }

    public void print(PrintStream out, boolean verbose) {
        if (this.testResult.getResult() != TestResult.Result.passed) {
            this.printProblem(out, this.testResult);
        } else {
            this.printPassed(out, this.testResult);
        }
        if (!verbose && this.testResult.getLog().length() > 0) {
            this.printTestLog(out, this.testResult);
        }
    }

    private void printPassed(PrintStream out, TestResult testResult) {
        out.println(String.format("    %s.%s %s (%.2f ms)", new Object[]{testResult.getTestCaseName(), testResult.getTestName(), testResult.getResult(), Float.valueOf(testResult.getTime())}));
    }

    private void printProblem(PrintStream out, TestResult testResult) {
        StringBuilder formattedStack = new StringBuilder(NEW_LINE);
        for (String line : testResult.getStack().split(NEW_LINE)) {
            formattedStack.append("      ").append(line).append(NEW_LINE);
        }
        out.println(String.format("    %s.%s %s (%.2f ms): %s%s", new Object[]{testResult.getTestCaseName(), testResult.getTestName(), testResult.getResult(), Float.valueOf(testResult.getTime()), testResult.getParsedMessage(), formattedStack.toString()}));
    }

    private void printTestLog(PrintStream out, TestResult testResult) {
        String[] logLines;
        for (String line : logLines = testResult.getLog().split(NEW_LINE)) {
            out.println("      " + line);
        }
    }
}

