/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.PermissionCollection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.deployer.WebAppDeployer;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.log.Log;
import org.mortbay.resource.JarResource;
import org.mortbay.resource.Resource;
import org.mortbay.util.IO;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URIUtil;

public class WebAppContext
extends Context {
    public static final String WEB_DEFAULTS_XML = "org/mortbay/jetty/webapp/webdefault.xml";
    public static final String ERROR_PAGE = "org.mortbay.jetty.error_page";
    private static String[] __dftConfigurationClasses = new String[]{"org.mortbay.jetty.webapp.WebInfConfiguration", "org.mortbay.jetty.webapp.WebXmlConfiguration", "org.mortbay.jetty.webapp.JettyWebXmlConfiguration", "org.mortbay.jetty.webapp.TagLibConfiguration"};
    private String[] _configurationClasses = __dftConfigurationClasses;
    private Configuration[] _configurations;
    private String _defaultsDescriptor = "org/mortbay/jetty/webapp/webdefault.xml";
    private String _descriptor = null;
    private String _overrideDescriptor = null;
    private boolean _distributable = false;
    private boolean _extractWAR = true;
    private boolean _copyDir = false;
    private boolean _logUrlOnStart = false;
    private boolean _parentLoaderPriority = Boolean.getBoolean("org.mortbay.jetty.webapp.parentLoaderPriority");
    private PermissionCollection _permissions;
    private String[] _systemClasses = new String[]{"java.", "javax.servlet.", "javax.xml.", "org.mortbay.", "org.xml.", "org.w3c.", "org.apache.commons.logging.", "org.apache.log4j."};
    private String[] _serverClasses = new String[]{"-org.mortbay.jetty.plus.jaas.", "org.mortbay.jetty.", "org.slf4j."};
    private File _tmpDir;
    private boolean _isExistingTmpDir;
    private String _war;
    private String _extraClasspath;
    private Throwable _unavailableException;
    private transient Map _resourceAliases;
    private transient boolean _ownClassLoader = false;
    private transient boolean _unavailable;

    public static ContextHandler getCurrentWebAppContext() {
        ContextHandler handler;
        ContextHandler.SContext context = ContextHandler.getCurrentContext();
        if (context != null && (handler = context.getContextHandler()) instanceof WebAppContext) {
            return handler;
        }
        return null;
    }

    public static void addWebApplications(Server server, String webapps, String defaults, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        WebAppContext.addWebApplications(server, webapps, defaults, __dftConfigurationClasses, extract, java2CompliantClassLoader);
    }

    public static void addWebApplications(Server server, String webapps, String defaults, String[] configurations, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        HandlerCollection contexts = (HandlerCollection)server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)server.getChildHandlerByClass(HandlerCollection.class);
        }
        WebAppContext.addWebApplications(contexts, webapps, defaults, configurations, extract, java2CompliantClassLoader);
    }

    public static void addWebApplications(HandlerContainer contexts, String webapps, String defaults, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        WebAppContext.addWebApplications(contexts, webapps, defaults, __dftConfigurationClasses, extract, java2CompliantClassLoader);
    }

    public static void addWebApplications(HandlerContainer contexts, String webapps, String defaults, String[] configurations, boolean extract, boolean java2CompliantClassLoader) throws IOException {
        Log.warn("Deprecated configuration used for " + webapps);
        WebAppDeployer deployer = new WebAppDeployer();
        deployer.setContexts(contexts);
        deployer.setWebAppDir(webapps);
        deployer.setConfigurationClasses(configurations);
        deployer.setExtract(extract);
        deployer.setParentLoaderPriority(java2CompliantClassLoader);
        try {
            deployer.start();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public WebAppContext() {
        this(null, null, null, null);
    }

    public WebAppContext(String webApp, String contextPath) {
        super(null, contextPath, 3);
        this.setContextPath(contextPath);
        this.setWar(webApp);
        this.setErrorHandler(new ErrorPageErrorHandler());
    }

    public WebAppContext(HandlerContainer parent, String webApp, String contextPath) {
        super(parent, contextPath, 3);
        this.setWar(webApp);
        this.setErrorHandler(new ErrorPageErrorHandler());
    }

    public WebAppContext(SecurityHandler securityHandler, SessionHandler sessionHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        super(null, sessionHandler != null ? sessionHandler : new SessionHandler(), securityHandler != null ? securityHandler : new SecurityHandler(), servletHandler != null ? servletHandler : new ServletHandler(), null);
        this.setErrorHandler(errorHandler != null ? errorHandler : new ErrorPageErrorHandler());
    }

    public Throwable getUnavailableException() {
        return this._unavailableException;
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public Map getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases;
    }

    public void setResourceAliases(Map map) {
        this._resourceAliases = map;
    }

    public String getResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.get(alias);
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.remove(alias);
    }

    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        if (classLoader != null && classLoader instanceof WebAppClassLoader) {
            ((WebAppClassLoader)classLoader).setName(this.getDisplayName());
        }
    }

    public Resource getResource(String uriInContext) throws MalformedURLException {
        IOException ioe = null;
        Resource resource = null;
        int loop = 0;
        while (uriInContext != null && loop++ < 100) {
            try {
                resource = super.getResource(uriInContext);
                if (resource != null && resource.exists()) {
                    return resource;
                }
                uriInContext = this.getResourceAlias(uriInContext);
            }
            catch (IOException e) {
                Log.ignore(e);
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null && ioe instanceof MalformedURLException) {
            throw (MalformedURLException)ioe;
        }
        return resource;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this._unavailable) {
            response.sendError(503);
        } else {
            super.handle(target, request, response, dispatch);
        }
    }

    protected void doStart() throws Exception {
        try {
            File sentinel;
            int i;
            this.loadConfigurations();
            for (i = 0; i < this._configurations.length; ++i) {
                this._configurations[i].setWebAppContext(this);
            }
            this._ownClassLoader = false;
            if (this.getClassLoader() == null) {
                WebAppClassLoader classLoader = new WebAppClassLoader(this);
                this.setClassLoader(classLoader);
                this._ownClassLoader = true;
            }
            if (Log.isDebugEnabled()) {
                ClassLoader loader = this.getClassLoader();
                Log.debug("Thread Context class loader is: " + loader);
                for (loader = loader.getParent(); loader != null; loader = loader.getParent()) {
                    Log.debug("Parent class loader is: " + loader);
                }
            }
            for (i = 0; i < this._configurations.length; ++i) {
                this._configurations[i].configureClassLoader();
            }
            this.getTempDirectory();
            if (!(this._tmpDir == null || this._isExistingTmpDir || this.isTempWorkDirectory() || (sentinel = new File(this._tmpDir, ".active")).exists())) {
                sentinel.mkdir();
            }
            super.doStart();
            if (this.isLogUrlOnStart()) {
                this.dumpUrl();
            }
        }
        catch (Exception e) {
            Log.warn("Failed startup of context " + this, e);
            this._unavailableException = e;
            this._unavailable = true;
        }
    }

    public void dumpUrl() {
        Connector[] connectors = this.getServer().getConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            String connectorName = connectors[i].getName();
            String displayName = this.getDisplayName();
            if (displayName == null) {
                displayName = "WebApp@" + connectors.hashCode();
            }
            Log.info(displayName + " at http://" + connectorName + this.getContextPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        try {
            int i = this._configurations.length;
            while (i-- > 0) {
                this._configurations[i].deconfigureWebApp();
            }
            this._configurations = null;
            if (this._securityHandler.getHandler() == null) {
                this._sessionHandler.setHandler(this._securityHandler);
                this._securityHandler.setHandler(this._servletHandler);
            }
            if (this._tmpDir != null && !this._isExistingTmpDir && !this.isTempWorkDirectory()) {
                IO.delete(this._tmpDir);
                this._tmpDir = null;
            }
            Object var3_2 = null;
            if (this._ownClassLoader) {
                this.setClassLoader(null);
            }
            this._unavailable = false;
            this._unavailableException = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this._ownClassLoader) {
                this.setClassLoader(null);
            }
            this._unavailable = false;
            this._unavailableException = null;
            throw throwable;
        }
    }

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    public Configuration[] getConfigurations() {
        return this._configurations;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public String getOverrideDescriptor() {
        return this._overrideDescriptor;
    }

    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public String[] getServerClasses() {
        return this._serverClasses;
    }

    public String[] getSystemClasses() {
        return this._systemClasses;
    }

    public File getTempDirectory() {
        if (this._tmpDir != null && this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
            return this._tmpDir;
        }
        Object t = this.getAttribute("javax.servlet.context.tempdir");
        if (t != null && t instanceof File) {
            this._tmpDir = (File)t;
            if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                return this._tmpDir;
            }
        }
        if (t != null && t instanceof String) {
            try {
                this._tmpDir = new File((String)t);
                if (this._tmpDir.isDirectory() && this._tmpDir.canWrite()) {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Converted to File " + this._tmpDir + " for " + this);
                    }
                    this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
                    return this._tmpDir;
                }
            }
            catch (Exception e) {
                Log.warn("EXCEPTION ", e);
            }
        }
        File work = null;
        try {
            Resource web_inf;
            File w = new File(System.getProperty("jetty.home"), "work");
            if (w.exists() && w.canWrite() && w.isDirectory()) {
                work = w;
            } else if (this.getBaseResource() != null && (web_inf = this.getWebInf()) != null && web_inf.exists() && (w = new File(web_inf.getFile(), "work")).exists() && w.canWrite() && w.isDirectory()) {
                work = w;
            }
        }
        catch (Exception e) {
            Log.ignore(e);
        }
        try {
            String temp = this.getCanonicalNameForWebAppTmpDir();
            if (work != null) {
                this._tmpDir = new File(work, temp);
            } else {
                this._tmpDir = new File(System.getProperty("java.io.tmpdir"), temp);
                if (this._tmpDir.exists()) {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Delete existing temp dir " + this._tmpDir + " for " + this);
                    }
                    if (!IO.delete(this._tmpDir) && Log.isDebugEnabled()) {
                        Log.debug("Failed to delete temp dir " + this._tmpDir);
                    }
                    if (this._tmpDir.exists()) {
                        String old = this._tmpDir.toString();
                        this._tmpDir = File.createTempFile(temp + "_", "");
                        if (this._tmpDir.exists()) {
                            this._tmpDir.delete();
                        }
                        Log.warn("Can't reuse " + old + ", using " + this._tmpDir);
                    }
                }
            }
            if (!this._tmpDir.exists()) {
                this._tmpDir.mkdir();
            }
            if (!this.isTempWorkDirectory()) {
                this._tmpDir.deleteOnExit();
            }
            if (Log.isDebugEnabled()) {
                Log.debug("Created temp dir " + this._tmpDir + " for " + this);
            }
        }
        catch (Exception e) {
            this._tmpDir = null;
            Log.ignore(e);
        }
        if (this._tmpDir == null) {
            try {
                this._tmpDir = File.createTempFile("JettyContext", "");
                if (this._tmpDir.exists()) {
                    this._tmpDir.delete();
                }
                this._tmpDir.mkdir();
                this._tmpDir.deleteOnExit();
                if (Log.isDebugEnabled()) {
                    Log.debug("Created temp dir " + this._tmpDir + " for " + this);
                }
            }
            catch (IOException e) {
                Log.warn("tmpdir", e);
                System.exit(1);
            }
        }
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
        return this._tmpDir;
    }

    public boolean isTempWorkDirectory() {
        if (this._tmpDir == null) {
            return false;
        }
        if (this._tmpDir.getName().equalsIgnoreCase("work")) {
            return true;
        }
        File t = this._tmpDir.getParentFile();
        if (t == null) {
            return false;
        }
        return t.getName().equalsIgnoreCase("work");
    }

    public String getWar() {
        if (this._war == null) {
            this._war = this.getResourceBase();
        }
        return this._war;
    }

    public Resource getWebInf() throws IOException {
        this.resolveWebApp();
        Resource web_inf = super.getBaseResource().addPath("WEB-INF/");
        if (!web_inf.exists() || !web_inf.isDirectory()) {
            return null;
        }
        return web_inf;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public boolean isExtractWAR() {
        return this._extractWAR;
    }

    public boolean isCopyWebDir() {
        return this._copyDir;
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    protected void loadConfigurations() throws Exception {
        if (this._configurations != null) {
            return;
        }
        if (this._configurationClasses == null) {
            this._configurationClasses = __dftConfigurationClasses;
        }
        this._configurations = new Configuration[this._configurationClasses.length];
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i] = (Configuration)Loader.loadClass(this.getClass(), this._configurationClasses[i]).newInstance();
        }
    }

    protected boolean isProtectedTarget(String target) {
        while (target.startsWith("//")) {
            target = URIUtil.compactPath(target);
        }
        return StringUtil.startsWithIgnoreCase(target, "/web-inf") || StringUtil.startsWithIgnoreCase(target, "/meta-inf");
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + (this._war == null ? this.getResourceBase() : this._war) + "}";
    }

    protected void resolveWebApp() throws IOException {
        Resource web_app = super.getBaseResource();
        if (web_app == null) {
            Resource jarWebApp;
            if (this._war == null || this._war.length() == 0) {
                this._war = this.getResourceBase();
            }
            if ((web_app = Resource.newResource(this._war)).getAlias() != null) {
                Log.debug(web_app + " anti-aliased to " + web_app.getAlias());
                web_app = Resource.newResource(web_app.getAlias());
            }
            if (Log.isDebugEnabled()) {
                Log.debug("Try webapp=" + web_app + ", exists=" + web_app.exists() + ", directory=" + web_app.isDirectory());
            }
            if (web_app.exists() && !web_app.isDirectory() && !web_app.toString().startsWith("jar:") && (jarWebApp = Resource.newResource("jar:" + web_app + "!/")).exists() && jarWebApp.isDirectory()) {
                web_app = jarWebApp;
            }
            if (web_app.exists() && (this._copyDir && web_app.getFile() != null && web_app.getFile().isDirectory() || this._extractWAR && web_app.getFile() != null && !web_app.getFile().isDirectory() || this._extractWAR && web_app.getFile() == null || !web_app.isDirectory())) {
                File extractedWebAppDir = new File(this.getTempDirectory(), "webapp");
                if (web_app.getFile() != null && web_app.getFile().isDirectory()) {
                    Log.info("Copy " + web_app.getFile() + " to " + extractedWebAppDir);
                    IO.copyDir(web_app.getFile(), extractedWebAppDir);
                } else if (!extractedWebAppDir.exists()) {
                    extractedWebAppDir.mkdir();
                    Log.info("Extract " + this._war + " to " + extractedWebAppDir);
                    JarResource.extract(web_app, extractedWebAppDir, false);
                } else if (web_app.lastModified() > extractedWebAppDir.lastModified()) {
                    extractedWebAppDir.delete();
                    extractedWebAppDir.mkdir();
                    Log.info("Extract " + this._war + " to " + extractedWebAppDir);
                    JarResource.extract(web_app, extractedWebAppDir, false);
                }
                web_app = Resource.newResource(extractedWebAppDir.getCanonicalPath());
            }
            if (!web_app.exists() || !web_app.isDirectory()) {
                Log.warn("Web application not found " + this._war);
                throw new FileNotFoundException(this._war);
            }
            if (Log.isDebugEnabled()) {
                Log.debug("webapp=" + web_app);
            }
            super.setBaseResource(web_app);
        }
    }

    public void setConfigurationClasses(String[] configurations) {
        this._configurationClasses = configurations == null ? null : (String[])configurations.clone();
    }

    public void setConfigurations(Configuration[] configurations) {
        this._configurations = configurations == null ? null : (Configuration[])configurations.clone();
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public void setOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptor = overrideDescriptor;
    }

    public String getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        if (this._sessionHandler != null) {
            this._sessionHandler.clearEventListeners();
        }
        super.setEventListeners(eventListeners);
        for (int i = 0; eventListeners != null && i < eventListeners.length; ++i) {
            EventListener listener = eventListeners[i];
            if (!(listener instanceof HttpSessionActivationListener) && !(listener instanceof HttpSessionAttributeListener) && !(listener instanceof HttpSessionBindingListener) && !(listener instanceof HttpSessionListener) || this._sessionHandler == null) continue;
            this._sessionHandler.addEventListener(listener);
        }
    }

    public void addEventListener(EventListener listener) {
        this.setEventListeners((EventListener[])LazyList.addToArray(this.getEventListeners(), listener, EventListener.class));
    }

    public void setExtractWAR(boolean extractWAR) {
        this._extractWAR = extractWAR;
    }

    public void setCopyWebDir(boolean copy) {
        this._copyDir = copy;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this._parentLoaderPriority = java2compliant;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public void setServerClasses(String[] serverClasses) {
        this._serverClasses = serverClasses == null ? null : (String[])serverClasses.clone();
    }

    public void setSystemClasses(String[] systemClasses) {
        this._systemClasses = systemClasses == null ? null : (String[])systemClasses.clone();
    }

    public void setTempDirectory(File dir) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (dir != null) {
            try {
                dir = new File(dir.getCanonicalPath());
            }
            catch (IOException e) {
                Log.warn("EXCEPTION ", e);
            }
        }
        if (dir != null && !dir.exists()) {
            dir.mkdir();
            dir.deleteOnExit();
        } else if (dir != null) {
            this._isExistingTmpDir = true;
        }
        if (!(dir == null || dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad temp directory: " + dir);
        }
        this._tmpDir = dir;
        this.setAttribute("javax.servlet.context.tempdir", this._tmpDir);
    }

    public void setWar(String war) {
        this._war = war;
    }

    public String getExtraClasspath() {
        return this._extraClasspath;
    }

    public void setExtraClasspath(String extraClasspath) {
        this._extraClasspath = extraClasspath;
    }

    public boolean isLogUrlOnStart() {
        return this._logUrlOnStart;
    }

    public void setLogUrlOnStart(boolean logOnStart) {
        this._logUrlOnStart = logOnStart;
    }

    protected void startContext() throws Exception {
        Resource work;
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureDefaults();
        }
        Resource web_inf = this.getWebInf();
        if (web_inf != null && (work = web_inf.addPath("work")).exists() && work.isDirectory() && work.getFile() != null && work.getFile().canWrite() && this.getAttribute("javax.servlet.context.tempdir") == null) {
            this.setAttribute("javax.servlet.context.tempdir", work.getFile());
        }
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].configureWebApp();
        }
        super.startContext();
    }

    private String getCanonicalNameForWebAppTmpDir() {
        int port;
        String host;
        StringBuffer canonicalName = new StringBuffer();
        canonicalName.append("Jetty");
        Connector[] connectors = this.getServer().getConnectors();
        canonicalName.append("_");
        String string = host = connectors == null || connectors[0] == null ? "" : connectors[0].getHost();
        if (host == null) {
            host = "0.0.0.0";
        }
        canonicalName.append(host.replace('.', '_'));
        canonicalName.append("_");
        int n = port = connectors == null || connectors[0] == null ? 0 : connectors[0].getLocalPort();
        if (port < 0) {
            port = connectors[0].getPort();
        }
        canonicalName.append(port);
        canonicalName.append("_");
        try {
            String tmp;
            Resource resource = super.getBaseResource();
            if (resource == null) {
                if (this._war == null || this._war.length() == 0) {
                    resource = Resource.newResource(this.getResourceBase());
                }
                resource = Resource.newResource(this._war);
            }
            if ((tmp = URIUtil.decodePath(resource.getURL().getPath())).endsWith("/")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            if (tmp.endsWith("!")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            int i = tmp.lastIndexOf("/");
            canonicalName.append(tmp.substring(i + 1, tmp.length()));
        }
        catch (Exception e) {
            Log.warn("Can't generate resourceBase as part of webapp tmp dir name", e);
        }
        canonicalName.append("_");
        String contextPath = this.getContextPath();
        contextPath = contextPath.replace('/', '_');
        contextPath = contextPath.replace('\\', '_');
        canonicalName.append(contextPath);
        canonicalName.append("_");
        String[] vhosts = this.getVirtualHosts();
        canonicalName.append(vhosts == null || vhosts[0] == null ? "" : vhosts[0]);
        String hash = Integer.toString(canonicalName.toString().hashCode(), 36);
        canonicalName.append("_");
        canonicalName.append(hash);
        for (int i = 0; i < canonicalName.length(); ++i) {
            char c = canonicalName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            canonicalName.setCharAt(i, '.');
        }
        return canonicalName.toString();
    }
}

