/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.JoinUtil;
import com.metamatrix.query.optimizer.relational.rules.QueryFrame;
import com.metamatrix.query.optimizer.relational.rules.RulePlaceAccess;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleMergeVirtual
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        LinkedList frames = new LinkedList();
        FrameUtil.findQueryFrames(plan, null, frames);
        while (frames.size() > 1) {
            QueryFrame frame = (QueryFrame)frames.removeFirst();
            if (!RuleMergeVirtual.canMerge(frame, metadata, capFinder)) continue;
            RuleMergeVirtual.doMerge(frame, metadata, capFinder);
        }
        return plan;
    }

    static boolean canMerge(QueryFrame frame, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode parentProject;
        PlanNode projectNode;
        List selectSymbols;
        List sourceNodes;
        QueryFrame parentFrame = frame.getParentFrame();
        if (parentFrame == null) {
            return false;
        }
        PlanNode aNode = frame.getTopNode();
        if (aNode.getType() == 19) {
            aNode = aNode.getFirstChild();
        }
        if ((sourceNodes = NodeEditor.findAllNodes((PlanNode)aNode, (int)19)).size() == 0) {
            return false;
        }
        LinkedList nodes = new LinkedList();
        nodes.addAll(frame.getTopNode().getChildren());
        while (!nodes.isEmpty()) {
            PlanNode node = (PlanNode)nodes.removeFirst();
            int type = node.getType();
            if (type == 23) {
                return false;
            }
            if (type == 13) {
                if (node.hasBooleanProperty((Object)NodeConstants.Info.IS_HAVING)) {
                    return false;
                }
                if (parentFrame.hasJoin()) {
                    PlanNode critRoot;
                    for (critRoot = node; critRoot != null && critRoot.getParent() != parentFrame.getJoinNode(); critRoot = critRoot.getParent()) {
                    }
                    JoinType jt = JoinUtil.getJoinTypePreventingCriteriaOptimization((PlanNode)parentFrame.getJoinNode(), (PlanNode)critRoot);
                    if (jt != null && (jt == JoinType.JOIN_FULL_OUTER || node.getGroups().size() == 0)) {
                        return false;
                    }
                }
            } else if (type == 11) {
                selectSymbols = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                for (SingleElementSymbol symbol : selectSymbols) {
                    PlanNode pNode;
                    if (symbol instanceof AggregateSymbol) {
                        return false;
                    }
                    Collection scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)symbol);
                    Collection functions = FunctionCollectorVisitor.getFunctions((LanguageObject)symbol, (boolean)true, (boolean)true);
                    boolean nonDeterministic = false;
                    for (Function func : functions) {
                        if (func.getFunctionDescriptor().getDeterministic() < 4) continue;
                        nonDeterministic = true;
                        break;
                    }
                    if (!nonDeterministic && scalarSubqueries.isEmpty() || !RuleMergeVirtual.willEvaluationChange(symbol, pNode = frame.getTopNode())) continue;
                    return false;
                }
            }
            if (type == 19) continue;
            nodes.addAll(node.getChildren());
        }
        if (frame.getTopNode().getLastChild().getType() != 11) {
            return false;
        }
        if (frame.hasJoin() && parentFrame.hasJoin()) {
            PlanNode currentNode = frame.getJoinNode().getParent();
            while (currentNode.getType() == 13) {
                currentNode = currentNode.getParent();
            }
            if (currentNode.getType() != 11) {
                return false;
            }
            if ((currentNode = currentNode.getParent()).getType() != 19) {
                return false;
            }
            while (currentNode != null) {
                currentNode = currentNode.getParent();
                while (currentNode.getType() == 13) {
                    currentNode = currentNode.getParent();
                }
                if (currentNode != parentFrame.getJoinNode()) continue;
            }
            if (currentNode == null) {
                return false;
            }
        }
        if (FrameUtil.isProcedure(projectNode = frame.getTopNode().getFirstChild())) {
            return false;
        }
        if (frame.getTopNode().getType() == 19) {
            if (!FrameUtil.canConvertAccessPatterns(frame.getTopNode())) {
                return false;
            }
            Set groups = frame.getTopNode().getGroups();
            if (groups.size() == 1 && ((GroupSymbol)groups.iterator().next()).isProcedure()) {
                return false;
            }
        }
        if ((parentProject = parentFrame.getTopNode()).getType() == 11 && parentProject.getProperty((Object)NodeConstants.Info.INTO_GROUP) != null) {
            return false;
        }
        if (parentFrame.hasJoin() && RuleMergeVirtual.checkForProjectedExpressions(aNode, parentFrame)) {
            return false;
        }
        selectSymbols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        for (SingleElementSymbol symbol : selectSymbols) {
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            if (!(symbol instanceof ExpressionSymbol)) continue;
            for (PlanNode node = frame.getTopNode().getParent(); node != null && !node.equals(parentFrame.getTopNode()); node = node.getParent()) {
                if (node.getType() != 23) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean willEvaluationChange(SingleElementSymbol symbol, PlanNode pNode) {
        GroupSymbol group = (GroupSymbol)pNode.getGroups().iterator().next();
        pNode = pNode.getParent();
        boolean inJoin = false;
        while (pNode != null && pNode.getType() != 19) {
            PlanNode current = pNode;
            pNode = current.getParent();
            List refs = (List)current.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
            if (refs != null) {
                for (Reference ref : refs) {
                    Expression expr = ref.getExpression();
                    boolean REMOVE_DUPLICATES = true;
                    for (ElementSymbol element : ElementCollectorVisitor.getElements((LanguageObject)expr, (boolean)true)) {
                        if (!group.equals((Object)element.getGroupSymbol()) || !element.getShortName().equalsIgnoreCase(symbol.getName())) continue;
                        return true;
                    }
                }
            }
            List objects = null;
            if (!current.getGroups().contains(group)) continue;
            if (current.getType() == 13) {
                objects = new ArrayList<Object>();
                objects.add(current.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA));
            } else if (current.getType() == 11) {
                objects = (List)current.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
            } else if (current.getType() == 7) {
                objects = (List)current.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                inJoin = true;
            } else if (current.getType() == 17) {
                objects = (List)current.getProperty((Object)NodeConstants.Info.SORT_ORDER);
            } else if (current.getType() == 23) {
                objects = (List)current.getProperty((Object)NodeConstants.Info.GROUP_COLS);
            }
            if (objects == null) continue;
            boolean alreadySeen = false;
            for (int i = 0; i < objects.size(); ++i) {
                LanguageObject languageObject = (LanguageObject)objects.get(i);
                boolean REMOVE_DUPLICATES = true;
                for (ElementSymbol element : ElementCollectorVisitor.getElements((LanguageObject)languageObject, (boolean)true)) {
                    PlanNode source;
                    if (!group.equals((Object)element.getGroupSymbol()) || !element.getShortName().equalsIgnoreCase(symbol.getName())) continue;
                    if (current.getType() != 11) {
                        return true;
                    }
                    for (source = current.getParent(); source != null; source = source.getParent()) {
                        if (source.getType() == 5) {
                            return true;
                        }
                        if (source.getType() == 29) {
                            if (!source.hasBooleanProperty((Object)NodeConstants.Info.USE_ALL)) continue;
                            return true;
                        }
                        if (source.getType() != 19) continue;
                        if (!RuleMergeVirtual.willEvaluationChange((SingleElementSymbol)languageObject, source)) break;
                        if (alreadySeen || inJoin) {
                            return true;
                        }
                        alreadySeen = true;
                        break;
                    }
                    if (source != null || !inJoin) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkForProjectedExpressions(PlanNode currentNode, QueryFrame parentFrame) {
        PlanNode joinNode = parentFrame.getJoinNode();
        JoinType joinType = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (!joinType.isOuter()) {
            return false;
        }
        while (currentNode != null && currentNode != joinNode && currentNode.getType() != 11) {
            currentNode = currentNode.getParent();
        }
        if (currentNode.getType() != 11) {
            return false;
        }
        PlanNode pNode = currentNode;
        List projectedCols = (List)pNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        boolean projectingLiteral = false;
        for (SingleElementSymbol symbol : projectedCols) {
            if (ElementCollectorVisitor.getElements((LanguageObject)symbol, (boolean)false).size() != 0) continue;
            projectingLiteral = true;
            break;
        }
        if (!projectingLiteral) {
            return false;
        }
        if (joinType == JoinType.JOIN_FULL_OUTER) {
            return true;
        }
        while (currentNode.getParent() != joinNode) {
            currentNode = currentNode.getParent();
        }
        return joinType == JoinType.JOIN_LEFT_OUTER && joinNode.getLastChild() == currentNode;
    }

    static Set getFrameGroups(QueryFrame frame) {
        HashSet groups = new HashSet();
        List bottomNodes = frame.getBottomNodes();
        for (PlanNode node : bottomNodes) {
            groups.addAll(node.getGroups());
        }
        return groups;
    }

    static void doMerge(QueryFrame frame, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode topNode = frame.getTopNode();
        GroupSymbol oldGroup = (GroupSymbol)topNode.getGroups().iterator().next();
        QueryFrame parentFrame = frame.getParentFrame();
        Map symbolMap = (Map)topNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        RuleMergeVirtual.handleOverlappingGroups(frame, metadata);
        FrameUtil.convertFrame(parentFrame, topNode, oldGroup, null, symbolMap, metadata);
        PlanNode projectNode = topNode.getLastChild();
        PlanNode parentBottom = topNode.getParent();
        RuleMergeVirtual.copyProjectSubqueryProps(projectNode, parentBottom);
        PlanNode newRoot = FrameUtil.findJoinSourceNode(projectNode.getFirstChild());
        Collection ap = (Collection)topNode.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
        if (ap != null) {
            Collection newAp = (Collection)newRoot.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
            if (newAp == null) {
                newRoot.setProperty((Object)NodeConstants.Info.ACCESS_PATTERNS, (Object)ap);
            } else {
                newAp.addAll(ap);
            }
        }
        RulePlaceAccess.copyDependentHints((PlanNode)topNode, (PlanNode)newRoot);
        if (parentFrame.hasJoin()) {
            PlanNode upperJoin;
            for (upperJoin = newRoot.getParent(); upperJoin != parentFrame.getJoinNode(); upperJoin = upperJoin.getParent()) {
                if (upperJoin.getType() != 7) continue;
                upperJoin.addGroups((Collection)newRoot.getGroups());
            }
            upperJoin.addGroups((Collection)newRoot.getGroups());
        }
        NodeEditor.removeChildNode((PlanNode)parentBottom, (PlanNode)topNode);
        NodeEditor.removeChildNode((PlanNode)parentBottom, (PlanNode)projectNode);
        List parentBottomNodes = parentFrame.getBottomNodes();
        parentBottomNodes.remove(frame.getTopNode());
        parentBottomNodes.addAll(frame.getBottomNodes());
        if (!parentFrame.hasJoin()) {
            parentFrame.setJoinNode(frame.getJoinNode());
        }
    }

    private static void copyProjectSubqueryProps(PlanNode projectNode, PlanNode parentProject) {
        List correlatedReferences;
        List subqueryPlans = (List)projectNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
        if (subqueryPlans != null) {
            List subqueryValueProviders = (List)projectNode.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
            while (parentProject.getType() != 11) {
                parentProject = parentProject.getParent();
                Assertion.isNotNull((Object)parentProject);
            }
            RuleMergeVirtual.addListValuesToNode(subqueryPlans, parentProject, NodeConstants.Info.SUBQUERY_PLANS);
            RuleMergeVirtual.addListValuesToNode(subqueryValueProviders, parentProject, NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
        }
        if ((correlatedReferences = (List)projectNode.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES)) != null) {
            RuleMergeVirtual.addListValuesToNode(correlatedReferences, parentProject, NodeConstants.Info.CORRELATED_REFERENCES);
        }
    }

    private static void addListValuesToNode(List values, PlanNode node, Integer propKey) {
        if (values != null) {
            List nodeValues = (List)node.getProperty((Object)propKey);
            if (nodeValues == null) {
                node.setProperty((Object)propKey, (Object)values);
            } else {
                nodeValues.addAll(values);
            }
        }
    }

    static void handleOverlappingGroups(QueryFrame frame, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        QueryFrame parentFrame = frame.getParentFrame();
        List overlappingGroups = RuleMergeVirtual.getOverlappingGroups(frame);
        if (overlappingGroups != null) {
            Set bothFrameGroups = RuleMergeVirtual.getFrameGroups(parentFrame);
            bothFrameGroups.addAll(RuleMergeVirtual.getFrameGroups(frame));
            HashSet<String> allGroupNames = new HashSet<String>();
            for (GroupSymbol frameGroup : bothFrameGroups) {
                allGroupNames.add(frameGroup.getName());
            }
            for (GroupSymbol overlapGroup : overlappingGroups) {
                GroupSymbol renamedSymbol = FrameUtil.recontextSymbol(overlapGroup, allGroupNames);
                allGroupNames.add(renamedSymbol.getName());
                Map tempSymbolMap = FrameUtil.buildSymbolMap(overlapGroup, renamedSymbol, metadata);
                PlanNode siblingNode = null;
                for (PlanNode bottomNode : parentFrame.getBottomNodes()) {
                    if (!bottomNode.getGroups().contains(overlapGroup)) continue;
                    siblingNode = bottomNode;
                    break;
                }
                FrameUtil.convertFrame(parentFrame, siblingNode, overlapGroup, renamedSymbol, tempSymbolMap, metadata);
                Map siblingSymbolMap = (Map)siblingNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                if (siblingSymbolMap == null) continue;
                HashMap convertedMap = new HashMap();
                for (Object key : siblingSymbolMap.keySet()) {
                    Object value = siblingSymbolMap.get(key);
                    Object newKey = tempSymbolMap.get(key);
                    if (newKey == null) {
                        convertedMap.put(key, value);
                        continue;
                    }
                    convertedMap.put(newKey, value);
                }
                siblingNode.setProperty((Object)NodeConstants.Info.SYMBOL_MAP, convertedMap);
            }
        }
    }

    static List getOverlappingGroups(QueryFrame frame) {
        GroupSymbol frameSymbol = (GroupSymbol)frame.getTopNode().getGroups().iterator().next();
        Set lowerGroups = RuleMergeVirtual.getFrameGroups(frame);
        Set upperGroups = RuleMergeVirtual.getFrameGroups(frame.getParentFrame());
        return FrameUtil.getOverlappingGroups(frameSymbol, lowerGroups, upperGroups);
    }

    public String toString() {
        return "MergeVirtual";
    }
}

