/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.util;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.StartupStateController;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.net.SocketHelper;
import com.metamatrix.common.util.NetUtils;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.persistence.impl.file.FilePersistentUtil;
import com.metamatrix.platform.security.session.spi.SessionTransaction;
import com.metamatrix.platform.util.MetaMatrixController;
import com.metamatrix.platform.util.VDBDeleteUtility;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class MetaMatrixController {
    private static Configuration currentConfig;
    private static boolean loggingEnabled;
    public static final String LOGON_API = "com.metamatrix.platform.security.api.LogonAPIHome";
    private static final int WAIT_TIME = 5000;

    public static void startServer(boolean forceStartup) throws Exception {
        boolean cleanupSessions = true;
        MetaMatrixController.doStartServer(forceStartup, cleanupSessions);
    }

    public static void startServer(boolean forceStartup, boolean cleanupSessions) throws Exception {
        MetaMatrixController.doStartServer(forceStartup, cleanupSessions);
    }

    private static synchronized void doStartServer(boolean forceStartup, boolean cleanupSessions) throws Exception {
        String command = "StartAllVMs\n";
        String error = null;
        MetaMatrixController.log("Copying NextStartup configuration to Startup configuration.", true);
        StartupStateController.performSystemInitialization((boolean)forceStartup);
        MetaMatrixController.refreshConfiguration();
        MetaMatrixController.saveCurrentConfigurationToFile();
        MetaMatrixController.initLicensing();
        if (cleanupSessions) {
            MetaMatrixController.cleanupSessions();
        }
        for (Host host : MetaMatrixController.getCurrentConfiguration().getHosts()) {
            try {
                MetaMatrixController.canHostBestarted(host);
                MetaMatrixController.log("Starting up processes on " + host.getName(), true);
                MetaMatrixController.sendCommand(host, command);
            }
            catch (Exception e) {
                if (error == null) {
                    error = "System may not have started correctly, error connecting to the following host(s): ";
                }
                error = error + host.getName() + " ";
            }
        }
        if (error != null) {
            MetaMatrixController.log(error, true);
        }
    }

    public static synchronized void killServer() throws Exception {
        String command = "KillAllVMs\n";
        String error = null;
        MetaMatrixController.refreshConfiguration();
        Iterator hostIter = MetaMatrixController.getCurrentConfiguration().getHosts().iterator();
        StartupStateController.indicateSystemShutdown();
        while (hostIter.hasNext()) {
            Host host = (Host)hostIter.next();
            try {
                Integer port = new Integer(host.getPort());
                if (NetUtils.ping((String)host.getHostAddress(), (int)port)) {
                    MetaMatrixController.log("Killing all processes on " + host.getHostAddress());
                    MetaMatrixController.sendCommand(host, command);
                    continue;
                }
                MetaMatrixController.log("Host " + host.getHostAddress() + " is not alive to kill processes.");
            }
            catch (Exception e) {
                if (error == null) {
                    error = "System may not have shutdown correctly, error connecting to the following host(s): ";
                }
                error = error + host.getHostAddress() + " ";
            }
        }
        if (error != null) {
            MetaMatrixController.log(error, true);
        }
    }

    public static synchronized void startProcess(String hostName, String process) throws Exception {
        if (hostName == null || hostName.length() == 0) {
            throw new IllegalArgumentException("hostName must not be null or empty");
        }
        if (process == null || process.length() == 0) {
            throw new IllegalArgumentException("process must not be null or empty");
        }
        MetaMatrixController.refreshConfiguration();
        Host host = MetaMatrixController.getHost(hostName);
        String command = "StartVM " + process + "\n";
        try {
            Collection vms = currentConfig.getVMsForHost((HostID)host.getID());
            Iterator vmIter = vms.iterator();
            VMComponentDefn vmDefn = null;
            while (vmIter.hasNext() && !(vmDefn = (VMComponentDefn)vmIter.next()).getName().equalsIgnoreCase(process)) {
                vmDefn = null;
            }
            if (vmDefn == null) {
                String msg = "Process " + process + "on host " + hostName + " not found: Must be deployed to start.";
                throw new Exception(msg);
            }
        }
        catch (Exception e) {
            MetaMatrixController.log("Error reading configuration.");
            throw e;
        }
        MetaMatrixController.log("Starting process " + process + " on " + host);
        MetaMatrixController.sendCommand(host, command);
    }

    public static synchronized void killProcess(String hostName, String process) throws Exception {
        if (hostName == null || hostName.length() == 0) {
            throw new IllegalArgumentException("hostName must not be null or empty");
        }
        if (process == null || process.length() == 0) {
            throw new IllegalArgumentException("process must not be null or empty");
        }
        MetaMatrixController.refreshConfiguration();
        Host host = MetaMatrixController.getHost(hostName);
        String command = "KillVM " + process + "\n";
        MetaMatrixController.log("Killing process " + process + " on " + hostName);
        MetaMatrixController.sendCommand(host, command);
    }

    public static synchronized void startHost(String host) throws Exception {
        MetaMatrixController.refreshConfiguration();
        Host h = MetaMatrixController.getHost(host);
        MetaMatrixController.canHostBestarted(h);
        String command = "StartAllVMs\n";
        MetaMatrixController.log("Starting all processes on " + host);
        MetaMatrixController.sendCommand(h, command);
    }

    protected static void canHostBestarted(Host host) throws Exception {
        int retries = 5;
        if (host == null) {
            String msg = PlatformPlugin.Util.getString("MetaMatrixController.Host_not_defined_in_configuration", (Object)"Unknown Host");
            PlatformPlugin.Util.log(4, msg);
            throw new MetaMatrixException(msg);
        }
        int cnt = 0;
        do {
            boolean isAlive;
            Integer port = new Integer(host.getPort());
            try {
                isAlive = NetUtils.ping((String)host.getHostAddress(), (int)port);
            }
            catch (Exception e) {
                PlatformPlugin.Util.log(4, "Unable to ping bindaddress: " + host.getHostAddress());
                continue;
            }
            if (isAlive) {
                Collection vms = currentConfig.getVMsForHost((HostID)host.getID());
                if (vms == null || vms.size() == 0) {
                    String msg = PlatformPlugin.Util.getString("MetaMatrixController.No_VMS_setup_for_host", (Object)host.getFullName());
                    PlatformPlugin.Util.log(2, msg);
                    throw new MetaMatrixException(msg);
                }
                return;
            }
            Thread.sleep(5000L);
            ++cnt;
        } while (cnt <= 5);
        String msg = PlatformPlugin.Util.getString("MetaMatrixController.Host_is_not_running", new Object[]{host.getFullName(), host.getPort()});
        PlatformPlugin.Util.log(2, msg);
        throw new MetaMatrixException(msg);
    }

    public static synchronized void killHost(String host) throws Exception {
        MetaMatrixController.refreshConfiguration();
        Host h = MetaMatrixController.getHost(host);
        String command = "KillAllVMs\n";
        MetaMatrixController.log("Stopping all processes on " + host);
        MetaMatrixController.sendCommand(h, command);
    }

    public static synchronized void killHostController(String host) throws Exception {
        Host h = MetaMatrixController.getHost(host);
        String command = "Exit\n";
        MetaMatrixController.log("Killing HostController on " + host);
        MetaMatrixController.sendCommand(h, command);
    }

    public static synchronized boolean pingHostController(String host) throws Exception {
        boolean hostAlive = true;
        MetaMatrixController.refreshConfiguration();
        Host h = MetaMatrixController.getHost(host);
        String command = "Ping\n";
        MetaMatrixController.log("Pinging " + host);
        try {
            MetaMatrixController.sendCommand(h, command);
            MetaMatrixController.log(host + " is alive at address " + h.getHostAddress());
        }
        catch (Exception e) {
            System.out.println(host + " is not listening at address " + h.getHostAddress());
            hostAlive = false;
        }
        return hostAlive;
    }

    private static synchronized void initLicensing() throws Exception {
        1 notifier = new /* Unavailable Anonymous Inner Class!! */;
        LicenseChecker.registerNotifier((LicenseChecker.Notifier)notifier);
        LicenseChecker.loadLicense((ClassLoader)MetaMatrixController.getCurrentConfiguration().getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupSessions() {
        Properties sessionProps = null;
        try {
            sessionProps = CurrentConfiguration.getResourceProperties("SessionService");
        }
        catch (ConfigurationException e) {
            MetaMatrixController.log((Exception)((Object)e), "WARNING: Coudln't get resource properties. Old active sessions will not be terminated.", true);
            return;
        }
        sessionProps = PropertiesUtils.clone((Properties)sessionProps, (boolean)false);
        sessionProps.setProperty("metamatrix.common.connection.transaction.factory", sessionProps.getProperty("security.session.connection.Factory"));
        SessionTransaction sessionTrans = null;
        try {
            TransactionMgr transMgr = new TransactionMgr(sessionProps, "MetaMatrixController");
            sessionTrans = (SessionTransaction)transMgr.getWriteTransaction();
            sessionTrans.terminateActiveSessions();
            sessionTrans.commit();
        }
        catch (Exception e) {
            MetaMatrixController.log(e, "WARNING: Failed to terminate old active sessions.", true);
            try {
                sessionTrans.rollback();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            if (sessionTrans != null) {
                try {
                    sessionTrans.close();
                }
                catch (Exception ex) {}
            }
            sessionTrans = null;
        }
        try {
            String classname = "com.metamatrix.metadata.runtime.StartupVDBDeleteUtility";
            VDBDeleteUtility vdbDeleter = (VDBDeleteUtility)ReflectionHelper.create((String)classname, null, (ClassLoader)MetaMatrixController.class.getClassLoader());
            vdbDeleter.deleteVDBsMarkedForDelete();
        }
        catch (Exception e) {
            MetaMatrixController.log(e, "Warning: failed to delete VDBs that were marked for deletion.");
        }
    }

    private static synchronized void refreshConfiguration() throws Exception {
        currentConfig = CurrentConfiguration.getConfiguration(true);
    }

    private static synchronized Configuration getCurrentConfiguration() throws Exception {
        if (currentConfig == null) {
            CurrentConfiguration.verifyBootstrapProperties();
            currentConfig = CurrentConfiguration.getConfiguration();
        }
        return currentConfig;
    }

    private static void saveCurrentConfigurationToFile() throws Exception {
        File f;
        String installDir = null;
        Host host = CurrentConfiguration.getHost();
        if (host != null) {
            installDir = host.getProperty("metamatrix.installationDir");
        }
        if (installDir == null || installDir.length() == 0) {
            installDir = "./";
        }
        if (!(f = new File(installDir = FileUtils.buildDirectoryPath((String[])new String[]{installDir, "config"}))).exists()) {
            installDir = "." + File.separator;
        }
        FilePersistentUtil.writeModel((String)"config_ns.xml", (String)installDir, (ConfigurationModelContainer)CurrentConfiguration.getConfigurationModel(), (String)"MetaMatrixController");
    }

    private static void sendCommand(Host host, String command) throws Exception {
        MetaMatrixController.log("Sending command to " + host.getHostAddress() + " command: " + command);
        Socket socket = null;
        FilterOutputStream out = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(host.getHostAddress());
            int port = Integer.parseInt(host.getPort());
            socket = SocketHelper.getInternalClientSocket((InetAddress)inetAddress, (int)port, (boolean)false);
            out = new DataOutputStream(socket.getOutputStream());
            out.write(command.getBytes());
        }
        catch (Exception e) {
            MetaMatrixController.log(e, "Error communicating with host controller on " + host);
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private static void log(String msg, boolean enabled) {
        if (enabled) {
            System.out.println(new Date(System.currentTimeMillis()) + " : " + msg);
        }
    }

    private static void log(String msg) {
        MetaMatrixController.log(msg, loggingEnabled);
    }

    private static void log(Exception e, String msg) {
        if (loggingEnabled) {
            System.out.println(new Date(System.currentTimeMillis()) + " : " + msg);
            e.printStackTrace();
        }
    }

    private static void log(Exception e, String msg, boolean logAnyway) {
        if (loggingEnabled || logAnyway) {
            System.out.println(new Date(System.currentTimeMillis()) + " : " + msg);
            e.printStackTrace();
        }
    }

    private static void enableLogging() {
        System.setErr(System.out);
        loggingEnabled = true;
    }

    private static void disableLogging() {
        loggingEnabled = false;
        System.setErr(System.err);
    }

    private static Host getHost(String hostName) throws Exception {
        Host host = CurrentConfiguration.findHost(hostName);
        if (host == null) {
            String msg = PlatformPlugin.Util.getString("MetaMatrixController.Host_not_defined_in_configuration", (Object)hostName);
            PlatformPlugin.Util.log(4, msg);
            throw new MetaMatrixException(msg);
        }
        return host;
    }

    private static void printUsage() {
        String msg = "java com.metamatrix.platform.util.MetaMatrixController <command> [param] [param]\nWhere command can be:\n                  startServer <-force>\n                  startHost -config <hostName>\n                  startHost <hostName> (deprecated)\n                  startProcess -config <hostName> <vmName>\n                  startProcess <hostName> <vmName> (deprecated)\n                  killServer\n                  killHost <hostName> (deprecated)\n                  killHost -config <hostName>\n                  killHostController -config <hostName>\n                  killHostController <hostName> (deprecated)\n                  killProcess -config <hostName> <vmName>\n                  killProcess <hostName> <vmName> (deprecated)\n                  ping -config <hostName>\n                  ping <hostName> (deprecated)\n\n Note: -force indicates server should be started regardless of current state";
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] vars) {
        String command = null;
        String host = null;
        try {
            host = NetUtils.getHostname();
        }
        catch (UnknownHostException e) {
            host = "localhost";
        }
        String process = null;
        int idx = 0;
        if (vars.length == 0) {
            MetaMatrixController.printUsage();
            System.exit(1);
        }
        if (vars.length > idx) {
            command = vars[idx];
            if (vars.length > ++idx) {
                String value = vars[idx];
                ++idx;
                if (value.equalsIgnoreCase("-config")) {
                    if (vars.length == idx) {
                        MetaMatrixController.printUsage();
                        System.exit(1);
                    }
                    host = vars[idx];
                    ++idx;
                } else {
                    host = value;
                }
                if (vars.length > idx) {
                    process = vars[idx];
                }
            }
        }
        MetaMatrixController.enableLogging();
        try {
            if (command.equalsIgnoreCase("killServer")) {
                MetaMatrixController.killServer();
                System.exit(0);
            }
            if (command.equalsIgnoreCase("startServer")) {
                boolean force = false;
                if (host != null && host.equalsIgnoreCase("-force")) {
                    force = true;
                }
                MetaMatrixController.startServer(force);
                System.exit(0);
            }
            if (host == null) {
                MetaMatrixController.printUsage();
                System.exit(1);
            }
            if (command.equalsIgnoreCase("killHost")) {
                MetaMatrixController.killHost(host);
                System.exit(0);
            }
            if (command.equalsIgnoreCase("killHostController")) {
                MetaMatrixController.killHostController(host);
                System.exit(0);
            }
            if (command.equalsIgnoreCase("startHost")) {
                MetaMatrixController.startHost(host);
                System.exit(0);
            }
            if (command.equalsIgnoreCase("ping")) {
                MetaMatrixController.pingHostController(host);
                System.exit(0);
            }
            if (process == null) {
                MetaMatrixController.printUsage();
                System.exit(1);
            }
            if (command.equalsIgnoreCase("killProcess")) {
                MetaMatrixController.killProcess(host, process);
                System.exit(0);
            }
            if (command.equalsIgnoreCase("startHost")) {
                MetaMatrixController.startProcess(host, process);
                System.exit(0);
            }
            MetaMatrixController.printUsage();
            System.exit(1);
        }
        catch (Exception e) {
            MetaMatrixController.log(e, e.getMessage());
            System.exit(1);
        }
        finally {
            MetaMatrixController.disableLogging();
        }
        System.exit(0);
    }

    static /* synthetic */ void access$000(String x0) {
        MetaMatrixController.log(x0);
    }

    static {
        loggingEnabled = false;
        try {
            MetaMatrixController.refreshConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

