/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.common.lob.LobChunkReader;
import com.metamatrix.common.types.ClobType;
import com.metamatrix.common.types.InvalidReferenceException;
import com.metamatrix.core.log.Logger;
import com.metamatrix.dqp.message.CloseLobRequestMessage;
import com.metamatrix.dqp.message.LobRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMStatement;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class MMClob
implements Clob {
    private MMStatement statement;
    private ClobType srcClob;

    public static MMClob newInstance(MMStatement statement, ClobType clob) throws SQLException {
        if (AOP.useproxy()) {
            return (MMClob)ProxyFactory.extend(MMClob.class, (Class[])new Class[]{MMStatement.class, ClobType.class}, (Object[])new Object[]{statement, clob});
        }
        return new MMClob(statement, clob);
    }

    public MMClob(MMStatement statement, ClobType clob) throws SQLException {
        this.statement = statement;
        this.srcClob = clob;
    }

    public Logger getLogger() {
        return this.statement.getLogger();
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.getAsciiStream();
        }
        catch (InvalidReferenceException e) {
            try {
                LobReader in = new LobReader(this.statement, this.srcClob);
                return new ByteArrayInputStream(new String(in.getCharacterContents()).getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException e1) {
                throw new SQLException(e1.getMessage());
            }
        }
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.getCharacterStream();
        }
        catch (InvalidReferenceException e) {
            return new LobReader(this.statement, this.srcClob);
        }
    }

    public String getSubString(long pos, int length) throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.getSubString(pos, length);
        }
        catch (InvalidReferenceException e) {
            return this.internal_getSubString(pos, length);
        }
    }

    String internal_getSubString(long pos, int length) throws SQLException {
        char[] dataCopy = new char[length];
        if (pos < 1L) {
            Object[] params = new Object[]{new Long(pos)};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.0", params));
        }
        if (pos > this.length()) {
            return null;
        }
        if (length < 0) {
            Object[] params = new Object[]{new Integer(length)};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.1", params));
        }
        if (pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        LobReader in = new LobReader(this.statement, this.srcClob);
        char[] contents = in.getCharacterContents();
        System.arraycopy(contents, (int)pos, dataCopy, 0, length);
        return new String(dataCopy);
    }

    public long length() throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.length();
        }
        catch (InvalidReferenceException e) {
            return this.internal_length();
        }
    }

    long internal_length() throws SQLException {
        LobReader in = new LobReader(this.statement, this.srcClob);
        return in.getCharacterContents().length;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.position(searchstr, start);
        }
        catch (InvalidReferenceException e) {
            return this.internal_position(searchstr, start);
        }
    }

    long internal_position(Clob searchstr, long start) throws SQLException {
        if (searchstr == null || start > this.length()) {
            return -1L;
        }
        int length = (int)searchstr.length();
        String searchString = searchstr.getSubString(1L, length);
        return this.internal_position(searchString, start);
    }

    public long position(String searchstr, long start) throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.position(searchstr, start);
        }
        catch (InvalidReferenceException e) {
            return this.internal_position(searchstr, start);
        }
    }

    long internal_position(String searchstr, long start) throws SQLException {
        int position = 0;
        if (start < 1L) {
            Object[] params = new Object[]{new Long(start)};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.2", params));
        }
        if (searchstr == null || start > this.length()) {
            return -1L;
        }
        String patternStr = searchstr;
        LobReader in = new LobReader(this.statement, this.srcClob);
        String streamData = new String(in.getCharacterContents());
        position = streamData.indexOf(patternStr, (int)start - 1);
        if (position != -1) {
            ++position;
        }
        return position;
    }

    public String toString() {
        return this.internal_toString();
    }

    String internal_toString() {
        try {
            int c;
            StringBuffer buff = new StringBuffer();
            char[] chunk = new char[102400];
            Reader reader = this.getCharacterStream();
            while ((c = reader.read(chunk, 0, chunk.length)) != -1) {
                buff.append(chunk, 0, c);
            }
            return buff.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.setAsciiStream(pos);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.setCharacterStream(pos);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.setString(pos, str, offset, len);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public int setString(long pos, String str) throws SQLException {
        try {
            this.checkReference();
            return this.srcClob.setString(pos, str);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public void truncate(long len) throws SQLException {
        try {
            this.checkReference();
            this.srcClob.truncate(len);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkReference() {
        if (Boolean.getBoolean("FORCE_STREAMING")) {
            throw new InvalidReferenceException();
        }
    }

    static class LobReader
    extends LobChunkReader {
        static int counter = 0;

        public LobReader(final MMStatement statement, final ClobType clobReference) {
            super(new LobChunkProducer(){
                int streamRequestId = counter++;

                public LobChunk getNextChunk() throws IOException {
                    try {
                        LobRequestMessage request = new LobRequestMessage();
                        request.setStreamId(clobReference.getReferenceStreamId());
                        request.setStreamRequestId(this.streamRequestId);
                        request.setRequestID(new RequestID(statement.getCurrentRequestID()));
                        request.setMessageKey("LOB_" + Long.toString(statement.getCurrentRequestID()));
                        ResultsMessage message = (ResultsMessage)statement.executeAsynchAndWait((Message)request);
                        if (message.getException() != null) {
                            MetaMatrixException e = message.getException();
                            if (e instanceof IOException) {
                                throw (IOException)((Object)e);
                            }
                            throw new IOException(message.getException().getMessage());
                        }
                        return message.getLobChunk();
                    }
                    catch (SQLException e) {
                        IOException ex = new IOException(JDBCPlugin.Util.getString("StreamImpl.Unable_to_read_data_from_stream", (Object)e.getMessage()));
                        ex.initCause(e);
                        throw ex;
                    }
                }

                public void close() throws IOException {
                    try {
                        CloseLobRequestMessage request = new CloseLobRequestMessage();
                        request.setStreamId(clobReference.getReferenceStreamId());
                        request.setStreamRequestId(this.streamRequestId);
                        request.setRequestID(new RequestID(statement.getCurrentRequestID()));
                        request.setMessageKey("LOB_" + Long.toString(statement.getCurrentRequestID()));
                        statement.executeAsynch((Message)request);
                    }
                    catch (SQLException e) {
                        IOException ex = new IOException(e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                }
            });
        }
    }
}

