/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.optimizer.relational.rules.RuleImplementJoinStrategy;
import com.metamatrix.query.processor.relational.AccessNode;
import com.metamatrix.query.processor.relational.DependentCriteriaProcessor;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Query;
import java.util.Map;

public class DependentAccessNode
extends AccessNode {
    private int maxSetSize;
    private DependentCriteriaProcessor criteriaProcessor;
    private Criteria dependentCrit;
    private RuleImplementJoinStrategy.DependentSortController sortController;

    public DependentAccessNode(int nodeID) {
        super(nodeID);
    }

    public void close() throws MetaMatrixComponentException {
        if (this.isClosed()) {
            return;
        }
        super.close();
        if (this.criteriaProcessor != null) {
            this.criteriaProcessor.close();
        }
    }

    public void reset() {
        super.reset();
        this.criteriaProcessor = null;
        this.dependentCrit = null;
        if (this.sortController != null) {
            this.sortController.setShouldSort(false);
        }
    }

    public Object clone() {
        DependentAccessNode clonedNode = new DependentAccessNode(super.getID());
        clonedNode.maxSetSize = this.maxSetSize;
        clonedNode.sortController = this.sortController;
        super.copy((AccessNode)this, (AccessNode)clonedNode);
        return clonedNode;
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Dependent Access");
        props.put("sql", this.getCommand().toString());
        props.put("modelName", this.getModelName());
        return props;
    }

    public int getMaxSetSize() {
        return this.maxSetSize;
    }

    public void setMaxSetSize(int maxSize) {
        this.maxSetSize = maxSize;
    }

    protected boolean prepareNextCommand(Command atomicCommand) throws MetaMatrixComponentException {
        Assertion.assertTrue((boolean)(atomicCommand instanceof Query));
        Query query = (Query)atomicCommand;
        if (query.getCriteria() == null || this.maxSetSize < 1) {
            return super.prepareNextCommand(atomicCommand);
        }
        if (this.criteriaProcessor == null) {
            this.criteriaProcessor = new DependentCriteriaProcessor(this.maxSetSize, (RelationalNode)this, query.getCriteria());
        }
        if (this.dependentCrit == null) {
            this.dependentCrit = this.criteriaProcessor.prepareCriteria();
        }
        query.setCriteria(this.dependentCrit);
        if (this.sortController != null && !this.sortController.shouldSort() && this.criteriaProcessor.hasNextCommand()) {
            this.sortController.setShouldSort(true);
        }
        if (this.sortController != null && this.sortController.shouldSort()) {
            query.setOrderBy(null);
        }
        boolean result = super.prepareNextCommand((Command)query);
        this.dependentCrit = null;
        this.criteriaProcessor.consumedCriteria();
        return result;
    }

    protected boolean hasNextCommand() {
        return this.criteriaProcessor != null ? this.criteriaProcessor.hasNextCommand() : false;
    }

    public RuleImplementJoinStrategy.DependentSortController getSortController() {
        return this.sortController;
    }

    public void setSortController(RuleImplementJoinStrategy.DependentSortController sortController) {
        this.sortController = sortController;
    }
}

